/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.vedit.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.request.GetDirectEditResultRequest;
import com.volcengine.model.request.SubmitDirectEditTaskRequest;
import com.volcengine.model.request.SubmitTemplateTaskRequest;
import com.volcengine.model.response.GetDirectEditResultResponse;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.ResponseMetadata;
import com.volcengine.model.response.SubmitDirectEditTaskAsyncResponse;
import com.volcengine.model.response.SubmitTemplateTaskAsyncResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.vedit.IVEditService;
import com.volcengine.service.vedit.VEditConfig;
import java.util.ArrayList;
import org.apache.http.NameValuePair;

public class VEditServiceImpl
extends BaseServiceImpl
implements IVEditService {
    private VEditServiceImpl() {
        super(VEditConfig.serviceInfoMap.get("cn-north-1"), VEditConfig.apiInfoList);
    }

    private VEditServiceImpl(ServiceInfo serviceInfo) {
        super(serviceInfo, VEditConfig.apiInfoList);
    }

    public static IVEditService getInstance() {
        return new VEditServiceImpl();
    }

    public static IVEditService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = VEditConfig.serviceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("Edit not support region " + region);
        }
        return new VEditServiceImpl(serviceInfo);
    }

    @Override
    public SubmitDirectEditTaskAsyncResponse submitDirectEditTaskAsync(SubmitDirectEditTaskRequest submitDirectEditTaskRequest) throws Exception {
        RawResponse response = this.json("SubmitDirectEditTaskAsync", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)submitDirectEditTaskRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        SubmitDirectEditTaskAsyncResponse res = (SubmitDirectEditTaskAsyncResponse)JSON.parseObject((byte[])response.getData(), SubmitDirectEditTaskAsyncResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("edit");
        return res;
    }

    @Override
    public SubmitTemplateTaskAsyncResponse submitTemplateTaskAsync(SubmitTemplateTaskRequest submitTemplateTaskRequest) throws Exception {
        RawResponse response = this.json("SubmitTemplateTaskAsync", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)submitTemplateTaskRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        SubmitTemplateTaskAsyncResponse res = (SubmitTemplateTaskAsyncResponse)JSON.parseObject((byte[])response.getData(), SubmitTemplateTaskAsyncResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("edit");
        return res;
    }

    @Override
    public GetDirectEditResultResponse getDirectEditResult(GetDirectEditResultRequest getDirectEditResultRequest) throws Exception {
        RawResponse response = this.json("GetDirectEditResult", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)getDirectEditResultRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetDirectEditResultResponse res = (GetDirectEditResultResponse)JSON.parseObject((byte[])response.getData(), GetDirectEditResultResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("edit");
        return res;
    }
}

