/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.auth.impl;

import com.volcengine.auth.ISignerV4;
import com.volcengine.auth.MetaData;
import com.volcengine.helper.Utils;
import com.volcengine.model.Credentials;
import com.volcengine.service.SignableRequest;
import com.volcengine.util.NameValueComparator;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;

public class SignerV4Impl
implements ISignerV4 {
    private static final TimeZone tz;
    private static final Set<String> H_INCLUDE;
    private static final BitSet URLENCODER;
    private static final String CONST_ENCODE = "0123456789ABCDEF";

    @Override
    public void sign(SignableRequest request, Credentials credentials) throws Exception {
        this.signV4(request, credentials);
        request.setURI(request.getUriBuilder().build());
    }

    @Override
    public String signUrl(SignableRequest request, Credentials credentials) throws Exception {
        String formatDate = this.getCurrentFormatDate();
        String date = formatDate.substring(0, 8);
        MetaData meta = new MetaData();
        meta.setDate(date);
        meta.setService(credentials.getService());
        meta.setRegion(credentials.getRegion());
        meta.setSignedHeaders("");
        meta.setAlgorithm("HMAC-SHA256");
        meta.setCredentialScope(StringUtils.join((Object[])new String[]{meta.getDate(), meta.getRegion(), meta.getService(), "request"}, (String)"/"));
        URIBuilder builder = request.getUriBuilder();
        builder.setParameter("X-Date", formatDate);
        builder.setParameter("X-NotSignBody", "");
        builder.setParameter("X-Credential", credentials.getAccessKeyID() + "/" + meta.getCredentialScope());
        builder.setParameter("X-Algorithm", meta.getAlgorithm());
        builder.setParameter("X-SignedHeaders", meta.getSignedHeaders());
        builder.setParameter("X-SignedQueries", "");
        ArrayList<String> keys = new ArrayList<String>();
        for (NameValuePair pair : builder.getQueryParams()) {
            keys.add(pair.getName());
        }
        Collections.sort(keys);
        builder.setParameter("X-SignedQueries", StringUtils.join(keys, (String)";"));
        String hashedCanonReq = this.hashedSimpleCanonicalRequestV4(request, meta);
        String stringToSign = StringUtils.join((Object[])new String[]{meta.getAlgorithm(), formatDate, meta.getCredentialScope(), hashedCanonReq}, (String)"\n");
        byte[] signingKey = this.genSigningSecretKeyV4(credentials.getSecretAccessKey(), meta.getDate(), meta.getRegion(), meta.getService());
        String signature = this.signatureV4(signingKey, stringToSign);
        builder.setParameter("X-Signature", signature);
        return builder.build().toURL().getQuery();
    }

    private void signV4(SignableRequest request, Credentials credentials) throws Exception {
        URIBuilder builder = request.getUriBuilder();
        if (builder.getPath().equals("")) {
            builder.setPath(builder.getPath() + "/");
        }
        request.setHeader("Host", request.getUriBuilder().getHost());
        if (request.getHeaders("Content-Type") == null) {
            request.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        }
        String formatDate = this.getCurrentFormatDate();
        request.setHeader("X-Date", formatDate);
        MetaData meta = new MetaData();
        meta.setAlgorithm("HMAC-SHA256");
        meta.setService(credentials.getService());
        meta.setRegion(credentials.getRegion());
        meta.setDate(this.toDate(formatDate));
        String hashedCanonReq = this.hashedCanonicalRequestV4(request, meta);
        meta.setCredentialScope(StringUtils.join((Object[])new String[]{meta.getDate(), meta.getRegion(), meta.getService(), "request"}, (String)"/"));
        String stringToSign = StringUtils.join((Object[])new String[]{meta.getAlgorithm(), formatDate, meta.getCredentialScope(), hashedCanonReq}, (String)"\n");
        byte[] signingKey = this.genSigningSecretKeyV4(credentials.getSecretAccessKey(), meta.getDate(), meta.getRegion(), meta.getService());
        String signature = Hex.encodeHexString((byte[])Utils.hmacSHA256(signingKey, stringToSign));
        request.setHeader("Authorization", this.buildAuthHeaderV4(signature, meta, credentials));
    }

    private String hashedSimpleCanonicalRequestV4(SignableRequest request, MetaData meta) throws Exception {
        String payloadHash = Utils.hashSHA256(new byte[0]);
        URIBuilder builder = request.getUriBuilder();
        if (builder.getPath().equals("")) {
            builder.setPath("/");
        }
        String canonicalRequest = StringUtils.join((Object[])new String[]{request.getMethod(), this.normUri(builder.getPath()), this.normQuery(builder.getQueryParams()), "\n", meta.getSignedHeaders(), payloadHash}, (String)"\n");
        return Utils.hashSHA256(canonicalRequest.getBytes());
    }

    private String hashedCanonicalRequestV4(SignableRequest request, MetaData meta) throws Exception {
        HttpEntity entity = request.getEntity();
        byte[] body = entity == null ? new byte[]{} : EntityUtils.toByteArray((HttpEntity)entity);
        String bodyHash = Utils.hashSHA256(body);
        request.setHeader("X-Content-Sha256", bodyHash);
        ArrayList<String> signedHeaders = new ArrayList<String>();
        for (Header header : request.getAllHeaders()) {
            String headerName = header.getName();
            if (!H_INCLUDE.contains(headerName) && !headerName.startsWith("X-")) continue;
            signedHeaders.add(headerName.toLowerCase());
        }
        Collections.sort(signedHeaders);
        StringBuilder signedHeadersToSignStr = new StringBuilder();
        for (String h : signedHeaders) {
            String[] split;
            String port;
            String value = request.getFirstHeader(h).getValue().trim();
            if (h.equals("host") && value.contains(":") && ((port = (split = value.split(":"))[1]).equals("80") || port.equals("443"))) {
                value = split[0];
            }
            signedHeadersToSignStr.append(h).append(":").append(value).append("\n");
        }
        meta.setSignedHeaders(StringUtils.join(signedHeaders, (String)";"));
        String canonicalRequest = StringUtils.join((Object[])new String[]{request.getMethod(), this.normUri(request.getUriBuilder().getPath()), this.normQuery(request.getUriBuilder().getQueryParams()), signedHeadersToSignStr.toString(), meta.getSignedHeaders(), bodyHash}, (String)"\n");
        return Utils.hashSHA256(canonicalRequest.getBytes());
    }

    private String signatureV4(byte[] signingKey, String stringToSign) throws Exception {
        return Hex.encodeHexString((byte[])Utils.hmacSHA256(signingKey, stringToSign));
    }

    private byte[] genSigningSecretKeyV4(String secretKey, String date, String region, String service) throws Exception {
        byte[] kDate = Utils.hmacSHA256(secretKey.getBytes(), date);
        byte[] kRegion = Utils.hmacSHA256(kDate, region);
        byte[] kService = Utils.hmacSHA256(kRegion, service);
        return Utils.hmacSHA256(kService, "request");
    }

    private String buildAuthHeaderV4(String signature, MetaData meta, Credentials credentials) {
        String credential = credentials.getAccessKeyID() + "/" + meta.getCredentialScope();
        return meta.getAlgorithm() + " Credential=" + credential + ", SignedHeaders=" + meta.getSignedHeaders() + ", Signature=" + signature;
    }

    private String getCurrentFormatDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(tz);
        return df.format(new Date());
    }

    private String toDate(String timestamp) {
        return timestamp.substring(0, 8);
    }

    private String normUri(String path) {
        Object[] parts = path.split("/", -1);
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = this.signStringEncoder((String)parts[i]);
        }
        return StringUtils.join((Object[])parts, (String)"/");
    }

    private String normQuery(List<NameValuePair> params) {
        params.sort(NameValueComparator.INSTANCE);
        return this.signQueryEncoder(params);
    }

    private String signQueryEncoder(List<NameValuePair> params) {
        StringBuilder result = new StringBuilder();
        for (NameValuePair pair : params) {
            String encodedName = this.signStringEncoder(pair.getName());
            String encodedValue = this.signStringEncoder(pair.getValue());
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName);
            if (encodedValue == null) continue;
            result.append("=");
            result.append(encodedValue);
        }
        return result.toString();
    }

    private String signStringEncoder(String source) {
        if (source == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(source.length());
        ByteBuffer bb = Consts.UTF_8.encode(source);
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (URLENCODER.get(b)) {
                buf.append((char)b);
                continue;
            }
            if (b == 32) {
                buf.append("%20");
                continue;
            }
            buf.append("%");
            char hex1 = CONST_ENCODE.charAt(b >> 4);
            char hex2 = CONST_ENCODE.charAt(b & 0xF);
            buf.append(hex1);
            buf.append(hex2);
        }
        return buf.toString();
    }

    static {
        int i;
        tz = TimeZone.getTimeZone("UTC");
        H_INCLUDE = new HashSet<String>();
        URLENCODER = new BitSet(256);
        H_INCLUDE.add("Content-Type");
        H_INCLUDE.add("Content-Md5");
        H_INCLUDE.add("Host");
        for (i = 97; i <= 122; ++i) {
            URLENCODER.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            URLENCODER.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URLENCODER.set(i);
        }
        URLENCODER.set(45);
        URLENCODER.set(95);
        URLENCODER.set(46);
        URLENCODER.set(126);
    }
}

