/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.cms.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.request.ArticleFeedRequest;
import com.volcengine.model.request.ArticleGetVideoRequest;
import com.volcengine.model.request.ArticleMGetVideoRequest;
import com.volcengine.model.response.ArticleFeedResponse;
import com.volcengine.model.response.ArticleGetVideoResponse;
import com.volcengine.model.response.ArticleMGetVideoResponse;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.ResponseMetadata;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.cms.CmsApiService;
import com.volcengine.service.cms.CmsConfig;
import java.util.ArrayList;
import org.apache.http.NameValuePair;

public class CmsApiServiceImpl
extends BaseServiceImpl
implements CmsApiService {
    private CmsApiServiceImpl() {
        super(CmsConfig.apiServiceInfoMap.get("cn-north-1"), CmsConfig.apiApiInfoMap);
    }

    private CmsApiServiceImpl(ServiceInfo serviceInfo) {
        super(serviceInfo, CmsConfig.apiApiInfoMap);
    }

    public static CmsApiService getInstance() {
        return new CmsApiServiceImpl();
    }

    public static CmsApiService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = CmsConfig.apiServiceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("Edit not support region " + region);
        }
        return new CmsApiServiceImpl(serviceInfo);
    }

    @Override
    public ArticleFeedResponse feed(ArticleFeedRequest articleFeedRequest) throws Exception {
        RawResponse response = this.json("Feed", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)articleFeedRequest));
        return this.getFeedResult(response);
    }

    @Override
    public ArticleGetVideoResponse getVideoByVid(ArticleGetVideoRequest articleGetVideoRequest) throws Exception {
        RawResponse response = this.json("GetVideoByVid", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)articleGetVideoRequest));
        return this.getVideoResult(response);
    }

    @Override
    public ArticleMGetVideoResponse mGetVideoByVids(ArticleMGetVideoRequest mGetVideoRequest) throws Exception {
        RawResponse response = this.json("MGetVideoByVids", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)mGetVideoRequest));
        return this.mGetVideoResult(response);
    }

    private ArticleFeedResponse getFeedResult(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ArticleFeedResponse res = (ArticleFeedResponse)JSON.parseObject((byte[])response.getData(), ArticleFeedResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata() != null && res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        if (res.getBaseResp() != null && res.getBaseResp().getStatusCode() != 1000) {
            ArticleFeedResponse.BaseResp baseResp = res.getBaseResp();
            throw new Exception("error: " + baseResp.getStatusMessage());
        }
        return res;
    }

    private ArticleGetVideoResponse getVideoResult(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ArticleGetVideoResponse res = (ArticleGetVideoResponse)JSON.parseObject((byte[])response.getData(), ArticleGetVideoResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata() != null && res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        if (res.getBaseResp() != null && res.getBaseResp().getStatusCode() != 1000) {
            ArticleGetVideoResponse.BaseResp baseResp = res.getBaseResp();
            throw new Exception("error: " + baseResp.getStatusMessage());
        }
        return res;
    }

    private ArticleMGetVideoResponse mGetVideoResult(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ArticleMGetVideoResponse res = (ArticleMGetVideoResponse)JSON.parseObject((byte[])response.getData(), ArticleMGetVideoResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata() != null && res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        if (res.getBaseResp() != null && res.getBaseResp().getStatusCode() != 1000) {
            ArticleMGetVideoResponse.BaseResp baseResp = res.getBaseResp();
            throw new Exception("error: " + baseResp.getStatusMessage());
        }
        return res;
    }
}

