/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.cms.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.request.ArticleCreateRequest;
import com.volcengine.model.request.ArticleDeleteByOpenidRequest;
import com.volcengine.model.request.ArticleDeleteRequest;
import com.volcengine.model.request.ArticleEventNotifyRequest;
import com.volcengine.model.request.ArticleUploadDetailRequest;
import com.volcengine.model.response.ArticleCreateResponse;
import com.volcengine.model.response.ArticleDeleteByOpenidResponse;
import com.volcengine.model.response.ArticleDeleteResponse;
import com.volcengine.model.response.ArticleEventNotifyResponse;
import com.volcengine.model.response.ArticleUploadDetailResponse;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.ResponseMetadata;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.cms.CmsConfig;
import com.volcengine.service.cms.CmsPlatformService;
import java.util.ArrayList;
import org.apache.http.NameValuePair;

public class CmsPlatformServiceImpl
extends BaseServiceImpl
implements CmsPlatformService {
    private CmsPlatformServiceImpl() {
        super(CmsConfig.platformServiceInfoMap.get("cn-north-1"), CmsConfig.platformApiInfoMap);
    }

    private CmsPlatformServiceImpl(ServiceInfo serviceInfo) {
        super(serviceInfo, CmsConfig.platformApiInfoMap);
    }

    public static CmsPlatformService getInstance() {
        return new CmsPlatformServiceImpl();
    }

    public static CmsPlatformService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = CmsConfig.platformServiceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("Edit not support region " + region);
        }
        return new CmsPlatformServiceImpl(serviceInfo);
    }

    @Override
    public ArticleCreateResponse batchCreateSourceArticle(ArticleCreateRequest articleCreateRequest) throws Exception {
        RawResponse rawResponse = this.json("BatchCreateSourceArticle", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)articleCreateRequest));
        return this.getBatchCreateSourceArticle(rawResponse);
    }

    @Override
    public ArticleUploadDetailResponse getArticleBatchUploadDetail(ArticleUploadDetailRequest articleUploadDetailRequest) throws Exception {
        RawResponse rawResponse = this.json("GetArticleBatchUploadDetail", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)articleUploadDetailRequest));
        return this.getUploadDetail(rawResponse);
    }

    @Override
    public ArticleDeleteResponse deleteSourceArticle(ArticleDeleteRequest articleDeleteRequest) throws Exception {
        RawResponse rawResponse = this.json("DeleteSourceArticle", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)articleDeleteRequest));
        return this.getDeleteArticle(rawResponse);
    }

    @Override
    public ArticleDeleteByOpenidResponse deleteSourceArticleByOpenid(ArticleDeleteByOpenidRequest articleDeleteByOpenidRequest) throws Exception {
        RawResponse rawResponse = this.json("DeleteSourceArticleByOpenid", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)articleDeleteByOpenidRequest));
        return this.getDeleteArticleByOpenid(rawResponse);
    }

    @Override
    public ArticleEventNotifyResponse articleEventNotify(ArticleEventNotifyRequest articleEventNotifyRequest) throws Exception {
        RawResponse rawResponse = this.json("ArticleEventNotify", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)articleEventNotifyRequest));
        return this.getArticleEventNotify(rawResponse);
    }

    private ArticleCreateResponse getBatchCreateSourceArticle(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ArticleCreateResponse res = (ArticleCreateResponse)JSON.parseObject((byte[])response.getData(), ArticleCreateResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    private ArticleUploadDetailResponse getUploadDetail(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ArticleUploadDetailResponse res = (ArticleUploadDetailResponse)JSON.parseObject((byte[])response.getData(), ArticleUploadDetailResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    private ArticleDeleteResponse getDeleteArticle(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ArticleDeleteResponse res = (ArticleDeleteResponse)JSON.parseObject((byte[])response.getData(), ArticleDeleteResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    private ArticleDeleteByOpenidResponse getDeleteArticleByOpenid(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ArticleDeleteByOpenidResponse res = (ArticleDeleteByOpenidResponse)JSON.parseObject((byte[])response.getData(), ArticleDeleteByOpenidResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    private ArticleEventNotifyResponse getArticleEventNotify(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ArticleEventNotifyResponse res = (ArticleEventNotifyResponse)JSON.parseObject((byte[])response.getData(), ArticleEventNotifyResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }
}

