/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.contentSecurity.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.request.CreateCustomContentsRequest;
import com.volcengine.model.request.ImageRiskResultRequest;
import com.volcengine.model.request.RiskDetectionRequest;
import com.volcengine.model.request.UploadCustomContentsRequest;
import com.volcengine.model.response.AsyncRiskDetectionResponse;
import com.volcengine.model.response.ImageRiskDetectionResponse;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.TextRiskResponse;
import com.volcengine.model.response.VideoRiskResultResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.contentSecurity.ContentSecurityConfig;
import com.volcengine.service.contentSecurity.ContentSecurityService;
import java.util.ArrayList;
import org.apache.http.NameValuePair;

public class ContentSecurityServiceImpl
extends BaseServiceImpl
implements ContentSecurityService {
    private static final ContentSecurityServiceImpl contentSecurityInstance = new ContentSecurityServiceImpl();

    private ContentSecurityServiceImpl() {
        super(ContentSecurityConfig.serviceInfo, ContentSecurityConfig.apiInfoList);
    }

    public static ContentSecurityService getInstance() {
        return contentSecurityInstance;
    }

    @Override
    public ImageRiskDetectionResponse ImageRiskDetection(RiskDetectionRequest riskDetectionRequest) throws Exception {
        RawResponse response = this.json("ImageContentRisk", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ImageRiskDetectionResponse)JSON.parseObject((byte[])response.getData(), ImageRiskDetectionResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public AsyncRiskDetectionResponse AsyncImageRisk(RiskDetectionRequest riskDetectionRequest) throws Exception {
        RawResponse response = this.json("ImageContentRisk", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (AsyncRiskDetectionResponse)JSON.parseObject((byte[])response.getData(), AsyncRiskDetectionResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ImageRiskDetectionResponse ImageRiskResult(ImageRiskResultRequest riskDetectionRequest) throws Exception {
        RawResponse response = this.query("GetImageResult", Utils.mapToPairList(Utils.paramsToMap(riskDetectionRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ImageRiskDetectionResponse)JSON.parseObject((byte[])response.getData(), ImageRiskDetectionResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public AsyncRiskDetectionResponse AsyncVideoRisk(RiskDetectionRequest riskDetectionRequest) throws Exception {
        RawResponse response = this.json("AsyncVideoRisk", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (AsyncRiskDetectionResponse)JSON.parseObject((byte[])response.getData(), AsyncRiskDetectionResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public VideoRiskResultResponse VideoResult(ImageRiskResultRequest videoRiskResultRequest) throws Exception {
        RawResponse response = this.query("VideoResult", Utils.mapToPairList(Utils.paramsToMap(videoRiskResultRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (VideoRiskResultResponse)JSON.parseObject((byte[])response.getData(), VideoRiskResultResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public TextRiskResponse TextRisk(RiskDetectionRequest riskDetectionRequest) throws Exception {
        RawResponse response = this.json("TextRisk", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        String str = new String(response.getData());
        System.out.println(str);
        return (TextRiskResponse)JSON.parseObject((byte[])response.getData(), TextRiskResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public AsyncRiskDetectionResponse CreateCustomContents(CreateCustomContentsRequest request) throws Exception {
        RawResponse response = this.json("CreateCustomContents", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (AsyncRiskDetectionResponse)JSON.parseObject((byte[])response.getData(), AsyncRiskDetectionResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public AsyncRiskDetectionResponse UploadCustomContents(UploadCustomContentsRequest request) throws Exception {
        RawResponse response = this.json("UploadCustomContents", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (AsyncRiskDetectionResponse)JSON.parseObject((byte[])response.getData(), AsyncRiskDetectionResponse.class, (Feature[])new Feature[0]);
    }
}

