/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.iam.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.request.iam.ListUsersRequest;
import com.volcengine.model.request.iam.RoleCreateRequest;
import com.volcengine.model.request.iam.RoleDeleteRequest;
import com.volcengine.model.request.iam.RoleGetRequest;
import com.volcengine.model.request.iam.RoleListRequest;
import com.volcengine.model.request.iam.RoleUpdateRequest;
import com.volcengine.model.response.CommonResponse;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.iam.ListUsersResponse;
import com.volcengine.model.response.iam.RoleGetResponse;
import com.volcengine.model.response.iam.RoleListResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.iam.IIamService;
import com.volcengine.service.iam.IamConfig;

public class IamServiceImpl
extends BaseServiceImpl
implements IIamService {
    private IamServiceImpl() {
        super(IamConfig.serviceInfo, IamConfig.apiInfoList);
    }

    public static IIamService getInstance() {
        return new IamServiceImpl();
    }

    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws Exception {
        RawResponse response = this.query("ListUsers", Utils.mapToPairList(Utils.paramsToMap(listUsersRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListUsersResponse)JSON.parseObject((byte[])response.getData(), ListUsersResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RoleGetResponse createRole(RoleCreateRequest roleCreateRequest) throws Exception {
        RawResponse response = this.query("CreateRole", Utils.mapToPairList(Utils.paramsToMap(roleCreateRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RoleGetResponse)JSON.parseObject((byte[])response.getData(), RoleGetResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RoleGetResponse getRole(RoleGetRequest roleGetRequest) throws Exception {
        RawResponse response = this.query("GetRole", Utils.mapToPairList(Utils.paramsToMap(roleGetRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RoleGetResponse)JSON.parseObject((byte[])response.getData(), RoleGetResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RoleListResponse listRoles(RoleListRequest roleListRequest) throws Exception {
        RawResponse response = this.query("ListRoles", Utils.mapToPairList(Utils.paramsToMap(roleListRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RoleListResponse)JSON.parseObject((byte[])response.getData(), RoleListResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CommonResponse updateRole(RoleUpdateRequest roleUpdateRequest) throws Exception {
        RawResponse response = this.query("UpdateRole", Utils.mapToPairList(Utils.paramsToMap(roleUpdateRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CommonResponse)JSON.parseObject((byte[])response.getData(), CommonResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CommonResponse deleteRole(RoleDeleteRequest roleDeleteRequest) throws Exception {
        RawResponse response = this.query("DeleteRole", Utils.mapToPairList(Utils.paramsToMap(roleDeleteRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CommonResponse)JSON.parseObject((byte[])response.getData(), CommonResponse.class, (Feature[])new Feature[0]);
    }
}

