/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.imagex.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.request.ApplyImageUploadRequest;
import com.volcengine.model.request.CommitImageUploadRequest;
import com.volcengine.model.request.CommitImageUploadRequestBody;
import com.volcengine.model.request.DeleteImageReq;
import com.volcengine.model.request.EmbedImageHmRequest;
import com.volcengine.model.request.ExtractImageHmRequest;
import com.volcengine.model.request.UpdateImageFilesRequest;
import com.volcengine.model.response.ApplyImageUploadResponse;
import com.volcengine.model.response.CommitImageUploadResponse;
import com.volcengine.model.response.CommonResponse;
import com.volcengine.model.response.DeleteImageResp;
import com.volcengine.model.response.EmbedImageHmResponse;
import com.volcengine.model.response.ExtractImageHmResponse;
import com.volcengine.model.response.GetImageOCRResponse;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.ResponseMetadata;
import com.volcengine.model.response.UpdateImageFilesResponse;
import com.volcengine.model.sts2.Policy;
import com.volcengine.model.sts2.SecurityToken2;
import com.volcengine.model.sts2.Statement;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.imagex.IImageXService;
import com.volcengine.service.imagex.ImageXConfig;
import com.volcengine.util.Sts2Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class ImageXServiceImpl
extends BaseServiceImpl
implements IImageXService {
    private ImageXServiceImpl() {
        super(ImageXConfig.serviceInfoMap.get("cn-north-1"), ImageXConfig.apiInfoList);
    }

    private ImageXServiceImpl(ServiceInfo serviceInfo) {
        super(serviceInfo, ImageXConfig.apiInfoList);
    }

    public static IImageXService getInstance() {
        return new ImageXServiceImpl();
    }

    public static IImageXService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = ImageXConfig.serviceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("ImageX not support region " + region);
        }
        return new ImageXServiceImpl(serviceInfo);
    }

    @Override
    public ApplyImageUploadResponse applyImageUpload(ApplyImageUploadRequest req) throws Exception {
        RawResponse response = this.query("ApplyImageUpload", Utils.paramsToPair(req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ApplyImageUploadResponse res = (ApplyImageUploadResponse)JSON.parseObject((byte[])response.getData(), ApplyImageUploadResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public CommitImageUploadResponse commitImageUpload(CommitImageUploadRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        CommitImageUploadRequestBody reqBody = new CommitImageUploadRequestBody();
        reqBody.setSessionKey(req.getSessionKey());
        reqBody.setOptionInfos(req.getOptionInfos());
        RawResponse response = this.json("CommitImageUpload", Utils.mapToPairList(params), JSON.toJSONString((Object)reqBody));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        CommitImageUploadResponse res = (CommitImageUploadResponse)JSON.parseObject((byte[])response.getData(), CommitImageUploadResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    private void doUpload(String host, ApplyImageUploadResponse.StoreInfosBean storeInfo, byte[] imageData) throws Exception {
        long crc32 = Utils.crc32(imageData);
        String checkSum = String.format("%08x", crc32);
        String url = String.format("https://%s/%s", host, storeInfo.getStoreUri());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-CRC32", checkSum);
        headers.put("Authorization", storeInfo.getAuth());
        long startTime = System.currentTimeMillis();
        boolean uploadStatus = false;
        for (int i = 0; i < 3 && !(uploadStatus = this.putData(url, imageData, headers)); ++i) {
        }
        if (!uploadStatus) {
            throw new Exception(String.format("upload image %s msg %s", url, SdkError.getErrorDesc(SdkError.EUPLOAD)));
        }
        long endTime = System.currentTimeMillis();
        long cost = endTime - startTime;
        float avgSpeed = (float)imageData.length / (float)cost;
        System.out.println(String.format("upload image cost {%d} ms, avgSpeed: {%f} KB/s", cost, Float.valueOf(avgSpeed)));
    }

    @Override
    public CommitImageUploadResponse uploadImages(ApplyImageUploadRequest request, List<byte[]> imageDatas) throws Exception {
        if (imageDatas.size() == 0) {
            throw new Exception("empty image data");
        }
        request.setUploadNum(imageDatas.size());
        ApplyImageUploadResponse applyResp = this.applyImageUpload(request);
        if (applyResp.getResult() == null) {
            throw new Exception("apply upload result is null");
        }
        ApplyImageUploadResponse.UploadAddressBean uploadAddr = applyResp.getResult().getUploadAddress();
        if (uploadAddr == null || uploadAddr.getUploadHosts() == null || uploadAddr.getUploadHosts().size() == 0) {
            throw new Exception("apply upload address is null");
        }
        List<ApplyImageUploadResponse.StoreInfosBean> storeInfos = uploadAddr.getStoreInfos();
        if (storeInfos.size() != imageDatas.size()) {
            throw new Exception("apply upload get wrong store infos");
        }
        String uploadHost = uploadAddr.getUploadHosts().get(0);
        String sessionKey = uploadAddr.getSessionKey();
        for (int i = 0; i < imageDatas.size(); ++i) {
            this.doUpload(uploadHost, storeInfos.get(i), imageDatas.get(i));
        }
        CommitImageUploadRequest commitRequest = new CommitImageUploadRequest();
        commitRequest.setServiceId(request.getServiceId());
        commitRequest.setSessionKey(sessionKey);
        if (request.getCommitParam() != null) {
            commitRequest.setFunctions(request.getCommitParam().getFunctions());
            commitRequest.setOptionInfos(request.getCommitParam().getOptionInfos());
        }
        return this.commitImageUpload(commitRequest);
    }

    @Override
    public String getUploadToken(Map<String, String> params) throws Exception {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Version", "v1");
        List<NameValuePair> pairs = Utils.mapToPairList(params);
        String applyUploadToken = this.getSignUrl("ApplyImageUpload", pairs);
        ret.put("ApplyUploadToken", applyUploadToken);
        String commitUploadToken = this.getSignUrl("CommitImageUpload", pairs);
        ret.put("CommitUploadToken", commitUploadToken);
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public SecurityToken2 getUploadSts2(List<String> serviceIds) throws Exception {
        return this.getUploadSts2WithKeyPtn(serviceIds, 3600000L, "");
    }

    @Override
    public SecurityToken2 getUploadSts2WithExpire(List<String> serviceIds, long expire) throws Exception {
        return this.getUploadSts2WithKeyPtn(serviceIds, expire, "");
    }

    @Override
    public SecurityToken2 getUploadSts2WithKeyPtn(List<String> serviceIds, long expire, String keyPtn) throws Exception {
        ArrayList<String> applyRes = new ArrayList<String>();
        ArrayList<String> commitRes = new ArrayList<String>();
        if (serviceIds.size() == 0) {
            applyRes.add(String.format("trn:ImageX:*:*:ServiceId/%s", "*"));
            commitRes.add(String.format("trn:ImageX:*:*:ServiceId/%s", "*"));
        } else {
            for (String serviceId : serviceIds) {
                applyRes.add(String.format("trn:ImageX:*:*:ServiceId/%s", serviceId));
                commitRes.add(String.format("trn:ImageX:*:*:ServiceId/%s", serviceId));
            }
        }
        applyRes.add(String.format("trn:ImageX:*:*:StoreKeys/%s", keyPtn));
        Policy inlinePolicy = new Policy();
        Statement applyStatement = Sts2Utils.newAllowStatement(Arrays.asList("ImageX:ApplyImageUpload"), applyRes);
        Statement commitStatement = Sts2Utils.newAllowStatement(Arrays.asList("ImageX:CommitImageUpload"), commitRes);
        inlinePolicy.addStatement(applyStatement);
        inlinePolicy.addStatement(commitStatement);
        return this.signSts2(inlinePolicy, expire);
    }

    @Override
    public DeleteImageResp deleteImages(DeleteImageReq req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("DeleteImageUploadFiles", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DeleteImageResp res = (DeleteImageResp)JSON.parseObject((byte[])response.getData(), DeleteImageResp.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public UpdateImageFilesResponse updateImageUrls(UpdateImageFilesRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("UpdateImageUploadFiles", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        UpdateImageFilesResponse res = (UpdateImageFilesResponse)JSON.parseObject((byte[])response.getData(), UpdateImageFilesResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public CommonResponse getImageX(String action, Map<String, String> param) throws Exception {
        RawResponse response = this.query(action, Utils.mapToPairList(param));
        return this.parseRawRes(response);
    }

    @Override
    public CommonResponse postImageX(String action, Map<String, String> param, Object req) throws Exception {
        RawResponse response = this.json(action, Utils.mapToPairList(param), JSON.toJSONString((Object)req));
        return this.parseRawRes(response);
    }

    private CommonResponse parseRawRes(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        CommonResponse res = (CommonResponse)JSON.parseObject((byte[])response.getData(), CommonResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public GetImageOCRResponse getImageOCR(Map<String, String> param) throws Exception {
        RawResponse response = this.query("GetImageOCR", Utils.mapToPairList(param));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageOCRResponse res = (GetImageOCRResponse)JSON.parseObject((byte[])response.getData(), GetImageOCRResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public EmbedImageHmResponse embedImageHm(EmbedImageHmRequest req) throws Exception {
        RawResponse response = this.json("CreateImageHmEmbed", null, JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        EmbedImageHmResponse res = (EmbedImageHmResponse)JSON.parseObject((byte[])response.getData(), EmbedImageHmResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public ExtractImageHmResponse extractImageHm(ExtractImageHmRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        params.put("StoreUri", req.getStoreUri());
        params.put("Strength", Integer.toString(req.getStrength()));
        RawResponse response = this.query("CreateImageHmExtract", Utils.mapToPairList(params));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ExtractImageHmResponse res = (ExtractImageHmResponse)JSON.parseObject((byte[])response.getData(), ExtractImageHmResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }
}

