/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.stream.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.stream.CheckRelationRequest;
import com.volcengine.model.stream.CheckRelationResponse;
import com.volcengine.model.stream.CommonPo;
import com.volcengine.model.stream.DiggRequest;
import com.volcengine.model.stream.DiggResponse;
import com.volcengine.model.stream.FeedBackRequest;
import com.volcengine.model.stream.FeedBackResponse;
import com.volcengine.model.stream.FollowArticlesRequest;
import com.volcengine.model.stream.FollowArticlesResponse;
import com.volcengine.model.stream.FollowRequest;
import com.volcengine.model.stream.FollowResponse;
import com.volcengine.model.stream.GetArticleRequest;
import com.volcengine.model.stream.GetArticleResponse;
import com.volcengine.model.stream.GetArticlesRequest;
import com.volcengine.model.stream.GetArticlesResponse;
import com.volcengine.model.stream.GetDiggListRequest;
import com.volcengine.model.stream.GetDiggListResponse;
import com.volcengine.model.stream.GetFollowingListRequest;
import com.volcengine.model.stream.GetFollowingListResponse;
import com.volcengine.model.stream.GetListRequest;
import com.volcengine.model.stream.GetListResponse;
import com.volcengine.model.stream.GetUnionProductRequest;
import com.volcengine.model.stream.GetUnionProductResponse;
import com.volcengine.model.stream.GetVideoUrlRequest;
import com.volcengine.model.stream.GetVideoUrlResponse;
import com.volcengine.model.stream.HotBoardRequest;
import com.volcengine.model.stream.HotBoardResponse;
import com.volcengine.model.stream.RecommendCategoryInfoRequest;
import com.volcengine.model.stream.RecommendCategoryInfoResponse;
import com.volcengine.model.stream.RecommendCategoryUserRequest;
import com.volcengine.model.stream.RecommendCategoryUserResponse;
import com.volcengine.model.stream.RecommendRelatedUserRequest;
import com.volcengine.model.stream.RecommendRelatedUserResponse;
import com.volcengine.model.stream.RefreshTipsRequest;
import com.volcengine.model.stream.RefreshTipsResponse;
import com.volcengine.model.stream.RelatedArticleRequest;
import com.volcengine.model.stream.RelatedArticleResponse;
import com.volcengine.model.stream.UnfollowRequest;
import com.volcengine.model.stream.UnfollowResponse;
import com.volcengine.model.stream.WapRegisterRequest;
import com.volcengine.model.stream.WapRegisterResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.stream.StreamConfig;
import com.volcengine.service.stream.StreamService;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpHost;

public class StreamServiceImpl
extends BaseServiceImpl
implements StreamService {
    private StreamServiceImpl() {
        super(StreamConfig.serviceInfo, StreamConfig.apiInfoList);
    }

    private StreamServiceImpl(HttpHost proxy) {
        super(StreamConfig.serviceInfo, proxy, StreamConfig.apiInfoList);
    }

    public static StreamService getInstance() {
        return new StreamServiceImpl();
    }

    public static StreamService getInstance(HttpHost proxy) {
        return new StreamServiceImpl(proxy);
    }

    @Override
    public WapRegisterResponse wapRegister(WapRegisterRequest wapRegisterRequest) throws Exception {
        RawResponse response = this.query("WapRegister", Utils.mapToPairList(Utils.paramsToMap(wapRegisterRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (WapRegisterResponse)JSON.parseObject((byte[])response.getData(), WapRegisterResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetListResponse getList(GetListRequest getListRequest) throws Exception {
        RawResponse response = this.query("ContentStream", Utils.mapToPairList(Utils.paramsToMap(getListRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetListResponse)JSON.parseObject((byte[])response.getData(), GetListResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DiggResponse digg(DiggRequest diggRequest) throws Exception {
        RawResponse response = this.query("Digg", Utils.mapToPairList(Utils.paramsToMap(diggRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DiggResponse)JSON.parseObject((byte[])response.getData(), DiggResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DiggResponse bury(DiggRequest diggRequest) throws Exception {
        RawResponse response = this.query("Bury", Utils.mapToPairList(Utils.paramsToMap(diggRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DiggResponse)JSON.parseObject((byte[])response.getData(), DiggResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DiggResponse unDigg(DiggRequest diggRequest) throws Exception {
        RawResponse response = this.query("UnDigg", Utils.mapToPairList(Utils.paramsToMap(diggRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DiggResponse)JSON.parseObject((byte[])response.getData(), DiggResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DiggResponse unBury(DiggRequest diggRequest) throws Exception {
        RawResponse response = this.query("UnBury", Utils.mapToPairList(Utils.paramsToMap(diggRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DiggResponse)JSON.parseObject((byte[])response.getData(), DiggResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetArticleResponse getArticle(GetArticleRequest getArticleRequest) throws Exception {
        RawResponse response = this.query("SingleArticleInfo", Utils.mapToPairList(Utils.paramsToMap(getArticleRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetArticleResponse)JSON.parseObject((byte[])response.getData(), GetArticleResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetArticlesResponse getArticles(GetArticlesRequest getArticlesRequest) throws Exception {
        RawResponse response = this.query("MultiArticleInfo", Utils.mapToPairList(Utils.paramsToMap(getArticlesRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        String jsonString = new String(response.getData());
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        GetArticlesResponse getArticlesResponse = new GetArticlesResponse();
        ArrayList<GetArticleResponse.Result> articleList = new ArrayList<GetArticleResponse.Result>();
        JSONObject result1 = jsonObject.getJSONObject("Result");
        JSONObject responseMetadataJson = jsonObject.getJSONObject("ResponseMetadata");
        CommonPo.ResponseMetadata responseMetadata = (CommonPo.ResponseMetadata)JSONObject.toJavaObject((JSON)responseMetadataJson, CommonPo.ResponseMetadata.class);
        getArticlesResponse.setResponseMetadata(responseMetadata);
        if (result1 == null) {
            return getArticlesResponse;
        }
        for (Map.Entry entry : result1.entrySet()) {
            GetArticleResponse.Result articleInfo = (GetArticleResponse.Result)JSONObject.toJavaObject((JSON)((JSONObject)entry.getValue()), GetArticleResponse.Result.class);
            articleInfo.setGroupId((String)entry.getKey());
            articleList.add(articleInfo);
        }
        GetArticlesResponse.Result result = new GetArticlesResponse.Result();
        result.setArticleInfos(articleList);
        getArticlesResponse.setResult(result);
        return getArticlesResponse;
    }

    @Override
    public FeedBackResponse feedBack(FeedBackRequest feedBackRequest) throws Exception {
        RawResponse response = this.query("Feedback", Utils.mapToPairList(Utils.paramsToMap(feedBackRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (FeedBackResponse)JSON.parseObject((byte[])response.getData(), FeedBackResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public FollowResponse follow(FollowRequest followRequest) throws Exception {
        RawResponse response = this.query("Follow", Utils.mapToPairList(Utils.paramsToMap(followRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (FollowResponse)JSON.parseObject((byte[])response.getData(), FollowResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public UnfollowResponse unfollow(UnfollowRequest unfollowRequest) throws Exception {
        RawResponse response = this.query("Unfollow", Utils.mapToPairList(Utils.paramsToMap(unfollowRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (UnfollowResponse)JSON.parseObject((byte[])response.getData(), UnfollowResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CheckRelationResponse checkRelation(CheckRelationRequest checkRelationRequest) throws Exception {
        RawResponse response = this.query("CheckRelation", Utils.mapToPairList(Utils.paramsToMap(checkRelationRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CheckRelationResponse)JSON.parseObject((byte[])response.getData(), CheckRelationResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetFollowingListResponse getFollowingList(GetFollowingListRequest getFollowingListRequest) throws Exception {
        RawResponse response = this.query("FollowingList", Utils.mapToPairList(Utils.paramsToMap(getFollowingListRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetFollowingListResponse)JSON.parseObject((byte[])response.getData(), GetFollowingListResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RefreshTipsResponse refreshTips(RefreshTipsRequest refreshTipsRequest) throws Exception {
        RawResponse response = this.query("RefreshTips", Utils.mapToPairList(Utils.paramsToMap(refreshTipsRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RefreshTipsResponse)JSON.parseObject((byte[])response.getData(), RefreshTipsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public FollowArticlesResponse getFollowArticles(FollowArticlesRequest followArticlesRequest) throws Exception {
        RawResponse response = this.query("FollowArticles", Utils.mapToPairList(Utils.paramsToMap(followArticlesRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (FollowArticlesResponse)JSON.parseObject((byte[])response.getData(), FollowArticlesResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RecommendRelatedUserResponse recommendRelatedUser(RecommendRelatedUserRequest recommendRelatedUserRequest) throws Exception {
        RawResponse response = this.query("RecommendRelatedUser", Utils.mapToPairList(Utils.paramsToMap(recommendRelatedUserRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RecommendRelatedUserResponse)JSON.parseObject((byte[])response.getData(), RecommendRelatedUserResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RecommendCategoryUserResponse recommendCategoryUser(RecommendCategoryUserRequest recommendCategoryUserRequest) throws Exception {
        RawResponse response = this.query("RecommendCategoryUser", Utils.mapToPairList(Utils.paramsToMap(recommendCategoryUserRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RecommendCategoryUserResponse)JSON.parseObject((byte[])response.getData(), RecommendCategoryUserResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RecommendCategoryInfoResponse recommendCategoryInfo(RecommendCategoryInfoRequest recommendCategoryInfoRequest) throws Exception {
        RawResponse response = this.query("RecommendCategoryInfo", Utils.mapToPairList(Utils.paramsToMap(recommendCategoryInfoRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RecommendCategoryInfoResponse)JSON.parseObject((byte[])response.getData(), RecommendCategoryInfoResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RelatedArticleResponse relatedArticle(RelatedArticleRequest relatedArticleRequest) throws Exception {
        RawResponse response = this.query("RelatedArticle", Utils.mapToPairList(Utils.paramsToMap(relatedArticleRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RelatedArticleResponse)JSON.parseObject((byte[])response.getData(), RelatedArticleResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetDiggListResponse getDiggList(GetDiggListRequest getDiggListRequest) throws Exception {
        RawResponse response = this.query("DiggList", Utils.mapToPairList(Utils.paramsToMap(getDiggListRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetDiggListResponse)JSON.parseObject((byte[])response.getData(), GetDiggListResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetVideoUrlResponse getVideoUrl(GetVideoUrlRequest getVideoUrlRequest) throws Exception {
        RawResponse response = this.query("VideoUrl", Utils.mapToPairList(Utils.paramsToMap(getVideoUrlRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        String jsonString = new String(response.getData());
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        GetVideoUrlResponse getVideoUrlResponse = new GetVideoUrlResponse();
        JSONObject result1 = jsonObject.getJSONObject("Result");
        JSONObject responseMetadataJson = jsonObject.getJSONObject("ResponseMetadata");
        CommonPo.ResponseMetadata responseMetadata = (CommonPo.ResponseMetadata)JSONObject.toJavaObject((JSON)responseMetadataJson, CommonPo.ResponseMetadata.class);
        getVideoUrlResponse.setResponseMetadata(responseMetadata);
        if (result1 == null) {
            return getVideoUrlResponse;
        }
        JSONObject resultData = result1.getJSONObject("data");
        GetVideoUrlResponse.Result videoUrlResult = (GetVideoUrlResponse.Result)JSONObject.toJavaObject((JSON)resultData, GetVideoUrlResponse.Result.class);
        getVideoUrlResponse.setResult(videoUrlResult);
        return getVideoUrlResponse;
    }

    @Override
    public GetUnionProductResponse getUnionProduct(GetUnionProductRequest getUnionProductRequest) throws Exception {
        RawResponse response = this.query("UnionProduct", Utils.mapToPairList(Utils.paramsToMap(getUnionProductRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetUnionProductResponse)JSON.parseObject((byte[])response.getData(), GetUnionProductResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public HotBoardResponse hotBoard(HotBoardRequest hotBoardRequest) throws Exception {
        RawResponse response = this.query("HotBoard", Utils.mapToPairList(Utils.paramsToMap(hotBoardRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (HotBoardResponse)JSON.parseObject((byte[])response.getData(), HotBoardResponse.class, (Feature[])new Feature[0]);
    }
}

