/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.model.tls;

import com.volcengine.model.ServiceInfo;
import com.volcengine.model.tls.ClientConfig;
import com.volcengine.model.tls.exception.LogException;
import com.volcengine.service.tls.TLSHttpUtil;
import com.volcengine.service.tls.TLSLogClient;
import com.volcengine.service.tls.TLSLogClientImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientBuilder {
    public static final String HTTP = "http";
    private static volatile TLSLogClient client;
    private static final Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TLSLogClient newClient(ClientConfig config) throws LogException {
        if (config == null || config.getRegion() == null || config.getAccessKeySecret() == null || config.getAccessKeyId() == null || config.getEndpoint() == null || !config.getEndpoint().toLowerCase().startsWith(HTTP)) {
            log.error((Object)"client config null error");
            throw new LogException("", "client config null error", null);
        }
        ServiceInfo serviceInfo = ClientConfig.initServiceInfo(config);
        if (client != null) return client;
        Class<ClientBuilder> clazz = ClientBuilder.class;
        synchronized (ClientBuilder.class) {
            if (client != null) return client;
            TLSHttpUtil tlsHttpUtil = new TLSHttpUtil(serviceInfo, TLSHttpUtil.API_INFO_LIST);
            tlsHttpUtil.setAccessKey(config.getAccessKeyId());
            tlsHttpUtil.setSecretKey(config.getAccessKeySecret());
            tlsHttpUtil.setSessionToken(config.getSecurityToken());
            tlsHttpUtil.setSocketTimeout(60000);
            tlsHttpUtil.setConnectionTimeout(60000);
            client = new TLSLogClientImpl(tlsHttpUtil, config);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return client;
        }
    }

    static {
        log = LogFactory.getLog(ClientBuilder.class);
    }
}

