/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.imagex.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.request.ApplyImageUploadRequest;
import com.volcengine.model.request.CommitImageUploadRequest;
import com.volcengine.model.request.CommitImageUploadRequestBody;
import com.volcengine.model.request.DeleteImageReq;
import com.volcengine.model.request.EmbedImageHmRequest;
import com.volcengine.model.request.ExtractImageHmRequest;
import com.volcengine.model.request.GetDeduplicateTaskStatusRequest;
import com.volcengine.model.request.GetDenoisingImageRequest;
import com.volcengine.model.request.GetImageBgFillResultRequest;
import com.volcengine.model.request.GetImageComicResultRequest;
import com.volcengine.model.request.GetImageDuplicateDetectionAsyncRequest;
import com.volcengine.model.request.GetImageDuplicateDetectionSyncRequest;
import com.volcengine.model.request.GetImageEnhanceResultRequest;
import com.volcengine.model.request.GetImageEraseModelsRequest;
import com.volcengine.model.request.GetImageEraseResultRequest;
import com.volcengine.model.request.GetImageOCRRequest;
import com.volcengine.model.request.GetImagePSDetectionRequest;
import com.volcengine.model.request.GetImageQualityRequest;
import com.volcengine.model.request.GetImageSegmentRequest;
import com.volcengine.model.request.GetImageSmartCropResultRequest;
import com.volcengine.model.request.GetImageStyleResultRequest;
import com.volcengine.model.request.GetImageSuperResolutionResultRequest;
import com.volcengine.model.request.GetImageUploadFileRequest;
import com.volcengine.model.request.GetImageUploadFilesRequest;
import com.volcengine.model.request.GetLicensePlateDetectionRequest;
import com.volcengine.model.request.GetPrivateImageTypeRequest;
import com.volcengine.model.request.UpdateImageFilesRequest;
import com.volcengine.model.response.ApplyImageUploadResponse;
import com.volcengine.model.response.CommitImageUploadResponse;
import com.volcengine.model.response.CommonResponse;
import com.volcengine.model.response.DeleteImageResp;
import com.volcengine.model.response.EmbedImageHmResponse;
import com.volcengine.model.response.ExtractImageHmResponse;
import com.volcengine.model.response.GetDeduplicateTaskStatusResponse;
import com.volcengine.model.response.GetDenoisingImageResponse;
import com.volcengine.model.response.GetImageBgFillResultResponse;
import com.volcengine.model.response.GetImageComicResultResponse;
import com.volcengine.model.response.GetImageDuplicateDetectionAsyncResponse;
import com.volcengine.model.response.GetImageDuplicateDetectionSyncResponse;
import com.volcengine.model.response.GetImageEnhanceResultResponse;
import com.volcengine.model.response.GetImageEraseModelsResponse;
import com.volcengine.model.response.GetImageEraseResultResponse;
import com.volcengine.model.response.GetImageOCRGeneralResponse;
import com.volcengine.model.response.GetImageOCRLicenseResponse;
import com.volcengine.model.response.GetImageOCRResponse;
import com.volcengine.model.response.GetImagePSDetectionResponse;
import com.volcengine.model.response.GetImageQualityResponse;
import com.volcengine.model.response.GetImageSegmentResponse;
import com.volcengine.model.response.GetImageSmartCropResultResponse;
import com.volcengine.model.response.GetImageStyleResultResponse;
import com.volcengine.model.response.GetImageSuperResolutionResultResponse;
import com.volcengine.model.response.GetImageUploadFileResponse;
import com.volcengine.model.response.GetImageUploadFilesResponse;
import com.volcengine.model.response.GetLicensePlateDetectionResponse;
import com.volcengine.model.response.GetPrivateImageTypeResponse;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.ResponseMetadata;
import com.volcengine.model.response.UpdateImageFilesResponse;
import com.volcengine.model.sts2.Policy;
import com.volcengine.model.sts2.SecurityToken2;
import com.volcengine.model.sts2.Statement;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.imagex.IImageXService;
import com.volcengine.service.imagex.ImageXConfig;
import com.volcengine.util.Sts2Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.util.EntityUtils;

public class ImageXServiceImpl
extends BaseServiceImpl
implements IImageXService {
    private final Retryer<Boolean> uploadRetryer = ImageXServiceImpl.createUploadDefaultRetryer();
    private final Retryer<HttpResponse> httpRetryer = ImageXServiceImpl.createUploadDefaultRetryer();

    private ImageXServiceImpl() {
        super(ImageXConfig.serviceInfoMap.get("cn-north-1"), ImageXConfig.apiInfoList);
    }

    private ImageXServiceImpl(ServiceInfo serviceInfo) {
        super(serviceInfo, ImageXConfig.apiInfoList);
    }

    public static IImageXService getInstance() {
        return new ImageXServiceImpl();
    }

    public static IImageXService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = ImageXConfig.serviceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("ImageX not support region " + region);
        }
        return new ImageXServiceImpl(serviceInfo);
    }

    private static <R> Retryer<R> createUploadDefaultRetryer() {
        return RetryerBuilder.newBuilder().retryIfException().retryIfResult(it -> Objects.equals(it, false)).retryIfResult(Objects::isNull).withWaitStrategy(WaitStrategies.exponentialWait()).withStopStrategy(StopStrategies.stopAfterAttempt((int)3)).build();
    }

    @Override
    public ApplyImageUploadResponse applyImageUpload(ApplyImageUploadRequest req) throws Exception {
        RawResponse response = this.query("ApplyImageUpload", Utils.paramsToPair(req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ApplyImageUploadResponse res = (ApplyImageUploadResponse)JSON.parseObject((byte[])response.getData(), ApplyImageUploadResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public CommitImageUploadResponse commitImageUpload(CommitImageUploadRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        CommitImageUploadRequestBody reqBody = new CommitImageUploadRequestBody();
        reqBody.setSessionKey(req.getSessionKey());
        reqBody.setOptionInfos(req.getOptionInfos());
        RawResponse response = this.json("CommitImageUpload", Utils.mapToPairList(params), JSON.toJSONString((Object)reqBody));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        CommitImageUploadResponse res = (CommitImageUploadResponse)JSON.parseObject((byte[])response.getData(), CommitImageUploadResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    private void doUpload(String host, ApplyImageUploadResponse.StoreInfosBean storeInfo, InputStream imageData) throws Exception {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = imageData.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        this.doUpload(host, storeInfo, buffer.toByteArray());
    }

    private void doUpload(String host, ApplyImageUploadResponse.StoreInfosBean storeInfo, byte[] imageData) throws Exception {
        long crc32 = Utils.crc32(imageData);
        String checkSum = String.format("%08x", crc32);
        String url = String.format("https://%s/%s", host, storeInfo.getStoreUri());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-CRC32", checkSum);
        headers.put("Authorization", storeInfo.getAuth());
        long startTime = System.currentTimeMillis();
        this.uploadRetryer.call(() -> this.putData(url, imageData, headers));
        long endTime = System.currentTimeMillis();
        long cost = endTime - startTime;
        float avgSpeed = (float)imageData.length / (float)cost;
        System.out.printf("upload image cost {%d} ms, avgSpeed: {%f} KB/s%n", cost, Float.valueOf(avgSpeed));
    }

    private void chunkUpload(String host, ApplyImageUploadResponse.StoreInfosBean storeInfo, InputStream content, Long size, boolean isLargeFile) throws Exception {
        String uploadID = this.initUploadPart(host, storeInfo, isLargeFile);
        byte[] data = new byte[0x1400000];
        ArrayList<String> parts = new ArrayList<String>();
        long num = size / 0x1400000L;
        long lastNum = num - 1L;
        try (BufferedInputStream bis = new BufferedInputStream(content);){
            long partNumber;
            for (long i = 0L; i < lastNum; ++i) {
                int readSize = bis.read(data);
                if (readSize != 0x1400000) {
                    throw new IllegalStateException(String.format("can not read a full chunk from content, %s expected but %s read", 0x1400000, readSize));
                }
                partNumber = isLargeFile ? i + 1L : i;
                parts.add(this.uploadPart(host, storeInfo, uploadID, partNumber, data, isLargeFile));
            }
            long readCount = 0x1400000L * lastNum;
            int len = (int)(size - readCount);
            byte[] lastPart = new byte[len];
            int readSize = bis.read(lastPart);
            if (readSize != len) {
                throw new IllegalStateException(String.format("can not read a full chunk from content, %s expected but %s read", len, readSize));
            }
            partNumber = isLargeFile ? lastNum + 1L : lastNum;
            parts.add(this.uploadPart(host, storeInfo, uploadID, partNumber, lastPart, isLargeFile));
        }
        this.uploadMergePart(host, storeInfo, uploadID, parts.toArray(new String[0]), isLargeFile);
    }

    private String initUploadPart(String host, ApplyImageUploadResponse.StoreInfosBean storeInfo, boolean isLargeFile) throws Exception {
        HttpResponse httpResponse;
        String url = new URI("https", null, host, -1, "/" + storeInfo.getStoreUri(), "uploads", null).toASCIIString();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", storeInfo.getAuth());
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        if ((httpResponse = (HttpResponse)this.httpRetryer.call(() -> this.putDataWithResponse(url, new byte[0], headers))) == null) {
            throw new RuntimeException("init part error, response is empty");
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("http code is " + httpResponse.getStatusLine().getStatusCode());
        }
        String entity = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        JSONObject result = JSONObject.parseObject((String)entity);
        return result.getJSONObject("payload").getInnerMap().get("uploadID").toString();
    }

    private String uploadPart(String host, ApplyImageUploadResponse.StoreInfosBean storeInfo, String uploadID, long partNumber, byte[] data, boolean isLargeFile) throws Exception {
        String query = String.format("partNumber=%d&uploadID=%s", partNumber, uploadID);
        String url = new URI("https", null, host, -1, "/" + storeInfo.getStoreUri(), query, null).toASCIIString();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", storeInfo.getAuth());
        long crc32 = Utils.crc32(data);
        String checkSum = String.format("%08x", crc32);
        headers.put("Content-CRC32", checkSum);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        this.uploadRetryer.call(() -> this.putData(url, data, headers));
        return checkSum;
    }

    private void uploadMergePart(String host, ApplyImageUploadResponse.StoreInfosBean storeInfo, String uploadID, String[] checkSum, boolean isLargeFile) throws Exception {
        String query = String.format("uploadID=%s", uploadID);
        String url = new URI("https", null, host, -1, "/" + storeInfo.getStoreUri(), query, null).toASCIIString();
        String body = IntStream.range(0, checkSum.length).mapToObj(i -> String.format("%d:%s", i, checkSum[i])).collect(Collectors.joining(",", "", ""));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", storeInfo.getAuth());
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        this.uploadRetryer.call(() -> this.putData(url, body.getBytes(), headers));
    }

    @Override
    public CommitImageUploadResponse uploadImages(ApplyImageUploadRequest request, List<byte[]> imageDatas) throws Exception {
        if (imageDatas.size() == 0) {
            throw new Exception("empty image data");
        }
        request.setUploadNum(imageDatas.size());
        ApplyImageUploadResponse applyResp = this.applyImageUpload(request);
        this.applyRespGuard(applyResp, imageDatas.size());
        ApplyImageUploadResponse.UploadAddressBean uploadAddr = applyResp.getResult().getUploadAddress();
        List<ApplyImageUploadResponse.StoreInfosBean> storeInfos = uploadAddr.getStoreInfos();
        String uploadHost = uploadAddr.getUploadHosts().get(0);
        String sessionKey = uploadAddr.getSessionKey();
        for (int i = 0; i < imageDatas.size(); ++i) {
            this.doUpload(uploadHost, storeInfos.get(i), imageDatas.get(i));
        }
        CommitImageUploadRequest commitRequest = new CommitImageUploadRequest();
        commitRequest.setServiceId(request.getServiceId());
        commitRequest.setSessionKey(sessionKey);
        if (request.getCommitParam() != null) {
            commitRequest.setFunctions(request.getCommitParam().getFunctions());
            commitRequest.setOptionInfos(request.getCommitParam().getOptionInfos());
        }
        return this.commitImageUpload(commitRequest);
    }

    @Override
    public CommitImageUploadResponse uploadImages(ApplyImageUploadRequest request, List<InputStream> content, List<Long> size) throws Exception {
        if (size.size() != content.size()) {
            throw new IllegalArgumentException(String.format("expect size.size() == content.size() but  size.size() = %d, content.size() = %d", size.size(), content.size()));
        }
        request.setUploadNum(size.size());
        if (size.stream().anyMatch(it -> it == null || it <= 0L)) {
            throw new IllegalArgumentException("please ensure all elements in `size` is greater than 0");
        }
        if (content.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("please ensure all elements in `content` not null");
        }
        ApplyImageUploadResponse applyResp = this.applyImageUpload(request);
        this.applyRespGuard(applyResp, size.size());
        ApplyImageUploadResponse.UploadAddressBean uploadAddr = applyResp.getResult().getUploadAddress();
        List<ApplyImageUploadResponse.StoreInfosBean> storeInfos = uploadAddr.getStoreInfos();
        String uploadHost = uploadAddr.getUploadHosts().get(0);
        String sessionKey = uploadAddr.getSessionKey();
        for (int i = 0; i < size.size(); ++i) {
            long fileSize = size.get(i);
            InputStream fileContent = content.get(i);
            ApplyImageUploadResponse.StoreInfosBean storeInfo = storeInfos.get(i);
            if (fileSize <= 0x1400000L) {
                this.doUpload(uploadHost, storeInfo, fileContent);
                continue;
            }
            boolean isLargeFile = fileSize > 0x40000000L;
            this.chunkUpload(uploadHost, storeInfo, fileContent, fileSize, isLargeFile);
        }
        CommitImageUploadRequest commitRequest = new CommitImageUploadRequest();
        commitRequest.setServiceId(request.getServiceId());
        commitRequest.setSessionKey(sessionKey);
        if (request.getCommitParam() != null) {
            commitRequest.setFunctions(request.getCommitParam().getFunctions());
            commitRequest.setOptionInfos(request.getCommitParam().getOptionInfos());
        }
        return this.commitImageUpload(commitRequest);
    }

    private void applyRespGuard(ApplyImageUploadResponse applyResp, int expectSize) {
        if (applyResp.getResult() == null) {
            throw new IllegalStateException("apply upload result is null");
        }
        ApplyImageUploadResponse.UploadAddressBean uploadAddr = applyResp.getResult().getUploadAddress();
        if (uploadAddr == null || uploadAddr.getUploadHosts() == null || uploadAddr.getUploadHosts().size() == 0) {
            throw new IllegalStateException("apply upload address is null");
        }
        List<ApplyImageUploadResponse.StoreInfosBean> storeInfos = uploadAddr.getStoreInfos();
        if (storeInfos.size() != expectSize) {
            throw new IllegalStateException("apply upload get wrong store infos");
        }
    }

    @Override
    public String getUploadToken(Map<String, String> params) throws Exception {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Version", "v1");
        List<NameValuePair> pairs = Utils.mapToPairList(params);
        String applyUploadToken = this.getSignUrl("ApplyImageUpload", pairs);
        ret.put("ApplyUploadToken", applyUploadToken);
        String commitUploadToken = this.getSignUrl("CommitImageUpload", pairs);
        ret.put("CommitUploadToken", commitUploadToken);
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public SecurityToken2 getUploadSts2(List<String> serviceIds) throws Exception {
        return this.getUploadSts2WithKeyPtn(serviceIds, 3600000L, "");
    }

    @Override
    public SecurityToken2 getUploadSts2WithExpire(List<String> serviceIds, long expire) throws Exception {
        return this.getUploadSts2WithKeyPtn(serviceIds, expire, "");
    }

    @Override
    public SecurityToken2 getUploadSts2WithKeyPtn(List<String> serviceIds, long expire, String keyPtn) throws Exception {
        ArrayList<String> applyRes = new ArrayList<String>();
        ArrayList<String> commitRes = new ArrayList<String>();
        if (serviceIds.size() == 0) {
            applyRes.add(String.format("trn:ImageX:*:*:ServiceId/%s", "*"));
            commitRes.add(String.format("trn:ImageX:*:*:ServiceId/%s", "*"));
        } else {
            for (String serviceId : serviceIds) {
                applyRes.add(String.format("trn:ImageX:*:*:ServiceId/%s", serviceId));
                commitRes.add(String.format("trn:ImageX:*:*:ServiceId/%s", serviceId));
            }
        }
        applyRes.add(String.format("trn:ImageX:*:*:StoreKeys/%s", keyPtn));
        Policy inlinePolicy = new Policy();
        Statement applyStatement = Sts2Utils.newAllowStatement(Collections.singletonList("ImageX:ApplyImageUpload"), applyRes);
        Statement commitStatement = Sts2Utils.newAllowStatement(Collections.singletonList("ImageX:CommitImageUpload"), commitRes);
        inlinePolicy.addStatement(applyStatement);
        inlinePolicy.addStatement(commitStatement);
        return this.signSts2(inlinePolicy, expire);
    }

    @Override
    public DeleteImageResp deleteImages(DeleteImageReq req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("DeleteImageUploadFiles", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DeleteImageResp res = (DeleteImageResp)JSON.parseObject((byte[])response.getData(), DeleteImageResp.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public GetImageUploadFileResponse getImageUploadFile(GetImageUploadFileRequest req) throws Exception {
        RawResponse response = this.query("GetImageUploadFile", Utils.paramsToPair(req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageUploadFileResponse res = (GetImageUploadFileResponse)JSON.parseObject((byte[])response.getData(), GetImageUploadFileResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public GetImageUploadFilesResponse getImageUploadFiles(GetImageUploadFilesRequest req) throws Exception {
        RawResponse response = this.query("GetImageUploadFiles", Utils.paramsToPair(req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageUploadFilesResponse res = (GetImageUploadFilesResponse)JSON.parseObject((byte[])response.getData(), GetImageUploadFilesResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public UpdateImageFilesResponse updateImageUrls(UpdateImageFilesRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("UpdateImageUploadFiles", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        UpdateImageFilesResponse res = (UpdateImageFilesResponse)JSON.parseObject((byte[])response.getData(), UpdateImageFilesResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public CommonResponse getImageX(String action, Map<String, String> param) throws Exception {
        RawResponse response = this.query(action, Utils.mapToPairList(param));
        return this.parseRawRes(response);
    }

    @Override
    public CommonResponse postImageX(String action, Map<String, String> param, Object req) throws Exception {
        RawResponse response = this.json(action, Utils.mapToPairList(param), JSON.toJSONString((Object)req));
        return this.parseRawRes(response);
    }

    private CommonResponse parseRawRes(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        CommonResponse res = (CommonResponse)JSON.parseObject((byte[])response.getData(), CommonResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public GetImageOCRResponse<?> getImageOCR(GetImageOCRRequest param) throws Exception {
        Class type;
        if (param.getScene().equals("license")) {
            type = GetImageOCRLicenseResponse.class;
        } else if (param.getScene().equals("general")) {
            type = GetImageOCRGeneralResponse.class;
        } else {
            throw new IllegalArgumentException("scene now acceptable");
        }
        RawResponse response = this.json("GetImageOCR", Utils.paramsToPair(param), JSON.toJSONString((Object)param));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageOCRResponse res = (GetImageOCRResponse)JSON.parseObject((byte[])response.getData(), type, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public EmbedImageHmResponse embedImageHm(EmbedImageHmRequest req) throws Exception {
        RawResponse response = this.json("CreateImageHmEmbed", null, JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        EmbedImageHmResponse res = (EmbedImageHmResponse)JSON.parseObject((byte[])response.getData(), EmbedImageHmResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public ExtractImageHmResponse extractImageHm(ExtractImageHmRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        params.put("StoreUri", req.getStoreUri());
        params.put("Algorithm", req.getAlgorithm());
        RawResponse response = this.query("CreateImageHmExtract", Utils.mapToPairList(params));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ExtractImageHmResponse res = (ExtractImageHmResponse)JSON.parseObject((byte[])response.getData(), ExtractImageHmResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageSegmentResponse getImageSegment(GetImageSegmentRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetSegmentImage", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageSegmentResponse res = (GetImageSegmentResponse)JSON.parseObject((byte[])response.getData(), GetImageSegmentResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageEraseModelsResponse getImageEraseModels(GetImageEraseModelsRequest req) throws Exception {
        RawResponse response = this.query("GetImageEraseModels", Utils.paramsToPair(req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageEraseModelsResponse res = (GetImageEraseModelsResponse)JSON.parseObject((byte[])response.getData(), GetImageEraseModelsResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageEraseResultResponse getImageEraseResult(GetImageEraseResultRequest req) throws Exception {
        RawResponse response = this.json("GetImageEraseResult", null, JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageEraseResultResponse res = (GetImageEraseResultResponse)JSON.parseObject((byte[])response.getData(), GetImageEraseResultResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageQualityResponse getImageQuality(GetImageQualityRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetImageQuality", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageQualityResponse res = (GetImageQualityResponse)JSON.parseObject((byte[])response.getData(), GetImageQualityResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageBgFillResultResponse getImageBgFillResult(GetImageBgFillResultRequest req) throws Exception {
        RawResponse response = this.json("GetImageBgFillResult", Collections.EMPTY_LIST, JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageBgFillResultResponse res = (GetImageBgFillResultResponse)JSON.parseObject((byte[])response.getData(), GetImageBgFillResultResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageDuplicateDetectionSyncResponse getImageDuplicateDetectionSync(GetImageDuplicateDetectionSyncRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetImageDuplicateDetection", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageDuplicateDetectionSyncResponse res = (GetImageDuplicateDetectionSyncResponse)JSON.parseObject((byte[])response.getData(), GetImageDuplicateDetectionSyncResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageDuplicateDetectionAsyncResponse getImageDuplicateDetectionAsync(GetImageDuplicateDetectionAsyncRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetImageDuplicateDetection", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageDuplicateDetectionAsyncResponse res = (GetImageDuplicateDetectionAsyncResponse)JSON.parseObject((byte[])response.getData(), GetImageDuplicateDetectionAsyncResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetDeduplicateTaskStatusResponse getDeduplicateTaskStatus(GetDeduplicateTaskStatusRequest req) throws Exception {
        RawResponse response = this.query("GetImageDuplicateDetection", Utils.paramsToPair(req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetDeduplicateTaskStatusResponse res = (GetDeduplicateTaskStatusResponse)JSON.parseObject((byte[])response.getData(), GetDeduplicateTaskStatusResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetDenoisingImageResponse getDenoisingImage(GetDenoisingImageRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetDenoisingImage", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetDenoisingImageResponse res = (GetDenoisingImageResponse)JSON.parseObject((byte[])response.getData(), GetDenoisingImageResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageComicResultResponse getImageComicResult(GetImageComicResultRequest req) throws Exception {
        RawResponse response = this.json("GetImageComicResult", Collections.EMPTY_LIST, JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageComicResultResponse res = (GetImageComicResultResponse)JSON.parseObject((byte[])response.getData(), GetImageComicResultResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageSuperResolutionResultResponse getImageSuperResolutionResult(GetImageSuperResolutionResultRequest req) throws Exception {
        RawResponse response = this.json("GetImageSuperResolutionResult", Collections.EMPTY_LIST, JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageSuperResolutionResultResponse res = (GetImageSuperResolutionResultResponse)JSON.parseObject((byte[])response.getData(), GetImageSuperResolutionResultResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageSmartCropResultResponse getImageSmartCropResult(GetImageSmartCropResultRequest req) throws Exception {
        RawResponse response = this.json("GetImageSmartCropResult", Collections.EMPTY_LIST, JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageSmartCropResultResponse res = (GetImageSmartCropResultResponse)JSON.parseObject((byte[])response.getData(), GetImageSmartCropResultResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetLicensePlateDetectionResponse getLicensePlateDetection(GetLicensePlateDetectionRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetLicensePlateDetection", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetLicensePlateDetectionResponse res = (GetLicensePlateDetectionResponse)JSON.parseObject((byte[])response.getData(), GetLicensePlateDetectionResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImagePSDetectionResponse getImagePSDetection(GetImagePSDetectionRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetImagePSDetection", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImagePSDetectionResponse res = (GetImagePSDetectionResponse)JSON.parseObject((byte[])response.getData(), GetImagePSDetectionResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetPrivateImageTypeResponse getPrivateImageType(GetPrivateImageTypeRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetPrivateImageType", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetPrivateImageTypeResponse res = (GetPrivateImageTypeResponse)JSON.parseObject((byte[])response.getData(), GetPrivateImageTypeResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageEnhanceResultResponse getImageEnhanceResult(GetImageEnhanceResultRequest req) throws Exception {
        RawResponse response = this.json("GetImageEnhanceResult", Collections.EMPTY_LIST, JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageEnhanceResultResponse res = (GetImageEnhanceResultResponse)JSON.parseObject((byte[])response.getData(), GetImageEnhanceResultResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageStyleResultResponse getImageStyleResult(GetImageStyleResultRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetImageStyleResult", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageStyleResultResponse res = (GetImageStyleResultResponse)JSON.parseObject((byte[])response.getData(), GetImageStyleResultResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        return res;
    }
}

