/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.notify.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.model.response.RawResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.notify.NotifyConfig;
import com.volcengine.service.notify.NotifyService;
import com.volcengine.service.notify.model.request.BatchAppendRequest;
import com.volcengine.service.notify.model.request.CreateTaskRequest;
import com.volcengine.service.notify.model.request.CreateTtsResourceRequest;
import com.volcengine.service.notify.model.request.EditTaskRequest;
import com.volcengine.service.notify.model.request.FetchVoiceResourceRequest;
import com.volcengine.service.notify.model.request.SingleAppendRequest;
import com.volcengine.service.notify.model.request.UploadVoiceResourceRequest;
import com.volcengine.service.notify.model.response.BasicResourceResult;
import com.volcengine.service.notify.model.response.CommonResponse;
import com.volcengine.service.notify.model.response.SingleAppendResult;
import com.volcengine.service.notify.model.response.SingleInfo;
import com.volcengine.service.notify.model.response.TaskAppendResult;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class NotifyServiceImpl
extends BaseServiceImpl
implements NotifyService {
    protected NotifyServiceImpl() {
        super(NotifyConfig.serviceInfoMap.get("cn-north-1"), NotifyConfig.apiInfoList);
    }

    public static NotifyServiceImpl getInstance() {
        return new NotifyServiceImpl();
    }

    private <T> T doJson(String action, Object request, TypeReference<T> typeReference) throws Exception {
        RawResponse response = this.json(action, new ArrayList<NameValuePair>(), JSONObject.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (T)JSON.parseObject((byte[])response.getData(), (Type)typeReference.getType(), (Feature[])new Feature[0]);
    }

    private <T> T doQuery(String action, List<NameValuePair> params, TypeReference<T> typeReference) throws Exception {
        RawResponse response = this.query(action, params);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (T)JSON.parseObject((byte[])response.getData(), (Type)typeReference.getType(), (Feature[])new Feature[0]);
    }

    @Override
    public CommonResponse<TaskAppendResult> createTask(CreateTaskRequest request) throws Exception {
        return this.doJson("CreateTask", request, new TypeReference<CommonResponse<TaskAppendResult>>(){});
    }

    @Override
    public CommonResponse<TaskAppendResult> batchAppend(BatchAppendRequest request) throws Exception {
        return this.doJson("BatchAppend", request, new TypeReference<CommonResponse<TaskAppendResult>>(){});
    }

    @Override
    public CommonResponse<TaskAppendResult> updateTask(EditTaskRequest request) throws Exception {
        return this.doJson("UpdateTask", request, new TypeReference<CommonResponse<TaskAppendResult>>(){});
    }

    @Override
    public CommonResponse pauseTask(String taskOpenId) throws Exception {
        return this.doQuery("PauseTask", Arrays.asList(new BasicNameValuePair("TaskOpenId", taskOpenId)), new TypeReference<CommonResponse>(){});
    }

    @Override
    public CommonResponse resumeTask(String taskOpenId) throws Exception {
        return this.doQuery("ResumeTask", Arrays.asList(new BasicNameValuePair("TaskOpenId", taskOpenId)), new TypeReference<CommonResponse>(){});
    }

    @Override
    public CommonResponse stopTask(String taskOpenId) throws Exception {
        return this.doQuery("StopTask", Arrays.asList(new BasicNameValuePair("TaskOpenId", taskOpenId)), new TypeReference<CommonResponse>(){});
    }

    @Override
    public CommonResponse<SingleAppendResult> singleBatchAppend(SingleAppendRequest request) throws Exception {
        return this.doJson("SingleBatchAppend", request, new TypeReference<CommonResponse<SingleAppendResult>>(){});
    }

    @Override
    public CommonResponse<SingleInfo> singleInfo(String singleOpenId) throws Exception {
        return this.doQuery("SingleInfo", Arrays.asList(new BasicNameValuePair("SingleOpenId", singleOpenId)), new TypeReference<CommonResponse<SingleInfo>>(){});
    }

    @Override
    public CommonResponse singleCancel(String singleOpenId) throws Exception {
        return this.doQuery("SingleCancel", Arrays.asList(new BasicNameValuePair("SingleOpenId", singleOpenId)), new TypeReference<CommonResponse>(){});
    }

    @Override
    public CommonResponse<BasicResourceResult> fetchVoiceResourceByUrl(FetchVoiceResourceRequest request) throws Exception {
        return this.doJson("FetchResource", request, new TypeReference<CommonResponse<BasicResourceResult>>(){});
    }

    @Override
    public CommonResponse<BasicResourceResult> createTtsResource(CreateTtsResourceRequest request) throws Exception {
        return this.doJson("OpenCreateTts", request, new TypeReference<CommonResponse<BasicResourceResult>>(){});
    }

    @Override
    public CommonResponse<BasicResourceResult> deleteResourceByResourceKey(String resourceKey) throws Exception {
        return this.doQuery("OpenDeleteResource", Collections.singletonList(new BasicNameValuePair("ResourceKey", resourceKey)), new TypeReference<CommonResponse<BasicResourceResult>>(){});
    }

    @Override
    public CommonResponse<BasicResourceResult> generateVoiceResourceUploadUrl(UploadVoiceResourceRequest request) throws Exception {
        return this.doJson("GetResourceUploadUrl", request, new TypeReference<CommonResponse<BasicResourceResult>>(){});
    }

    @Override
    public CommonResponse<BasicResourceResult> commitVoiceResourceUpload(UploadVoiceResourceRequest request) throws Exception {
        return this.doJson("CommitResourceUpload", request, new TypeReference<CommonResponse<BasicResourceResult>>(){});
    }
}

