/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.stream.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.stream.CommonPo;
import com.volcengine.model.stream.consumer.FollowActionRequest;
import com.volcengine.model.stream.consumer.FollowActionResponse;
import com.volcengine.model.stream.consumer.FollowCheckRequest;
import com.volcengine.model.stream.consumer.FollowCheckResponse;
import com.volcengine.model.stream.consumer.FollowListRequest;
import com.volcengine.model.stream.consumer.FollowListResponse;
import com.volcengine.model.stream.consumer.MultiArticlesRequest;
import com.volcengine.model.stream.consumer.MultiArticlesResponse;
import com.volcengine.model.stream.consumer.SingleArticleRequest;
import com.volcengine.model.stream.consumer.SingleArticleResponse;
import com.volcengine.model.stream.consumer.UnfollowActionRequest;
import com.volcengine.model.stream.consumer.UnfollowActionResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.stream.MonitorService;
import com.volcengine.service.stream.StreamConsumerConfig;
import com.volcengine.service.stream.StreamConsumerService;
import com.volcengine.service.stream.impl.MonitorServiceImpl;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpHost;

public class StreamConsumerServiceImpl
extends BaseServiceImpl
implements StreamConsumerService {
    static HttpHost Mproxy;
    boolean needMonitor = true;
    private static volatile StreamConsumerServiceImpl instance;

    private StreamConsumerServiceImpl() {
        super(StreamConsumerConfig.serviceInfo, StreamConsumerConfig.apiInfoList);
    }

    private StreamConsumerServiceImpl(HttpHost proxy) {
        super(StreamConsumerConfig.serviceInfo, proxy, StreamConsumerConfig.apiInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StreamConsumerService getInstance() {
        if (instance != null) return instance;
        Class<StreamConsumerServiceImpl> clazz = StreamConsumerServiceImpl.class;
        synchronized (StreamConsumerServiceImpl.class) {
            if (instance != null) return instance;
            instance = new StreamConsumerServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StreamConsumerService getInstance(HttpHost proxy) {
        if (instance != null) return instance;
        Class<StreamConsumerServiceImpl> clazz = StreamConsumerServiceImpl.class;
        synchronized (StreamConsumerServiceImpl.class) {
            if (instance != null) return instance;
            instance = new StreamConsumerServiceImpl(proxy);
            Mproxy = proxy;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void SetNeedMonitor(boolean open) {
        this.needMonitor = open;
    }

    @Override
    public FollowActionResponse followAction(FollowActionRequest followActionRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("FollowAction", Utils.mapToPairList(Utils.paramsToMap(followActionRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, followActionRequest.getPartner(), "", followActionRequest.getAccessToken(), "FollowAction", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        FollowActionResponse followActionResponse = (FollowActionResponse)JSON.parseObject((byte[])response.getData(), FollowActionResponse.class, (Feature[])new Feature[0]);
        if (followActionResponse.getResponseMetadata().getError() == null || followActionResponse.getResponseMetadata().getError().getCodeN() == 0L) {
            followActionResponse.setResult("success");
        }
        return followActionResponse;
    }

    @Override
    public UnfollowActionResponse unfollowAction(UnfollowActionRequest unfollowActionRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("UnfollowAction", Utils.mapToPairList(Utils.paramsToMap(unfollowActionRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, unfollowActionRequest.getPartner(), "", unfollowActionRequest.getAccessToken(), "UnfollowAction", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        UnfollowActionResponse unfollowActionResponse = (UnfollowActionResponse)JSON.parseObject((byte[])response.getData(), UnfollowActionResponse.class, (Feature[])new Feature[0]);
        if (unfollowActionResponse.getResponseMetadata().getError() == null || unfollowActionResponse.getResponseMetadata().getError().getCodeN() == 0L) {
            unfollowActionResponse.setResult("success");
        }
        return unfollowActionResponse;
    }

    @Override
    public FollowListResponse followList(FollowListRequest followListRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("FollowList", Utils.mapToPairList(Utils.paramsToMap(followListRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, followListRequest.getPartner(), "", followListRequest.getAccessToken(), "FollowList", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (FollowListResponse)JSON.parseObject((byte[])response.getData(), FollowListResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public FollowCheckResponse followCheck(FollowCheckRequest followCheckRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("FollowCheck", Utils.mapToPairList(Utils.paramsToMap(followCheckRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, followCheckRequest.getPartner(), "", followCheckRequest.getAccessToken(), "FollowCheck", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (FollowCheckResponse)JSON.parseObject((byte[])response.getData(), FollowCheckResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public SingleArticleResponse singleArticle(SingleArticleRequest singleArticleRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("SingleArticle", Utils.mapToPairList(Utils.paramsToMap(singleArticleRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, singleArticleRequest.getPartner(), "", singleArticleRequest.getAccessToken(), "SingleArticle", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (SingleArticleResponse)JSON.parseObject((byte[])response.getData(), SingleArticleResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public MultiArticlesResponse multiArticles(MultiArticlesRequest multiArticlesRequest) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, String> requestMap = Utils.paramsToMap(multiArticlesRequest);
        if (requestMap.containsKey("GroupIDs")) {
            String groupIdsStr = requestMap.get("GroupIDs");
            groupIdsStr = groupIdsStr.replaceAll("%2C", ",");
            requestMap.put("GroupIDs", groupIdsStr);
        }
        RawResponse response = this.query("MultiArticle", Utils.mapToPairList(requestMap));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, multiArticlesRequest.getPartner(), "", multiArticlesRequest.getAccessToken(), "MultiArticle", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        String jsonString = new String(response.getData());
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        MultiArticlesResponse getArticlesResponse = new MultiArticlesResponse();
        ArrayList<SingleArticleResponse.Result> articleList = new ArrayList<SingleArticleResponse.Result>();
        JSONObject result1 = jsonObject.getJSONObject("Result");
        JSONObject responseMetadataJson = jsonObject.getJSONObject("ResponseMetadata");
        CommonPo.ResponseMetadata responseMetadata = (CommonPo.ResponseMetadata)JSONObject.toJavaObject((JSON)responseMetadataJson, CommonPo.ResponseMetadata.class);
        getArticlesResponse.setResponseMetadata(responseMetadata);
        if (result1 == null) {
            return getArticlesResponse;
        }
        for (Map.Entry entry : result1.entrySet()) {
            SingleArticleResponse.Result articleInfo = (SingleArticleResponse.Result)JSONObject.toJavaObject((JSON)((JSONObject)entry.getValue()), SingleArticleResponse.Result.class);
            articleInfo.setGroupId((String)entry.getKey());
            articleList.add(articleInfo);
        }
        MultiArticlesResponse.Result result = new MultiArticlesResponse.Result();
        result.setArticleInfos(articleList);
        getArticlesResponse.setResult(result);
        return getArticlesResponse;
    }

    private void sendToMonitor(StreamConsumerService streamConsumerService, String partner, String category, String accessToken, String action, int httpCode, int topRespCode, byte[] respData, long latency) {
        if (this.needMonitor) {
            MonitorService monitorService = MonitorServiceImpl.getInstance(streamConsumerService.getAccessKey(), streamConsumerService.getSecretKey(), Mproxy);
            monitorService.monitor(partner, category, accessToken, action, httpCode, topRespCode, respData, latency);
        }
    }

    static {
        instance = null;
    }
}

