/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.videoaiot.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.model.ApiInfo;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.video_aiot.request.CloudRecordPlayRequest;
import com.volcengine.model.video_aiot.request.CreateDeviceRequest;
import com.volcengine.model.video_aiot.request.CreateSpaceRequest;
import com.volcengine.model.video_aiot.request.CreateStreamRequest;
import com.volcengine.model.video_aiot.request.DeviceCloudControlRequest;
import com.volcengine.model.video_aiot.request.DeviceCruiseControlRequest;
import com.volcengine.model.video_aiot.request.DeviceQueryPresetRequest;
import com.volcengine.model.video_aiot.request.DeviceRequest;
import com.volcengine.model.video_aiot.request.GetDataProjectWithBindWidthAndFlowRequest;
import com.volcengine.model.video_aiot.request.GetDeviceChannelRequest;
import com.volcengine.model.video_aiot.request.GetDeviceRequest;
import com.volcengine.model.video_aiot.request.GetStreamDataRequest;
import com.volcengine.model.video_aiot.request.GetStreamRequest;
import com.volcengine.model.video_aiot.request.ListAlarmNotifyRequest;
import com.volcengine.model.video_aiot.request.ListDeviceRecordsRequest;
import com.volcengine.model.video_aiot.request.ListDeviceRequest;
import com.volcengine.model.video_aiot.request.ListSpaceRequest;
import com.volcengine.model.video_aiot.request.ListStreamsRequest;
import com.volcengine.model.video_aiot.request.LocalMediaDownloadRequest;
import com.volcengine.model.video_aiot.request.ResetAlarmRequest;
import com.volcengine.model.video_aiot.request.SetAlarmGuardRequest;
import com.volcengine.model.video_aiot.request.SetSpaceTemplateRequest;
import com.volcengine.model.video_aiot.request.StartVoiceTalkRequest;
import com.volcengine.model.video_aiot.request.StopVoiceTalkRequest;
import com.volcengine.model.video_aiot.request.StreamLogsRequest;
import com.volcengine.model.video_aiot.request.StreamRequest;
import com.volcengine.model.video_aiot.request.UpdateAuthInSpaceRequest;
import com.volcengine.model.video_aiot.request.UpdateDeviceRequest;
import com.volcengine.model.video_aiot.request.UpdateSpaceRequest;
import com.volcengine.model.video_aiot.request.UpdateStreamRequest;
import com.volcengine.model.video_aiot.response.CloudPlayResponse;
import com.volcengine.model.video_aiot.response.CreateDeviceResponse;
import com.volcengine.model.video_aiot.response.DeviceQueryPresetResponse;
import com.volcengine.model.video_aiot.response.GetDataProjectWithBindWidthAndFlowResponse;
import com.volcengine.model.video_aiot.response.GetDeviceChannelResponse;
import com.volcengine.model.video_aiot.response.GetDeviceResponse;
import com.volcengine.model.video_aiot.response.GetStreamDataResponse;
import com.volcengine.model.video_aiot.response.GetStreamResponse;
import com.volcengine.model.video_aiot.response.GetTotalDataResponse;
import com.volcengine.model.video_aiot.response.IDResponse;
import com.volcengine.model.video_aiot.response.ListAlarmNotifyResponse;
import com.volcengine.model.video_aiot.response.ListDeviceRecordsResponse;
import com.volcengine.model.video_aiot.response.ListDeviceResponse;
import com.volcengine.model.video_aiot.response.ListSpaceResponse;
import com.volcengine.model.video_aiot.response.ListStreamsResponse;
import com.volcengine.model.video_aiot.response.LocalMediaDownloadResponse;
import com.volcengine.model.video_aiot.response.RawResponse;
import com.volcengine.model.video_aiot.response.SpaceResponse;
import com.volcengine.model.video_aiot.response.SpaceTemplateResponse;
import com.volcengine.model.video_aiot.response.StartVoiceTalkResponse;
import com.volcengine.model.video_aiot.response.StreamLogsResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.live.LiveConfig;
import com.volcengine.service.videoaiot.VideoAIoTConfig;
import com.volcengine.service.videoaiot.VideoAIoTService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class VideoAIoTServiceImpl
extends BaseServiceImpl
implements VideoAIoTService {
    private static final List<NameValuePair> emptyList = new ArrayList<NameValuePair>();

    private VideoAIoTServiceImpl() {
        super(VideoAIoTConfig.serviceInfoMap.get("cn-north-1"), VideoAIoTConfig.apiInfoList);
    }

    private VideoAIoTServiceImpl(ServiceInfo serviceInfo) {
        super(serviceInfo, VideoAIoTConfig.apiInfoList);
    }

    private VideoAIoTServiceImpl(ServiceInfo info, HttpHost proxy, Map<String, ApiInfo> apiInfoList) {
        super(info, proxy, apiInfoList);
    }

    private VideoAIoTServiceImpl(ServiceInfo info, Map<String, ApiInfo> apiInfoList) {
        super(info, apiInfoList);
    }

    public static VideoAIoTService getInstance() {
        return new VideoAIoTServiceImpl();
    }

    public static VideoAIoTService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = LiveConfig.serviceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("AIoTVideo not support region " + region);
        }
        return new VideoAIoTServiceImpl(serviceInfo);
    }

    @Override
    public IDResponse createSpace(CreateSpaceRequest createSpaceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("CreateSpace", emptyList, JSON.toJSONString((Object)createSpaceRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public SpaceResponse getSpace(final String spaceID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GetSpace", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (SpaceResponse)JSON.parseObject((byte[])response.getData(), SpaceResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListSpaceResponse listSpace(final ListSpaceRequest listSpaceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("ListSpaces", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("PageNumber", Integer.toString(listSpaceRequest.getPageNumber())));
                this.add(new BasicNameValuePair("PageSize", Integer.toString(listSpaceRequest.getPageSize())));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListSpaceResponse)JSON.parseObject((byte[])response.getData(), ListSpaceResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse startSpace(final String spaceID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StartSpace", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetDataProjectWithBindWidthAndFlowResponse getDataProjectWithBindWidthAndFlow(final GetDataProjectWithBindWidthAndFlowRequest getDataProjectWithBindWidthAndFlow) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("GetDataProjectWithBindWidthAndFlow", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", getDataProjectWithBindWidthAndFlow.getSpaceID()));
                this.add(new BasicNameValuePair("StartTime", getDataProjectWithBindWidthAndFlow.getStartTime()));
                this.add(new BasicNameValuePair("EndTime", getDataProjectWithBindWidthAndFlow.getEndTime()));
                this.add(new BasicNameValuePair("Data", getDataProjectWithBindWidthAndFlow.getData()));
                this.add(new BasicNameValuePair("StreamName", getDataProjectWithBindWidthAndFlow.getStreamName()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetDataProjectWithBindWidthAndFlowResponse)JSON.parseObject((byte[])response.getData(), GetDataProjectWithBindWidthAndFlowResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetTotalDataResponse getTotalData(final String time) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("GetTotalData", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("Time", time));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetTotalDataResponse)JSON.parseObject((byte[])response.getData(), GetTotalDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse stopSpace(final String spaceID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StopSpace", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse deleteSpace(final String spaceID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("DeleteSpace", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse updateSpace(final UpdateSpaceRequest updateSpaceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("UpdateSpace", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", updateSpaceRequest.getSpaceID()));
            }
        }, JSON.toJSONString((Object)updateSpaceRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse setSpaceTemplate(final SetSpaceTemplateRequest setSpaceTemplateRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("SetSpaceTemplate", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", setSpaceTemplateRequest.getSpaceID()));
                this.add(new BasicNameValuePair("TemplateType", setSpaceTemplateRequest.getTemplateType()));
            }
        }, JSON.toJSONString((Object)setSpaceTemplateRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse unsetSpaceTemplate(final String spaceID, final String templateType) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("CancelBindTemplate", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
                this.add(new BasicNameValuePair("TemplateType", templateType));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public SpaceTemplateResponse getSpaceTemplate(final String spaceID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GetSpaceTemplate", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (SpaceTemplateResponse)JSON.parseObject((byte[])response.getData(), SpaceTemplateResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse updateAuthInSpace(UpdateAuthInSpaceRequest updateAuthInSpace) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("UpdateAuthInSpace", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)updateAuthInSpace));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse disableAuthInSpace(final String spaceID, final String domain) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("DisableAuthInSpace", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
                this.add(new BasicNameValuePair("Domain", domain));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CreateDeviceResponse createDevice(final CreateDeviceRequest createDeviceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("CreateDevice", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", createDeviceRequest.getSpaceID()));
            }
        }, JSON.toJSONString((Object)createDeviceRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CreateDeviceResponse)JSON.parseObject((byte[])response.getData(), CreateDeviceResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListDeviceResponse listDevice(final ListDeviceRequest listDeviceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response;
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", listDeviceRequest.getSpaceID()));
                this.add(new BasicNameValuePair("PageSize", Integer.toString(listDeviceRequest.getPageSize())));
                this.add(new BasicNameValuePair("PageNumber", Integer.toString(listDeviceRequest.getPageNumber())));
            }
        };
        if (listDeviceRequest.getDeviceName() != null) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("DeviceName", listDeviceRequest.getDeviceName()));
        }
        if ((response = this.query("ListDevices", (List<NameValuePair>)nameValuePairs)).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListDeviceResponse)JSON.parseObject((byte[])response.getData(), ListDeviceResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetDeviceResponse getDevice(final GetDeviceRequest getDeviceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GetDevice", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", getDeviceRequest.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceID", getDeviceRequest.getDeviceID()));
                this.add(new BasicNameValuePair("SipServerID", getDeviceRequest.getSipServerID()));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetDeviceResponse)JSON.parseObject((byte[])response.getData(), GetDeviceResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LocalMediaDownloadResponse localMediaDownload(final LocalMediaDownloadRequest localMediaDownloadRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("LocalMediaDownload", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", localMediaDownloadRequest.getSpaceID()));
            }
        }, JSON.toJSONString((Object)localMediaDownloadRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LocalMediaDownloadResponse)JSON.parseObject((byte[])response.getData(), LocalMediaDownloadResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse freshDevice(final DeviceRequest freshDeviceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("FreshDevice", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", freshDeviceRequest.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceID", freshDeviceRequest.getDeviceID()));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse startDevice(final DeviceRequest startDevice) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StartDevice", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", startDevice.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceID", startDevice.getDeviceID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse stopDevice(final DeviceRequest stopDevice) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StopDevice", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", stopDevice.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceID", stopDevice.getDeviceID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse deleteDevice(final DeviceRequest deleteDevice) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("DeleteDevice", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", deleteDevice.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceID", deleteDevice.getDeviceID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse updateDevice(final UpdateDeviceRequest updateDeviceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("UpdateDevice", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", updateDeviceRequest.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceID", updateDeviceRequest.getDeviceID()));
            }
        }, JSON.toJSONString((Object)updateDeviceRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListDeviceRecordsResponse listDeviceScreenshots(final ListDeviceRecordsRequest listDeviceRecordsRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("ListDeviceScreenshots", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", listDeviceRecordsRequest.getSpaceID()));
                this.add(new BasicNameValuePair("StreamID", listDeviceRecordsRequest.getStreamID()));
                this.add(new BasicNameValuePair("PageNumber", Integer.toString(listDeviceRecordsRequest.getPageNumber())));
                this.add(new BasicNameValuePair("PageSize", Integer.toString(listDeviceRecordsRequest.getPageSize())));
            }
        }, JSON.toJSONString((Object)listDeviceRecordsRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListDeviceRecordsResponse)JSON.parseObject((byte[])response.getData(), ListDeviceRecordsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListDeviceRecordsResponse listDeviceRecords(final ListDeviceRecordsRequest listDeviceRecordsRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("ListDeviceRecords", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", listDeviceRecordsRequest.getSpaceID()));
                this.add(new BasicNameValuePair("StreamID", listDeviceRecordsRequest.getStreamID()));
                this.add(new BasicNameValuePair("PageNumber", Integer.toString(listDeviceRecordsRequest.getPageNumber())));
                this.add(new BasicNameValuePair("PageSize", Integer.toString(listDeviceRecordsRequest.getPageSize())));
            }
        }, JSON.toJSONString((Object)listDeviceRecordsRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListDeviceRecordsResponse)JSON.parseObject((byte[])response.getData(), ListDeviceRecordsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CloudPlayResponse cloudRecordPlay(CloudRecordPlayRequest cloudRecordPlayArgs) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("CloudRecordPlay", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)cloudRecordPlayArgs));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CloudPlayResponse)JSON.parseObject((byte[])response.getData(), CloudPlayResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse genSipID(final String sipServerID, final String deviceType) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GenSipID", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SipServerID", sipServerID));
                this.add(new BasicNameValuePair("DeviceType", deviceType));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetDeviceChannelResponse getDeviceChannels(final GetDeviceChannelRequest getDeviceChannelRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GetDeviceChannels", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("DeviceID", getDeviceChannelRequest.getDeviceID()));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetDeviceChannelResponse)JSON.parseObject((byte[])response.getData(), GetDeviceChannelResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse setAlarmGuard(final SetAlarmGuardRequest setAlarmGuardRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("SetAlarmGuard", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("DeviceNSID", setAlarmGuardRequest.getDeviceNSID()));
                this.add(new BasicNameValuePair("Enable", setAlarmGuardRequest.getEnable()));
                this.add(new BasicNameValuePair("SipID", setAlarmGuardRequest.getSipID()));
                this.add(new BasicNameValuePair("ChannelID", setAlarmGuardRequest.getChannelID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse resetAlarm(final ResetAlarmRequest resetAlarmRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("ResetAlarm", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("DeviceNSID", resetAlarmRequest.getDeviceNSID()));
                this.add(new BasicNameValuePair("SipID", resetAlarmRequest.getSipID()));
                this.add(new BasicNameValuePair("ChannelID", resetAlarmRequest.getChannelID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListAlarmNotifyResponse listAlarmNotify(ListAlarmNotifyRequest listAlarmNotifyRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("ListAlarmNotify", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)listAlarmNotifyRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListAlarmNotifyResponse)JSON.parseObject((byte[])response.getData(), ListAlarmNotifyResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse deleteAlarmNotify(final String alarmNotifyID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("DeleteAlarmNotify", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("AlarmNotifyID", alarmNotifyID));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse deleteAlarmNotifyAll(final String spaceID, final String deviceNSID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("DeleteAlarmNotifyAll", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
                this.add(new BasicNameValuePair("DeviceID", deviceNSID));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse cloudControl(DeviceCloudControlRequest deviceCloudControlRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("CloudControl", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)deviceCloudControlRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DeviceQueryPresetResponse queryPresetInfo(DeviceQueryPresetRequest queryPresetRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("QueryPresetInfo", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)queryPresetRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DeviceQueryPresetResponse)JSON.parseObject((byte[])response.getData(), DeviceQueryPresetResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse cruiseControl(DeviceCruiseControlRequest deviceCruiseControlRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("CruiseControl", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)deviceCruiseControlRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetStreamResponse getStream(final GetStreamRequest getStreamRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GetStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", getStreamRequest.getStreamID()));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetStreamResponse)JSON.parseObject((byte[])response.getData(), GetStreamResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListStreamsResponse listStreams(final ListStreamsRequest listStreamsRequest) throws Exception {
        com.volcengine.model.response.RawResponse response;
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", listStreamsRequest.getSpaceID()));
                this.add(new BasicNameValuePair("PageSize", Integer.toString(listStreamsRequest.getPageSize())));
                this.add(new BasicNameValuePair("PageNumber", Integer.toString(listStreamsRequest.getPageNumber())));
            }
        };
        if (listStreamsRequest.getStreamName() != null) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("StreamName", listStreamsRequest.getStreamName()));
        }
        if ((response = this.query("ListStreams", (List<NameValuePair>)nameValuePairs)).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListStreamsResponse)JSON.parseObject((byte[])response.getData(), ListStreamsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse updateStream(final UpdateStreamRequest updateStreamRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("UpdateStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", updateStreamRequest.getSpaceID()));
                this.add(new BasicNameValuePair("StreamID", updateStreamRequest.getStreamID()));
            }
        }, JSON.toJSONString((Object)updateStreamRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse startStream(final StreamRequest startStream) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StartStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", startStream.getStreamID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse stopStream(final StreamRequest stopStream) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StopStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", stopStream.getStreamID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public StreamLogsResponse streamLogs(final StreamLogsRequest streamLogs) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StreamLogs", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StartTs", streamLogs.getStartTs()));
                this.add(new BasicNameValuePair("EndTs", streamLogs.getEndTs()));
                this.add(new BasicNameValuePair("StreamID", streamLogs.getStreamID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (StreamLogsResponse)JSON.parseObject((byte[])response.getData(), StreamLogsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse createStream(final CreateStreamRequest createStream) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("CreateStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", createStream.getSpaceID()));
            }
        }, JSON.toJSONString((Object)createStream));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse deleteStream(final StreamRequest deleteStream) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("DeleteStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", deleteStream.getStreamID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetStreamDataResponse getStreamData(final GetStreamDataRequest getStreamData) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("GetStreamData", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", getStreamData.getStreamID()));
                this.add(new BasicNameValuePair("StartTime", getStreamData.getStartTime()));
                this.add(new BasicNameValuePair("EndTime", getStreamData.getEndTime()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetStreamDataResponse)JSON.parseObject((byte[])response.getData(), GetStreamDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse forbidStream(final String streamID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("ForbidStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", streamID));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse unForbidStream(final String streamID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("UnforbidStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", streamID));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public StartVoiceTalkResponse startVoiceTalk(final StartVoiceTalkRequest startVoiceTalkRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StartVoiceTalk", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", startVoiceTalkRequest.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceNSID", startVoiceTalkRequest.getDeviceNSID()));
                this.add(new BasicNameValuePair("Transport", startVoiceTalkRequest.transportToString()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (StartVoiceTalkResponse)JSON.parseObject((byte[])response.getData(), StartVoiceTalkResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse stopVoiceTalk(final StopVoiceTalkRequest stopVoiceTalkRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StopVoiceTalk", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", stopVoiceTalkRequest.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceNSID", stopVoiceTalkRequest.getDeviceNSID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }
}

