/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.vod.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicates;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.beans.UploadCompleteInfo;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.sts2.Policy;
import com.volcengine.model.sts2.SecurityToken2;
import com.volcengine.model.sts2.Statement;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.vod.IVodService;
import com.volcengine.service.vod.VodServiceConfig;
import com.volcengine.service.vod.model.business.VodUploadAddress;
import com.volcengine.service.vod.model.request.VodAddCallbackSubscriptionRequest;
import com.volcengine.service.vod.model.request.VodApplyUploadInfoRequest;
import com.volcengine.service.vod.model.request.VodCommitUploadInfoRequest;
import com.volcengine.service.vod.model.request.VodCreateCdnPreloadTaskRequest;
import com.volcengine.service.vod.model.request.VodCreateCdnRefreshTaskRequest;
import com.volcengine.service.vod.model.request.VodCreateSpaceRequest;
import com.volcengine.service.vod.model.request.VodCreateVideoClassificationRequest;
import com.volcengine.service.vod.model.request.VodDeleteMediaRequest;
import com.volcengine.service.vod.model.request.VodDeleteTranscodesRequest;
import com.volcengine.service.vod.model.request.VodDeleteVideoClassificationRequest;
import com.volcengine.service.vod.model.request.VodDescribeIPInfoRequest;
import com.volcengine.service.vod.model.request.VodDescribeVodDomainBandwidthDataRequest;
import com.volcengine.service.vod.model.request.VodDescribeVodDomainTrafficDataRequest;
import com.volcengine.service.vod.model.request.VodDescribeVodSpaceStorageDataRequest;
import com.volcengine.service.vod.model.request.VodGetAllPlayInfoRequest;
import com.volcengine.service.vod.model.request.VodGetAppInfoRequest;
import com.volcengine.service.vod.model.request.VodGetAudioEventDetectionForAuditRequest;
import com.volcengine.service.vod.model.request.VodGetAudioInfoForAuditRequest;
import com.volcengine.service.vod.model.request.VodGetAuditFramesForAuditRequest;
import com.volcengine.service.vod.model.request.VodGetAutomaticSpeechRecognitionForAuditRequest;
import com.volcengine.service.vod.model.request.VodGetBetterFramesForAuditRequest;
import com.volcengine.service.vod.model.request.VodGetDirectEditProgressRequest;
import com.volcengine.service.vod.model.request.VodGetDirectEditResultRequest;
import com.volcengine.service.vod.model.request.VodGetHlsDecryptionKeyRequest;
import com.volcengine.service.vod.model.request.VodGetMLFramesForAuditRequest;
import com.volcengine.service.vod.model.request.VodGetMediaInfosRequest;
import com.volcengine.service.vod.model.request.VodGetMediaListRequest;
import com.volcengine.service.vod.model.request.VodGetPlayInfoRequest;
import com.volcengine.service.vod.model.request.VodGetPlayInfoWithLiveTimeShiftSceneRequest;
import com.volcengine.service.vod.model.request.VodGetPrivateDrmPlayAuthRequest;
import com.volcengine.service.vod.model.request.VodGetRecommendedPosterRequest;
import com.volcengine.service.vod.model.request.VodGetSmartStrategyLitePlayInfoRequest;
import com.volcengine.service.vod.model.request.VodGetSpaceDetailRequest;
import com.volcengine.service.vod.model.request.VodGetSubtitleInfoListRequest;
import com.volcengine.service.vod.model.request.VodGetWorkflowExecutionStatusRequest;
import com.volcengine.service.vod.model.request.VodListCdnAccessLogRequest;
import com.volcengine.service.vod.model.request.VodListCdnPvDataRequest;
import com.volcengine.service.vod.model.request.VodListCdnStatusDataRequest;
import com.volcengine.service.vod.model.request.VodListCdnTasksRequest;
import com.volcengine.service.vod.model.request.VodListCdnTopAccessUrlRequest;
import com.volcengine.service.vod.model.request.VodListCdnUsageDataRequest;
import com.volcengine.service.vod.model.request.VodListDomainRequest;
import com.volcengine.service.vod.model.request.VodListSnapshotsRequest;
import com.volcengine.service.vod.model.request.VodListSpaceRequest;
import com.volcengine.service.vod.model.request.VodListVideoClassificationsRequest;
import com.volcengine.service.vod.model.request.VodQueryUploadTaskInfoRequest;
import com.volcengine.service.vod.model.request.VodRetrieveTranscodeResultRequest;
import com.volcengine.service.vod.model.request.VodSetCallbackEventRequest;
import com.volcengine.service.vod.model.request.VodStartWorkflowRequest;
import com.volcengine.service.vod.model.request.VodSubmitDirectEditTaskAsyncRequest;
import com.volcengine.service.vod.model.request.VodUpdateMediaInfoRequest;
import com.volcengine.service.vod.model.request.VodUpdateMediaPublishStatusRequest;
import com.volcengine.service.vod.model.request.VodUpdateSpaceRequest;
import com.volcengine.service.vod.model.request.VodUpdateSpaceUploadConfigRequest;
import com.volcengine.service.vod.model.request.VodUpdateSubtitleInfoRequest;
import com.volcengine.service.vod.model.request.VodUpdateSubtitleStatusRequest;
import com.volcengine.service.vod.model.request.VodUpdateVideoClassificationRequest;
import com.volcengine.service.vod.model.request.VodUploadMaterialRequest;
import com.volcengine.service.vod.model.request.VodUploadMediaRequest;
import com.volcengine.service.vod.model.request.VodUrlUploadRequest;
import com.volcengine.service.vod.model.response.VodAddCallbackSubscriptionResponse;
import com.volcengine.service.vod.model.response.VodApplyUploadInfoResponse;
import com.volcengine.service.vod.model.response.VodCdnStatisticsCommonResponse;
import com.volcengine.service.vod.model.response.VodCommitUploadInfoResponse;
import com.volcengine.service.vod.model.response.VodCreateCdnPreloadTaskResponse;
import com.volcengine.service.vod.model.response.VodCreateCdnRefreshTaskResponse;
import com.volcengine.service.vod.model.response.VodCreateSpaceResponse;
import com.volcengine.service.vod.model.response.VodCreateVideoClassificationResponse;
import com.volcengine.service.vod.model.response.VodDeleteMediaResponse;
import com.volcengine.service.vod.model.response.VodDeleteTranscodesResponse;
import com.volcengine.service.vod.model.response.VodDeleteVideoClassificationResponse;
import com.volcengine.service.vod.model.response.VodDescribeIPInfoResponse;
import com.volcengine.service.vod.model.response.VodDescribeVodDomainBandwidthDataResponse;
import com.volcengine.service.vod.model.response.VodDescribeVodDomainTrafficDataResponse;
import com.volcengine.service.vod.model.response.VodDescribeVodSpaceStorageDataResponse;
import com.volcengine.service.vod.model.response.VodGetAllPlayInfoResponse;
import com.volcengine.service.vod.model.response.VodGetAppInfoResponse;
import com.volcengine.service.vod.model.response.VodGetAudioEventDetectionForAuditResponse;
import com.volcengine.service.vod.model.response.VodGetAudioInfoForAuditResponse;
import com.volcengine.service.vod.model.response.VodGetAuditFramesForAuditResponse;
import com.volcengine.service.vod.model.response.VodGetAutomaticSpeechRecognitionForAuditResponse;
import com.volcengine.service.vod.model.response.VodGetBetterFramesForAuditResponse;
import com.volcengine.service.vod.model.response.VodGetDirectEditProgressResponse;
import com.volcengine.service.vod.model.response.VodGetDirectEditResultResponse;
import com.volcengine.service.vod.model.response.VodGetHlsDecryptionKeyResponse;
import com.volcengine.service.vod.model.response.VodGetMLFramesForAuditResponse;
import com.volcengine.service.vod.model.response.VodGetMediaInfosResponse;
import com.volcengine.service.vod.model.response.VodGetMediaListResponse;
import com.volcengine.service.vod.model.response.VodGetPlayInfoResponse;
import com.volcengine.service.vod.model.response.VodGetPlayInfoWithLiveTimeShiftSceneResponse;
import com.volcengine.service.vod.model.response.VodGetPrivateDrmPlayAuthResponse;
import com.volcengine.service.vod.model.response.VodGetRecommendedPosterResponse;
import com.volcengine.service.vod.model.response.VodGetSmartStrategyLitePlayInfoResponse;
import com.volcengine.service.vod.model.response.VodGetSpaceDetailResponse;
import com.volcengine.service.vod.model.response.VodGetSubtitleInfoListResponse;
import com.volcengine.service.vod.model.response.VodGetWorkflowExecutionStatusResponse;
import com.volcengine.service.vod.model.response.VodListCdnAccessLogResponse;
import com.volcengine.service.vod.model.response.VodListCdnTasksResponse;
import com.volcengine.service.vod.model.response.VodListCdnTopAccessUrlResponse;
import com.volcengine.service.vod.model.response.VodListDomainResponse;
import com.volcengine.service.vod.model.response.VodListSnapshotsResponse;
import com.volcengine.service.vod.model.response.VodListSpaceResponse;
import com.volcengine.service.vod.model.response.VodListVideoClassificationsResponse;
import com.volcengine.service.vod.model.response.VodQueryUploadTaskInfoResponse;
import com.volcengine.service.vod.model.response.VodRetrieveTranscodeResultResponse;
import com.volcengine.service.vod.model.response.VodSetCallbackEventResponse;
import com.volcengine.service.vod.model.response.VodStartWorkflowResponse;
import com.volcengine.service.vod.model.response.VodSubmitDirectEditTaskAsyncResponse;
import com.volcengine.service.vod.model.response.VodUpdateMediaInfoResponse;
import com.volcengine.service.vod.model.response.VodUpdateMediaPublishStatusResponse;
import com.volcengine.service.vod.model.response.VodUpdateSpaceResponse;
import com.volcengine.service.vod.model.response.VodUpdateSpaceUploadConfigResponse;
import com.volcengine.service.vod.model.response.VodUpdateSubtitleInfoResponse;
import com.volcengine.service.vod.model.response.VodUpdateSubtitleStatusResponse;
import com.volcengine.service.vod.model.response.VodUpdateVideoClassificationResponse;
import com.volcengine.service.vod.model.response.VodUrlUploadResponse;
import com.volcengine.util.Sts2Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.util.EntityUtils;

public class VodServiceImpl
extends BaseServiceImpl
implements IVodService {
    private static final VodServiceImpl CN_NORTH_1_SERVICE = new VodServiceImpl();

    public static IVodService getInstance() {
        return CN_NORTH_1_SERVICE;
    }

    protected VodServiceImpl() {
        super(VodServiceConfig.ServiceInfoMap.get("cn-north-1"), VodServiceConfig.apiInfoList);
    }

    public static IVodService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = VodServiceConfig.ServiceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("Cant find the region, please check it carefully");
        }
        switch (region) {
            case "cn-north-1": {
                return CN_NORTH_1_SERVICE;
            }
        }
        throw new Exception("Cant find the region, please check it carefully");
    }

    @Override
    public String getPrivateDrmAuthToken(VodGetPrivateDrmPlayAuthRequest input, Long expireSeconds) throws Exception {
        Map<String, String> params = Utils.protoBufferToMap(input, false);
        if (expireSeconds != null && expireSeconds > 0L) {
            params.put("X-Expires", expireSeconds.toString());
        }
        return this.getSignUrl("GetPrivateDrmPlayAuth", Utils.mapToPairList(params));
    }

    @Override
    public String createSha1HlsDrmAuthToken(Long expireSeconds) throws Exception {
        return this.createHlsDrmAuthToken("HMAC-SHA1", expireSeconds);
    }

    public String createHlsDrmAuthToken(String dsa, Long expireSeconds) throws Exception {
        if (expireSeconds == null || expireSeconds <= 0L) {
            throw new Exception("Invalid Expire");
        }
        String token = this.createAuth(dsa, expireSeconds);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DrmAuthToken", token);
        params.put("X-Expires", expireSeconds.toString());
        return this.getSignUrl("GetHlsDecryptionKey", Utils.mapToPairList(params));
    }

    private String createAuth(String dsa, long expireSeconds) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.getAccessKey())) {
            throw new Exception("Invalid Ak");
        }
        if (StringUtils.isBlank((CharSequence)this.getSecretKey())) {
            throw new Exception("Invalid Sk");
        }
        long deadline = System.currentTimeMillis() / 1000L + expireSeconds;
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(tz);
        String deadlineDate = df.format(new Date(deadline * 1000L));
        String timestamp = String.valueOf(deadline);
        byte[] kDate = Utils.hmacSHA256(this.getSecretKey().getBytes(), deadlineDate);
        byte[] kRegion = Utils.hmacSHA256(kDate, this.getRegion());
        byte[] kService = Utils.hmacSHA256(kRegion, "vod");
        byte[] kCredentials = Utils.hmacSHA256(kService, "request");
        String key = Hex.encodeHexString((byte[])kCredentials);
        String signDataString = StringUtils.join((Object[])new String[]{dsa, "&", "2.0", "&", timestamp});
        String sign = "";
        switch (dsa) {
            case "HMAC-SHA1": {
                sign = Base64.encodeBase64String((byte[])Utils.hmacSHA1(key.getBytes(), signDataString));
                break;
            }
            case "HMAC-SHA256": {
                sign = Base64.encodeBase64String((byte[])Utils.hmacSHA256(key.getBytes(), signDataString));
                break;
            }
            default: {
                sign = Base64.encodeBase64String((byte[])"".getBytes());
            }
        }
        return StringUtils.join((Object[])new String[]{dsa, ":", "2.0", ":", timestamp, ":", this.getAccessKey(), ":", sign});
    }

    @Override
    public String getSubtitleAuthToken(VodGetSubtitleInfoListRequest input, Long expireSeconds) throws Exception {
        if (input.getVid() == "") {
            throw new Exception("\u4f20\u5165\u7684Vid\u4e3a\u7a7a");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Vid", input.getVid());
        params.put("Status", "Published");
        if (expireSeconds != null && expireSeconds > 0L) {
            params.put("X-Expires", expireSeconds.toString());
        }
        String getSubtitleAuthToken = this.getSignUrl("GetSubtitleInfoList", Utils.mapToPairList(params));
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("GetSubtitleAuthToken", getSubtitleAuthToken);
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = java.util.Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public String getPlayAuthToken(VodGetPlayInfoRequest input, Long expireSeconds) throws Exception {
        Map<String, String> params = Utils.protoBufferToMap(input, false);
        if (expireSeconds != null && expireSeconds > 0L) {
            params.put("X-Expires", expireSeconds.toString());
        }
        String getPlayInfoToken = this.getSignUrl("GetPlayInfo", Utils.mapToPairList(params));
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("GetPlayInfoToken", getPlayInfoToken);
        ret.put("TokenVersion", "V2");
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = java.util.Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public SecurityToken2 getUploadSts2() throws Exception {
        return this.getUploadSts2WithExpire(3600000L);
    }

    @Override
    public SecurityToken2 getUploadSts2WithExpire(long expire) throws Exception {
        Policy inlinePolicy = new Policy();
        ArrayList<String> actions = new ArrayList<String>();
        actions.add("vod:ApplyUploadInfo");
        actions.add("vod:CommitUploadInfo");
        ArrayList<String> resources = new ArrayList<String>();
        Statement statement = Sts2Utils.newAllowStatement(actions, resources);
        inlinePolicy.addStatement(statement);
        return this.signSts2(inlinePolicy, expire);
    }

    @Override
    public VodCommitUploadInfoResponse uploadMedia(VodUploadMediaRequest vodUploadMediaRequest) throws Exception {
        UploadCompleteInfo uploadCompleteInfo = this.uploadToB(vodUploadMediaRequest.getSpaceName(), vodUploadMediaRequest.getFilePath(), "media", vodUploadMediaRequest.getFileName());
        VodCommitUploadInfoRequest vodCommitUploadInfoRequest = VodCommitUploadInfoRequest.newBuilder().setSpaceName(vodUploadMediaRequest.getSpaceName()).setSessionKey(uploadCompleteInfo.getSessionKey()).setFunctions(vodUploadMediaRequest.getFunctions()).setCallbackArgs(vodUploadMediaRequest.getCallbackArgs()).build();
        return this.commitUploadInfo(vodCommitUploadInfoRequest);
    }

    private UploadCompleteInfo uploadToB(String spaceName, String filePath, String fileType, String fileName) throws Exception {
        File file = new File(filePath);
        if (!file.isFile() || !file.exists()) {
            throw new Exception(SdkError.getErrorDesc(SdkError.ENOFILE));
        }
        VodApplyUploadInfoRequest vodApplyUploadInfoRequest = VodApplyUploadInfoRequest.newBuilder().setSpaceName(spaceName).setFileName(fileName).setFileType(fileType).build();
        VodApplyUploadInfoResponse vodApplyUploadInfoResponse = this.applyUploadInfo(vodApplyUploadInfoRequest);
        if (vodApplyUploadInfoResponse.getResponseMetadata().hasError()) {
            throw new Exception(vodApplyUploadInfoResponse.getResponseMetadata().getError().getMessage());
        }
        VodUploadAddress vodUploadAddress = vodApplyUploadInfoResponse.getResult().getData().getUploadAddress();
        if (!vodApplyUploadInfoResponse.hasResult() || vodUploadAddress.getStoreInfosCount() == 0) {
            throw new Exception("apply upload result is null");
        }
        String oid = vodUploadAddress.getStoreInfos(0).getStoreUri();
        String sessionKey = vodUploadAddress.getSessionKey();
        String auth = vodUploadAddress.getStoreInfos(0).getAuth();
        String host = vodUploadAddress.getUploadHosts(0);
        Retryer retryer = RetryerBuilder.newBuilder().retryIfException().retryIfResult(Predicates.equalTo((Object)false)).retryIfResult(Predicates.isNull()).withWaitStrategy(WaitStrategies.exponentialWait()).withStopStrategy(StopStrategies.stopAfterAttempt((int)3)).build();
        if (file.length() < 0x1400000L) {
            this.directUpload(host, oid, auth, file, retryer);
        } else {
            boolean isLargeFile = false;
            if (file.length() > 0x40000000L) {
                isLargeFile = true;
            }
            this.chunkUpload(host, oid, auth, file, isLargeFile, retryer);
        }
        UploadCompleteInfo uploadCompleteInfo = new UploadCompleteInfo(oid, sessionKey);
        return uploadCompleteInfo;
    }

    private void directUpload(String host, String oid, String auth, File file, Retryer retryer) throws Exception {
        String oidEncode = StringUtils.replace((String)oid, (String)" ", (String)"%20");
        String url = String.format("https://%s/%s", host, oidEncode);
        byte[] bytes = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
        long crc32 = Utils.crc32(bytes);
        String checkSum = String.format("%08x", crc32);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", auth);
        headers.put("Content-CRC32", checkSum);
        retryer.call(() -> this.putData(url, bytes, headers));
    }

    private void chunkUpload(String host, String oid, String auth, File file, boolean isLargeFile, Retryer retryer) throws Exception {
        String uploadID = this.initUploadPart(host, oid, auth, isLargeFile, retryer);
        byte[] data = new byte[0x1400000];
        ArrayList<String> parts = new ArrayList<String>();
        long num = file.length() / 0x1400000L;
        long lastNum = num - 1L;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            long partNumber;
            for (long i = 0L; i < lastNum; ++i) {
                bis.read(data);
                partNumber = isLargeFile ? i + 1L : i;
                parts.add(this.uploadPart(host, oid, auth, uploadID, partNumber, data, isLargeFile, retryer));
            }
            long readCount = 0x1400000L * lastNum;
            int len = (int)(file.length() - readCount);
            byte[] lastPart = new byte[len];
            bis.read(lastPart);
            partNumber = isLargeFile ? lastNum + 1L : lastNum;
            parts.add(this.uploadPart(host, oid, auth, uploadID, partNumber, lastPart, isLargeFile, retryer));
        }
        this.uploadMergePart(host, oid, auth, uploadID, (String[])parts.stream().toArray(String[]::new), isLargeFile, retryer);
    }

    private String initUploadPart(String host, String oid, String auth, boolean isLargeFile, Retryer retryer) throws ExecutionException, RetryException, IOException {
        HttpResponse httpResponse;
        String oidEncode = StringUtils.replace((String)oid, (String)" ", (String)"%20");
        String url = String.format("http://%s/%s?uploads", host, oidEncode);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", auth);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        if ((httpResponse = (HttpResponse)retryer.call(() -> this.putDataWithResponse(url, new byte[0], headers))) == null) {
            throw new RuntimeException("init part error,response is empty");
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("http code is " + httpResponse.getStatusLine().getStatusCode());
        }
        String entity = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        JSONObject result = JSONObject.parseObject((String)entity);
        return result.getJSONObject("payload").getInnerMap().get("uploadID").toString();
    }

    private String uploadPart(String host, String oid, String auth, String uploadID, long partNumber, byte[] data, boolean isLargeFile, Retryer retryer) throws Exception {
        String oidEncode = StringUtils.replace((String)oid, (String)" ", (String)"%20");
        String url = String.format("http://%s/%s?partNumber=%d&uploadID=%s", host, oidEncode, partNumber, uploadID);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", auth);
        long crc32 = Utils.crc32(data);
        String checkSum = String.format("%08x", crc32);
        headers.put("Content-CRC32", checkSum);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        retryer.call(() -> this.putData(url, data, headers));
        return checkSum;
    }

    private void uploadMergePart(String host, String oid, String auth, String uploadID, String[] checkSum, boolean isLargeFile, Retryer retryer) throws ExecutionException, RetryException {
        String oidEncode = StringUtils.replace((String)oid, (String)" ", (String)"%20");
        String url = String.format("http://%s/%s?uploadID=%s", host, oidEncode, uploadID);
        String body = IntStream.range(0, checkSum.length).mapToObj(i -> String.format("%d:%s", i, checkSum[i])).collect(Collectors.joining(",", "", ""));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", auth);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        retryer.call(() -> this.putData(url, body.getBytes(), headers));
    }

    @Override
    public VodCommitUploadInfoResponse uploadMaterial(VodUploadMaterialRequest vodUploadMaterialRequest) throws Exception {
        UploadCompleteInfo uploadCompleteInfo = this.uploadToB(vodUploadMaterialRequest.getSpaceName(), vodUploadMaterialRequest.getFilePath(), vodUploadMaterialRequest.getFileType(), vodUploadMaterialRequest.getFileName());
        VodCommitUploadInfoRequest vodCommitUploadInfoRequest = VodCommitUploadInfoRequest.newBuilder().setSpaceName(vodUploadMaterialRequest.getSpaceName()).setSessionKey(uploadCompleteInfo.getSessionKey()).setFunctions(vodUploadMaterialRequest.getFunctions()).setCallbackArgs(vodUploadMaterialRequest.getCallbackArgs()).build();
        return this.commitUploadInfo(vodCommitUploadInfoRequest);
    }

    @Override
    public VodSubmitDirectEditTaskAsyncResponse submitDirectEditTaskAsync(VodSubmitDirectEditTaskAsyncRequest input) throws Exception {
        RawResponse response;
        String jsonData = JsonFormat.printer().print((MessageOrBuilder)input);
        JSONObject inputMap = JSON.parseObject((String)jsonData);
        if (inputMap.containsKey("EditParam")) {
            JSONObject editParam = JSON.parseObject((String)input.getEditParam().toString(StandardCharsets.UTF_8));
            inputMap.put("EditParam", editParam);
        }
        if ((response = this.json("SubmitDirectEditTaskAsync", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)inputMap))).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodSubmitDirectEditTaskAsyncResponse.Builder responseBuilder = VodSubmitDirectEditTaskAsyncResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public com.volcengine.service.vod.model.response.VodGetDirectEditResultResponse getDirectEditResult(VodGetDirectEditResultRequest input) throws Exception {
        String jsonData = JsonFormat.printer().print((MessageOrBuilder)input);
        RawResponse response = this.json("GetDirectEditResult", new ArrayList<NameValuePair>(), jsonData);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetDirectEditResultResponse resp = (VodGetDirectEditResultResponse)JSON.parseObject((byte[])response.getData(), VodGetDirectEditResultResponse.class, (Feature[])new Feature[0]);
        if (resp.result != null) {
            for (int i = 0; i < resp.result.size(); ++i) {
                Map<String, Object> value = resp.result.get(i);
                if (!value.containsKey("EditParam")) continue;
                Object editParam = value.get("EditParam");
                byte[] editParamBytes = JSON.toJSONBytes((Object)editParam, (SerializerFeature[])new SerializerFeature[0]);
                value.put("EditParam", editParamBytes);
                resp.result.set(i, value);
            }
        }
        VodGetDirectEditResultResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetDirectEditResultResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(JSON.toJSONBytes((Object)resp, (SerializerFeature[])new SerializerFeature[0]))), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public com.volcengine.service.vod.model.response.VodGetDirectEditProgressResponse getDirectEditProgress(VodGetDirectEditProgressRequest input) throws Exception {
        RawResponse response = this.query("GetDirectEditProgress", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetDirectEditProgressResponse resp = (VodGetDirectEditProgressResponse)JSON.parseObject((byte[])response.getData(), VodGetDirectEditProgressResponse.class, (Feature[])new Feature[0]);
        if (resp.result != null) {
            Result res = new Result();
            res.result = (Integer)resp.result;
            resp.result = res;
        }
        VodGetDirectEditProgressResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetDirectEditProgressResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(JSON.toJSONBytes((Object)resp, (SerializerFeature[])new SerializerFeature[0]))), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetAllPlayInfoResponse getAllPlayInfo(VodGetAllPlayInfoRequest input) throws Exception {
        RawResponse response = this.query("GetAllPlayInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetAllPlayInfoResponse.Builder responseBuilder = VodGetAllPlayInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetPlayInfoResponse getPlayInfo(VodGetPlayInfoRequest input) throws Exception {
        RawResponse response = this.query("GetPlayInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetPlayInfoResponse.Builder responseBuilder = VodGetPlayInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetPrivateDrmPlayAuthResponse getPrivateDrmPlayAuth(VodGetPrivateDrmPlayAuthRequest input) throws Exception {
        RawResponse response = this.query("GetPrivateDrmPlayAuth", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetPrivateDrmPlayAuthResponse.Builder responseBuilder = VodGetPrivateDrmPlayAuthResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetHlsDecryptionKeyResponse getHlsDecryptionKey(VodGetHlsDecryptionKeyRequest input) throws Exception {
        RawResponse response = this.query("GetHlsDecryptionKey", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetHlsDecryptionKeyResponse.Builder responseBuilder = VodGetHlsDecryptionKeyResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetPlayInfoWithLiveTimeShiftSceneResponse getPlayInfoWithLiveTimeShiftScene(VodGetPlayInfoWithLiveTimeShiftSceneRequest input) throws Exception {
        RawResponse response = this.query("GetPlayInfoWithLiveTimeShiftScene", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetPlayInfoWithLiveTimeShiftSceneResponse.Builder responseBuilder = VodGetPlayInfoWithLiveTimeShiftSceneResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUrlUploadResponse uploadMediaByUrl(VodUrlUploadRequest input) throws Exception {
        RawResponse response = this.query("UploadMediaByUrl", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUrlUploadResponse.Builder responseBuilder = VodUrlUploadResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodQueryUploadTaskInfoResponse queryUploadTaskInfo(VodQueryUploadTaskInfoRequest input) throws Exception {
        RawResponse response = this.query("QueryUploadTaskInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodQueryUploadTaskInfoResponse.Builder responseBuilder = VodQueryUploadTaskInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodApplyUploadInfoResponse applyUploadInfo(VodApplyUploadInfoRequest input) throws Exception {
        RawResponse response = this.query("ApplyUploadInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodApplyUploadInfoResponse.Builder responseBuilder = VodApplyUploadInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCommitUploadInfoResponse commitUploadInfo(VodCommitUploadInfoRequest input) throws Exception {
        RawResponse response = this.query("CommitUploadInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCommitUploadInfoResponse.Builder responseBuilder = VodCommitUploadInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateMediaInfoResponse updateMediaInfo(VodUpdateMediaInfoRequest input) throws Exception {
        RawResponse response = this.query("UpdateMediaInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateMediaInfoResponse.Builder responseBuilder = VodUpdateMediaInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateMediaPublishStatusResponse updateMediaPublishStatus(VodUpdateMediaPublishStatusRequest input) throws Exception {
        RawResponse response = this.query("UpdateMediaPublishStatus", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateMediaPublishStatusResponse.Builder responseBuilder = VodUpdateMediaPublishStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetMediaInfosResponse getMediaInfos(VodGetMediaInfosRequest input) throws Exception {
        RawResponse response = this.query("GetMediaInfos", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetMediaInfosResponse.Builder responseBuilder = VodGetMediaInfosResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetRecommendedPosterResponse getRecommendedPoster(VodGetRecommendedPosterRequest input) throws Exception {
        RawResponse response = this.query("GetRecommendedPoster", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetRecommendedPosterResponse.Builder responseBuilder = VodGetRecommendedPosterResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteMediaResponse deleteMedia(VodDeleteMediaRequest input) throws Exception {
        RawResponse response = this.query("DeleteMedia", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteMediaResponse.Builder responseBuilder = VodDeleteMediaResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteTranscodesResponse deleteTranscodes(VodDeleteTranscodesRequest input) throws Exception {
        RawResponse response = this.query("DeleteTranscodes", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteTranscodesResponse.Builder responseBuilder = VodDeleteTranscodesResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetMediaListResponse getMediaList(VodGetMediaListRequest input) throws Exception {
        RawResponse response = this.query("GetMediaList", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetMediaListResponse.Builder responseBuilder = VodGetMediaListResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetSubtitleInfoListResponse getSubtitleInfoList(VodGetSubtitleInfoListRequest input) throws Exception {
        RawResponse response = this.query("GetSubtitleInfoList", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetSubtitleInfoListResponse.Builder responseBuilder = VodGetSubtitleInfoListResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateSubtitleStatusResponse updateSubtitleStatus(VodUpdateSubtitleStatusRequest input) throws Exception {
        RawResponse response = this.query("UpdateSubtitleStatus", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateSubtitleStatusResponse.Builder responseBuilder = VodUpdateSubtitleStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateSubtitleInfoResponse updateSubtitleInfo(VodUpdateSubtitleInfoRequest input) throws Exception {
        RawResponse response = this.query("UpdateSubtitleInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateSubtitleInfoResponse.Builder responseBuilder = VodUpdateSubtitleInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetAuditFramesForAuditResponse getAuditFramesForAudit(VodGetAuditFramesForAuditRequest input) throws Exception {
        RawResponse response = this.query("GetAuditFramesForAudit", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetAuditFramesForAuditResponse.Builder responseBuilder = VodGetAuditFramesForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetMLFramesForAuditResponse getMLFramesForAudit(VodGetMLFramesForAuditRequest input) throws Exception {
        RawResponse response = this.query("GetMLFramesForAudit", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetMLFramesForAuditResponse.Builder responseBuilder = VodGetMLFramesForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetBetterFramesForAuditResponse getBetterFramesForAudit(VodGetBetterFramesForAuditRequest input) throws Exception {
        RawResponse response = this.query("GetBetterFramesForAudit", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetBetterFramesForAuditResponse.Builder responseBuilder = VodGetBetterFramesForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetAudioInfoForAuditResponse getAudioInfoForAudit(VodGetAudioInfoForAuditRequest input) throws Exception {
        RawResponse response = this.query("GetAudioInfoForAudit", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetAudioInfoForAuditResponse.Builder responseBuilder = VodGetAudioInfoForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetAutomaticSpeechRecognitionForAuditResponse getAutomaticSpeechRecognitionForAudit(VodGetAutomaticSpeechRecognitionForAuditRequest input) throws Exception {
        RawResponse response = this.query("GetAutomaticSpeechRecognitionForAudit", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetAutomaticSpeechRecognitionForAuditResponse.Builder responseBuilder = VodGetAutomaticSpeechRecognitionForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetAudioEventDetectionForAuditResponse getAudioEventDetectionForAudit(VodGetAudioEventDetectionForAuditRequest input) throws Exception {
        RawResponse response = this.query("GetAudioEventDetectionForAudit", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetAudioEventDetectionForAuditResponse.Builder responseBuilder = VodGetAudioEventDetectionForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateVideoClassificationResponse createVideoClassification(VodCreateVideoClassificationRequest input) throws Exception {
        RawResponse response = this.query("CreateVideoClassification", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateVideoClassificationResponse.Builder responseBuilder = VodCreateVideoClassificationResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateVideoClassificationResponse updateVideoClassification(VodUpdateVideoClassificationRequest input) throws Exception {
        RawResponse response = this.query("UpdateVideoClassification", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateVideoClassificationResponse.Builder responseBuilder = VodUpdateVideoClassificationResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteVideoClassificationResponse deleteVideoClassification(VodDeleteVideoClassificationRequest input) throws Exception {
        RawResponse response = this.query("DeleteVideoClassification", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteVideoClassificationResponse.Builder responseBuilder = VodDeleteVideoClassificationResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListVideoClassificationsResponse listVideoClassifications(VodListVideoClassificationsRequest input) throws Exception {
        RawResponse response = this.query("ListVideoClassifications", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListVideoClassificationsResponse.Builder responseBuilder = VodListVideoClassificationsResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListSnapshotsResponse listSnapshots(VodListSnapshotsRequest input) throws Exception {
        RawResponse response = this.query("ListSnapshots", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListSnapshotsResponse.Builder responseBuilder = VodListSnapshotsResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodStartWorkflowResponse startWorkflow(VodStartWorkflowRequest input) throws Exception {
        RawResponse response = this.query("StartWorkflow", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodStartWorkflowResponse.Builder responseBuilder = VodStartWorkflowResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodRetrieveTranscodeResultResponse retrieveTranscodeResult(VodRetrieveTranscodeResultRequest input) throws Exception {
        RawResponse response = this.query("RetrieveTranscodeResult", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodRetrieveTranscodeResultResponse.Builder responseBuilder = VodRetrieveTranscodeResultResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetWorkflowExecutionStatusResponse GetWorkflowExecution(VodGetWorkflowExecutionStatusRequest input) throws Exception {
        RawResponse response = this.query("GetWorkflowExecution", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetWorkflowExecutionStatusResponse.Builder responseBuilder = VodGetWorkflowExecutionStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateSpaceResponse createSpace(VodCreateSpaceRequest input) throws Exception {
        RawResponse response = this.query("CreateSpace", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateSpaceResponse.Builder responseBuilder = VodCreateSpaceResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListSpaceResponse listSpace(VodListSpaceRequest input) throws Exception {
        RawResponse response = this.query("ListSpace", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListSpaceResponse.Builder responseBuilder = VodListSpaceResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetSpaceDetailResponse getSpaceDetail(VodGetSpaceDetailRequest input) throws Exception {
        RawResponse response = this.query("GetSpaceDetail", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetSpaceDetailResponse.Builder responseBuilder = VodGetSpaceDetailResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateSpaceResponse updateSpace(VodUpdateSpaceRequest input) throws Exception {
        RawResponse response = this.query("UpdateSpace", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateSpaceResponse.Builder responseBuilder = VodUpdateSpaceResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateSpaceUploadConfigResponse updateSpaceUploadConfig(VodUpdateSpaceUploadConfigRequest input) throws Exception {
        RawResponse response = this.query("UpdateSpaceUploadConfig", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateSpaceUploadConfigResponse.Builder responseBuilder = VodUpdateSpaceUploadConfigResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDescribeVodSpaceStorageDataResponse describeVodSpaceStorageData(VodDescribeVodSpaceStorageDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodSpaceStorageData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDescribeVodSpaceStorageDataResponse.Builder responseBuilder = VodDescribeVodSpaceStorageDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListDomainResponse listDomain(VodListDomainRequest input) throws Exception {
        RawResponse response = this.query("ListDomain", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListDomainResponse.Builder responseBuilder = VodListDomainResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateCdnRefreshTaskResponse createCdnRefreshTask(VodCreateCdnRefreshTaskRequest input) throws Exception {
        RawResponse response = this.query("CreateCDNRefreshTask", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateCdnRefreshTaskResponse.Builder responseBuilder = VodCreateCdnRefreshTaskResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateCdnPreloadTaskResponse createCdnPreloadTask(VodCreateCdnPreloadTaskRequest input) throws Exception {
        RawResponse response = this.query("CreateCDNPreloadTask", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateCdnPreloadTaskResponse.Builder responseBuilder = VodCreateCdnPreloadTaskResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListCdnTasksResponse listCdnTasks(VodListCdnTasksRequest input) throws Exception {
        RawResponse response = this.query("ListCdnTasks", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListCdnTasksResponse.Builder responseBuilder = VodListCdnTasksResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListCdnAccessLogResponse listCdnAccessLog(VodListCdnAccessLogRequest input) throws Exception {
        RawResponse response = this.query("ListCdnAccessLog", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListCdnAccessLogResponse.Builder responseBuilder = VodListCdnAccessLogResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListCdnTopAccessUrlResponse listCdnTopAccessUrl(VodListCdnTopAccessUrlRequest input) throws Exception {
        RawResponse response = this.query("ListCdnTopAccessUrl", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListCdnTopAccessUrlResponse.Builder responseBuilder = VodListCdnTopAccessUrlResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDescribeVodDomainBandwidthDataResponse describeVodDomainBandwidthData(VodDescribeVodDomainBandwidthDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodDomainBandwidthData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDescribeVodDomainBandwidthDataResponse.Builder responseBuilder = VodDescribeVodDomainBandwidthDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCdnStatisticsCommonResponse listCdnUsageData(VodListCdnUsageDataRequest input) throws Exception {
        RawResponse response = this.query("ListCdnUsageData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCdnStatisticsCommonResponse.Builder responseBuilder = VodCdnStatisticsCommonResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCdnStatisticsCommonResponse listCdnStatusData(VodListCdnStatusDataRequest input) throws Exception {
        RawResponse response = this.query("ListCdnStatusData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCdnStatisticsCommonResponse.Builder responseBuilder = VodCdnStatisticsCommonResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDescribeIPInfoResponse describeIpInfo(VodDescribeIPInfoRequest input) throws Exception {
        RawResponse response = this.query("DescribeIpInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDescribeIPInfoResponse.Builder responseBuilder = VodDescribeIPInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDescribeVodDomainTrafficDataResponse describeVodDomainTrafficData(VodDescribeVodDomainTrafficDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodDomainTrafficData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDescribeVodDomainTrafficDataResponse.Builder responseBuilder = VodDescribeVodDomainTrafficDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCdnStatisticsCommonResponse listCdnPvData(VodListCdnPvDataRequest input) throws Exception {
        RawResponse response = this.query("ListCdnPvData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCdnStatisticsCommonResponse.Builder responseBuilder = VodCdnStatisticsCommonResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodAddCallbackSubscriptionResponse addCallbackSubscription(VodAddCallbackSubscriptionRequest input) throws Exception {
        RawResponse response = this.query("AddCallbackSubscription", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodAddCallbackSubscriptionResponse.Builder responseBuilder = VodAddCallbackSubscriptionResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodSetCallbackEventResponse setCallbackEvent(VodSetCallbackEventRequest input) throws Exception {
        RawResponse response = this.query("SetCallbackEvent", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodSetCallbackEventResponse.Builder responseBuilder = VodSetCallbackEventResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetSmartStrategyLitePlayInfoResponse getSmartStrategyLitePlayInfo(VodGetSmartStrategyLitePlayInfoRequest input) throws Exception {
        RawResponse response = this.query("GetSmartStrategyLitePlayInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetSmartStrategyLitePlayInfoResponse.Builder responseBuilder = VodGetSmartStrategyLitePlayInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetAppInfoResponse getAppInfo(VodGetAppInfoRequest input) throws Exception {
        RawResponse response = this.query("GetAppInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetAppInfoResponse.Builder responseBuilder = VodGetAppInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    static class Result {
        @JSONField(name="Result")
        public Integer result;

        Result() {
        }
    }

    static class VodGetDirectEditProgressResponse {
        @JSONField(name="ResponseMetadata")
        public Map<String, Object> responseMetadata;
        @JSONField(name="Result")
        public Object result;

        VodGetDirectEditProgressResponse() {
        }
    }

    static class VodGetDirectEditResultResponse {
        @JSONField(name="ResponseMetadata")
        public Map<String, Object> responseMetadata;
        @JSONField(name="Result")
        public List<Map<String, Object>> result;

        VodGetDirectEditResultResponse() {
        }
    }
}

