/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.tls;

import com.volcengine.model.tls.producer.BatchLog;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BatchHandler
extends Thread {
    private final Semaphore memoryLock;
    private final BlockingQueue<BatchLog> batchQueue;
    private final AtomicInteger batchCount;
    private volatile boolean closed;
    private final String name;
    private static final Log LOG = LogFactory.getLog(BatchHandler.class);

    public BatchHandler(String name, Semaphore memoryLock, BlockingQueue<BatchLog> batchQueue, AtomicInteger batchCount) {
        super(name);
        this.setDaemon(true);
        this.memoryLock = memoryLock;
        this.batchQueue = batchQueue;
        this.batchCount = batchCount;
        this.name = name;
        this.closed = false;
    }

    @Override
    public void run() {
        this.handleBatches();
    }

    private void handleBatches() {
        while (!this.closed) {
            try {
                BatchLog batch = this.batchQueue.take();
                this.handle(batch);
            }
            catch (InterruptedException e) {
                LOG.info((Object)("batch handler " + this.name + " has been interrupted"));
            }
        }
    }

    private void handle(BatchLog batch) {
        batch.fireCallbacks();
        this.batchCount.decrementAndGet();
        this.memoryLock.release(batch.getCurrentBatchSize());
    }

    public void close() {
        this.closed = true;
        this.interrupt();
    }
}

