/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.tls;

import com.volcengine.model.tls.exception.LogException;
import com.volcengine.model.tls.producer.Attempt;
import com.volcengine.model.tls.producer.BatchLog;
import com.volcengine.model.tls.producer.ProducerConfig;
import com.volcengine.model.tls.request.PutLogsRequest;
import com.volcengine.model.tls.request.RequestBuilder;
import com.volcengine.model.tls.response.PutLogsResponse;
import com.volcengine.service.tls.RetryManager;
import com.volcengine.service.tls.TLSLogClient;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendBatchTask
implements Runnable {
    private static final Log LOG = LogFactory.getLog(SendBatchTask.class);
    private final ProducerConfig producerConfig;
    private final BlockingQueue<BatchLog> successQueue;
    private final BlockingQueue<BatchLog> failureQueue;
    private final TLSLogClient client;
    private final RetryManager retryManager;
    private final BatchLog batchLog;

    public SendBatchTask(BatchLog batchLog, ProducerConfig producerConfig, BlockingQueue<BatchLog> successQueue, BlockingQueue<BatchLog> failureQueue, TLSLogClient client, RetryManager retryManager) {
        this.producerConfig = producerConfig;
        this.successQueue = successQueue;
        this.failureQueue = failureQueue;
        this.client = client;
        this.retryManager = retryManager;
        this.batchLog = batchLog;
    }

    @Override
    public void run() {
        this.sendRequest();
    }

    private void sendRequest() {
        PutLogsResponse putLogsResponse;
        PutLogsRequest putLogsRequest = RequestBuilder.buildFromBatch(this.batchLog);
        try {
            putLogsResponse = this.client.putLogs(putLogsRequest);
        }
        catch (LogException e) {
            LOG.error((Object)("send batch failed,batch:" + this.batchLog), (Throwable)e);
            Attempt fail = new Attempt(false, e.getRequestId(), e.getErrorCode(), e.getErrorMessage());
            this.batchLog.addAttempt(fail);
            this.retryManager.put(this.batchLog);
            LOG.info((Object)("retry queue add batch success,batch:" + this.batchLog));
            if (ProducerConfig.needRetry(e.getHttpCode()) && this.batchLog.getAttemptCount() < this.producerConfig.getRetryCount()) {
                try {
                    this.failureQueue.put(this.batchLog);
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)("failure queue add batch failed,batch:" + this.batchLog), (Throwable)e);
                }
            }
            return;
        }
        Attempt success = new Attempt(true, putLogsResponse.getRequestId(), null, null);
        this.successQueue.add(this.batchLog);
        this.batchLog.addAttempt(success);
        LOG.info((Object)("send batch success,batch:" + this.batchLog));
    }
}

