
// Code generated by protoc-gen-volcengine-sdk
// source: vod/service/service_vod.proto
// DO NOT EDIT!

package com.volcengine.service.vod.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.protobuf.util.JsonFormat;
import com.google.common.base.Predicates;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import com.github.rholder.retry.*;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

import java.text.SimpleDateFormat;
import java.text.DateFormat;


public class VodServiceImpl extends com.volcengine.service.BaseServiceImpl implements com.volcengine.service.vod.IVodService {

    // 静态字段引用唯一实例:
    private static final VodServiceImpl CN_NORTH_1_SERVICE = new VodServiceImpl();

    // 通过静态方法返回实例:
    public static com.volcengine.service.vod.IVodService getInstance() {
        return CN_NORTH_1_SERVICE;
    }

    // private构造方法保证外部无法实例化:
    protected VodServiceImpl() {
        super(com.volcengine.service.vod.VodServiceConfig.ServiceInfoMap.get(com.volcengine.helper.Const.REGION_CN_NORTH_1), com.volcengine.service.vod.VodServiceConfig.apiInfoList);
    }

    public static com.volcengine.service.vod.IVodService getInstance(String region) throws Exception {
        com.volcengine.model.ServiceInfo serviceInfo = com.volcengine.service.vod.VodServiceConfig.ServiceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("Cant find the region, please check it carefully");
        }
        switch (region) {
            case com.volcengine.helper.Const.REGION_CN_NORTH_1:
                return CN_NORTH_1_SERVICE;
            default:
                throw new Exception("Cant find the region, please check it carefully");
        }
    }

    @Override
    public String getPrivateDrmAuthToken(com.volcengine.service.vod.model.request.VodGetPrivateDrmPlayAuthRequest input, Long expireSeconds) throws Exception {
        Map<String, String> params = com.volcengine.helper.Utils.protoBufferToMap(input, false);
        if (expireSeconds != null && expireSeconds > 0) {
            params.put("X-Expires", expireSeconds.toString());
        }
        return getSignUrl(com.volcengine.service.vod.Const.GetPrivateDrmPlayAuth, com.volcengine.helper.Utils.mapToPairList(params));
    }

    @Override
    public String createSha1HlsDrmAuthToken(Long expireSeconds) throws Exception {
        return createHlsDrmAuthToken(com.volcengine.service.vod.Const.DSAHmacSha1, expireSeconds);
    }

    public String createHlsDrmAuthToken(String dsa, Long expireSeconds) throws Exception {
        if (expireSeconds == null || expireSeconds <= 0) {
            throw new Exception("Invalid Expire");
        }
        String token = createAuth(dsa, expireSeconds);
        Map<String, String> params = new HashMap<>();
        params.put("DrmAuthToken", token);
        params.put("X-Expires", expireSeconds.toString());
        return getSignUrl(com.volcengine.service.vod.Const.GetHlsDecryptionKey, com.volcengine.helper.Utils.mapToPairList(params));
    }

    private String createAuth(String dsa, long expireSeconds) throws Exception {
        if (StringUtils.isBlank(getAccessKey())) {
            throw new Exception("Invalid Ak");
        }
        if (StringUtils.isBlank(getSecretKey())) {
            throw new Exception("Invalid Sk");
        }

        long deadline = System.currentTimeMillis() / 1000 + expireSeconds;
        TimeZone tz = TimeZone.getTimeZone("UTC");
        DateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(tz);
        String deadlineDate = df.format(new Date(deadline * 1000));
        String timestamp = String.valueOf(deadline);
        byte[] kDate = com.volcengine.helper.Utils.hmacSHA256(getSecretKey().getBytes(), deadlineDate);
        byte[] kRegion = com.volcengine.helper.Utils.hmacSHA256(kDate, getRegion());
        byte[] kService = com.volcengine.helper.Utils.hmacSHA256(kRegion, "vod");
        byte[] kCredentials = com.volcengine.helper.Utils.hmacSHA256(kService, "request");
        String key = Hex.encodeHexString(kCredentials);
        String signDataString = StringUtils.join(dsa, "&", "2.0", "&", timestamp);
        String sign = "";
        switch (dsa) {
            case com.volcengine.service.vod.Const.DSAHmacSha1:
                sign = org.apache.commons.codec.binary.Base64.encodeBase64String(com.volcengine.helper.Utils.hmacSHA1(key.getBytes(), signDataString));
                break;
            case com.volcengine.service.vod.Const.DSAHmacSha256:
                sign = org.apache.commons.codec.binary.Base64.encodeBase64String(com.volcengine.helper.Utils.hmacSHA256(key.getBytes(), signDataString));
                break;
            default:
                sign = org.apache.commons.codec.binary.Base64.encodeBase64String("".getBytes());
                break;
        }
        return StringUtils.join(dsa, ":", "2.0", ":", timestamp, ":", getAccessKey(), ":", sign);
    }

    @Override
    public String getSubtitleAuthToken(com.volcengine.service.vod.model.request.VodGetSubtitleInfoListRequest input, Long expireSeconds) throws Exception {
        if (input.getVid() == "") {
            throw new Exception("传入的Vid为空");
        }
        Map<String, String> params = new HashMap<>();
        params.put("Vid", input.getVid());
        params.put("Status", "Published");
        if (expireSeconds != null && expireSeconds > 0) {
            params.put("X-Expires", expireSeconds.toString());
        }
        String getSubtitleAuthToken = getSignUrl(com.volcengine.service.vod.Const.GetSubtitleInfoList, com.volcengine.helper.Utils.mapToPairList(params));
        Map<String, String> ret = new HashMap<>();
        ret.put("GetSubtitleAuthToken", getSubtitleAuthToken);
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public String getPlayAuthToken(com.volcengine.service.vod.model.request.VodGetPlayInfoRequest input, Long expireSeconds) throws Exception {
        Map<String, String> params = com.volcengine.helper.Utils.protoBufferToMap(input, false);
        if (expireSeconds != null && expireSeconds > 0) {
            params.put("X-Expires", expireSeconds.toString());
        }
        String getPlayInfoToken = getSignUrl(com.volcengine.service.vod.Const.GetPlayInfo, com.volcengine.helper.Utils.mapToPairList(params));
        Map<String, String> ret = new HashMap<>();
        ret.put("GetPlayInfoToken", getPlayInfoToken);
        ret.put("TokenVersion", "V2");
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public com.volcengine.model.sts2.SecurityToken2 getUploadSts2() throws Exception {
        return getUploadSts2WithExpire(com.volcengine.util.Time.Hour);
    }

    @Override
    public com.volcengine.model.sts2.SecurityToken2 getUploadSts2WithExpire(long expire) throws Exception {
        com.volcengine.model.sts2.Policy inlinePolicy = new com.volcengine.model.sts2.Policy();
        List<String> actions = new ArrayList<>();
        actions.add("vod:ApplyUploadInfo");
        actions.add("vod:CommitUploadInfo");

        List<String> resources = new ArrayList<>();
        com.volcengine.model.sts2.Statement statement = com.volcengine.util.Sts2Utils.newAllowStatement(actions, resources);
        inlinePolicy.addStatement(statement);
        return signSts2(inlinePolicy, expire);
    }

    @Override
    public com.volcengine.service.vod.model.response.VodCommitUploadInfoResponse uploadMedia(com.volcengine.service.vod.model.request.VodUploadMediaRequest vodUploadMediaRequest) throws Exception {
        com.volcengine.model.beans.UploadCompleteInfo uploadCompleteInfo = uploadToB(vodUploadMediaRequest.getSpaceName(), vodUploadMediaRequest.getFilePath(), "media", vodUploadMediaRequest.getFileName(), vodUploadMediaRequest.getFileExtension());
        com.volcengine.service.vod.model.request.VodCommitUploadInfoRequest vodCommitUploadInfoRequest = com.volcengine.service.vod.model.request.VodCommitUploadInfoRequest.newBuilder()
                .setSpaceName(vodUploadMediaRequest.getSpaceName())
                .setSessionKey(uploadCompleteInfo.getSessionKey())
                .setFunctions(vodUploadMediaRequest.getFunctions())
                .setCallbackArgs(vodUploadMediaRequest.getCallbackArgs())
                .build();

        return commitUploadInfo(vodCommitUploadInfoRequest);
    }

    private com.volcengine.model.beans.UploadCompleteInfo uploadToB(String spaceName, String filePath, String fileType, String fileName, String fileExtension) throws Exception {
        java.io.File file = new java.io.File(filePath);
        if (!(file.isFile() && file.exists())) {
            throw new Exception(com.volcengine.error.SdkError.getErrorDesc(com.volcengine.error.SdkError.ENOFILE));
        }

        com.volcengine.service.vod.model.request.VodApplyUploadInfoRequest vodApplyUploadInfoRequest = com.volcengine.service.vod.model.request.VodApplyUploadInfoRequest.newBuilder()
                .setSpaceName(spaceName)
                .setFileName(fileName)
                .setFileType(fileType)
                .setFileExtension(fileExtension)
                .build();

        com.volcengine.service.vod.model.response.VodApplyUploadInfoResponse vodApplyUploadInfoResponse = applyUploadInfo(vodApplyUploadInfoRequest);
        if (vodApplyUploadInfoResponse.getResponseMetadata().hasError()) {
            throw new Exception(vodApplyUploadInfoResponse.getResponseMetadata().getError().getMessage());
        }
        com.volcengine.service.vod.model.business.VodUploadAddress vodUploadAddress = vodApplyUploadInfoResponse.getResult().getData().getUploadAddress();
        if (!vodApplyUploadInfoResponse.hasResult() || vodUploadAddress.getStoreInfosCount() == 0) {
            throw new Exception("apply upload result is null");
        }

        String oid = vodUploadAddress.getStoreInfos(0).getStoreUri();
        String sessionKey = vodUploadAddress.getSessionKey();
        String auth = vodUploadAddress.getStoreInfos(0).getAuth();
        String host = vodUploadAddress.getUploadHosts(0);
        List<com.volcengine.service.vod.model.business.VodHeaderPair> uploadHeaderList = vodUploadAddress.getUploadHeaderList();

        Retryer retryer = RetryerBuilder.newBuilder()
                .retryIfException()
                .retryIfResult(Predicates.equalTo(false))
                .retryIfResult(Predicates.isNull())
                .withWaitStrategy(WaitStrategies.exponentialWait())
                .withStopStrategy(StopStrategies.stopAfterAttempt(3))
                .build();

        if (file.length() < com.volcengine.service.vod.Const.MinChunkSize) {
            directUpload(host, oid, auth, uploadHeaderList, file, retryer);
        } else {
            chunkUpload(host, oid, auth, uploadHeaderList, file, true, retryer);
        }

        com.volcengine.model.beans.UploadCompleteInfo uploadCompleteInfo = new com.volcengine.model.beans.UploadCompleteInfo(oid, sessionKey);
        return uploadCompleteInfo;
    }

    private void directUpload(String host, String oid, String auth, List<com.volcengine.service.vod.model.business.VodHeaderPair> uploadHeaderList, File file, Retryer retryer) throws Exception {
        String oidEncode = StringUtils.replace(oid, " ", "%20");
        String url = String.format("https://%s/%s", host, oidEncode);
        byte[] bytes = Files.readAllBytes(Paths.get(file.getPath()));
        long crc32 = com.volcengine.helper.Utils.crc32(bytes);
        String checkSum = String.format("%08x", crc32);
        Map<String, String> headers = new HashMap<>();
        headers.put("Authorization", auth);
        headers.put("Content-CRC32", checkSum);
        uploadHeaderList.forEach(vodHeaderPair -> headers.put(vodHeaderPair.getKey(), vodHeaderPair.getValue()));
        retryer.call(() -> putData(url, bytes, headers));
    }

    private void chunkUpload(String host, String oid, String auth, List<com.volcengine.service.vod.model.business.VodHeaderPair> uploadHeaderList, File file, boolean isLargeFile, Retryer retryer) throws Exception {
        String uploadID = initUploadPart(host, oid, auth, isLargeFile, uploadHeaderList, retryer);
        byte[] data = new byte[com.volcengine.service.vod.Const.MinChunkSize];
        List<String> parts = new ArrayList<>();
        long num = file.length() / com.volcengine.service.vod.Const.MinChunkSize;
        long lastNum = num - 1;
        long partNumber;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file))) {
            for (long i = 0; i < lastNum; i++) {
                bis.read(data);
                partNumber = isLargeFile ? i + 1 : i;
                parts.add(uploadPart(host, oid, auth, uploadID, partNumber, data, isLargeFile, retryer));
            }
            long readCount = (long) com.volcengine.service.vod.Const.MinChunkSize * lastNum;
            int len = (int) (file.length() - readCount);
            byte[] lastPart = new byte[len];
            bis.read(lastPart);
            partNumber = isLargeFile ? lastNum + 1 : lastNum;
            parts.add(uploadPart(host, oid, auth, uploadID, partNumber, lastPart, isLargeFile, retryer));
        } catch (Exception e) {
            throw e;
        }
        uploadMergePart(host, oid, auth, uploadID, parts.stream().toArray(String[]::new), isLargeFile, retryer);
    }

    private String initUploadPart(String host, String oid, String auth, boolean isLargeFile, List<com.volcengine.service.vod.model.business.VodHeaderPair> uploadHeaderList, Retryer retryer) throws ExecutionException, RetryException, IOException {
        String oidEncode = StringUtils.replace(oid, " ", "%20");
        String url = String.format("http://%s/%s?uploads", host, oidEncode);
        Map<String, String> headers = new HashMap<>();
        headers.put("Authorization", auth);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        uploadHeaderList.forEach(vodHeaderPair -> headers.put(vodHeaderPair.getKey(), vodHeaderPair.getValue()));
        HttpResponse httpResponse = (HttpResponse) (retryer.call(() -> putDataWithResponse(url, new byte[]{}, headers)));
        if (httpResponse == null) {
            throw new RuntimeException("init part error,response is empty");
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("http code is " + httpResponse.getStatusLine().getStatusCode());
        }
        String entity = EntityUtils.toString(httpResponse.getEntity());
        JSONObject result = JSONObject.parseObject(entity);
        return result.getJSONObject("payload").getInnerMap().get("uploadID").toString();
    }

    private String uploadPart(String host, String oid, String auth, String uploadID, long partNumber, byte[] data, boolean isLargeFile, Retryer retryer) throws Exception {
        String oidEncode = StringUtils.replace(oid, " ", "%20");
        String url = String.format("http://%s/%s?partNumber=%d&uploadID=%s", host, oidEncode, partNumber, uploadID);
        Map<String, String> headers = new HashMap<>();
        headers.put("Authorization", auth);
        long crc32 = com.volcengine.helper.Utils.crc32(data);
        String checkSum = String.format("%08x", crc32);
        headers.put("Content-CRC32", checkSum);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        retryer.call(() -> putData(url, data, headers));
        return checkSum;
    }

    private void uploadMergePart(String host, String oid, String auth, String uploadID, String[] checkSum, boolean isLargeFile, Retryer retryer) throws ExecutionException, RetryException {
        String oidEncode = StringUtils.replace(oid, " ", "%20");
        String url = String.format("http://%s/%s?uploadID=%s", host, oidEncode, uploadID);
        String body = IntStream.range(0, checkSum.length).mapToObj(i -> String.format("%d:%s", i, checkSum[i])).collect(Collectors.joining(",", "", ""));
        Map<String, String> headers = new HashMap<>();
        headers.put("Authorization", auth);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        retryer.call(() -> putData(url, body.getBytes(), headers));
    }

    @Override
    public com.volcengine.service.vod.model.response.VodCommitUploadInfoResponse uploadMaterial(com.volcengine.service.vod.model.request.VodUploadMaterialRequest vodUploadMaterialRequest) throws Exception {
        com.volcengine.model.beans.UploadCompleteInfo uploadCompleteInfo = uploadToB(vodUploadMaterialRequest.getSpaceName(), vodUploadMaterialRequest.getFilePath(), vodUploadMaterialRequest.getFileType(), vodUploadMaterialRequest.getFileName(), vodUploadMaterialRequest.getFileExtension());

        com.volcengine.service.vod.model.request.VodCommitUploadInfoRequest vodCommitUploadInfoRequest = com.volcengine.service.vod.model.request.VodCommitUploadInfoRequest.newBuilder()
                .setSpaceName(vodUploadMaterialRequest.getSpaceName())
                .setSessionKey(uploadCompleteInfo.getSessionKey())
                .setFunctions(vodUploadMaterialRequest.getFunctions())
                .setCallbackArgs(vodUploadMaterialRequest.getCallbackArgs())
                .build();

        return commitUploadInfo(vodCommitUploadInfoRequest);
    }

    /**
     * submitDirectEditTaskAsync.
     *
     * @param input com.volcengine.service.vod.model.request.VodSubmitDirectEditTaskAsyncRequest
     * @return com.volcengine.service.vod.model.response.VodSubmitDirectEditTaskAsyncResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodSubmitDirectEditTaskAsyncResponse submitDirectEditTaskAsync(com.volcengine.service.vod.model.request.VodSubmitDirectEditTaskAsyncRequest input) throws Exception {
        String jsonData = JsonFormat.printer().print(input);
        Map<String, Object> inputMap = JSON.parseObject(jsonData);
        if (inputMap.containsKey("EditParam")) {
            Map<String, Object> editParam = JSON.parseObject(input.getEditParam().toString(StandardCharsets.UTF_8));
            inputMap.put("EditParam", editParam);
        }

        com.volcengine.model.response.RawResponse response = json(com.volcengine.service.vod.Const.SubmitDirectEditTaskAsync, new ArrayList<>(), JSON.toJSONString(inputMap));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodSubmitDirectEditTaskAsyncResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodSubmitDirectEditTaskAsyncResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getDirectEditResult.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetDirectEditResultRequest
     * @return com.volcengine.service.vod.model.response.VodGetDirectEditResultResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetDirectEditResultResponse getDirectEditResult(com.volcengine.service.vod.model.request.VodGetDirectEditResultRequest input) throws Exception {
        String jsonData = JsonFormat.printer().print(input);
        com.volcengine.model.response.RawResponse response = json(com.volcengine.service.vod.Const.GetDirectEditResult, new ArrayList<>(), jsonData);
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodServiceImpl.VodGetDirectEditResultResponse resp = JSON.parseObject(response.getData(), VodServiceImpl.VodGetDirectEditResultResponse.class);
        if (resp.result != null) {
            for (int i = 0; i < resp.result.size(); i++) {
                Map<String, Object> value = resp.result.get(i);
                if (value.containsKey("EditParam")) {
                    Object editParam = value.get("EditParam");
                    byte[] editParamBytes = JSON.toJSONBytes(editParam);
                    value.put("EditParam", editParamBytes);
                    resp.result.set(i, value);
                }
            }
        }
        com.volcengine.service.vod.model.response.VodGetDirectEditResultResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetDirectEditResultResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(JSON.toJSONBytes(resp))), responseBuilder);
        return responseBuilder.build();
    }

    static class VodGetDirectEditResultResponse {
        @JSONField(name = "ResponseMetadata")
        public Map<String, Object> responseMetadata;
        @JSONField(name = "Result")
        public java.util.List<Map<String, Object>> result;
    }

    /**
     * getDirectEditProgress.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetDirectEditProgressRequest
     * @return com.volcengine.service.vod.model.response.VodGetDirectEditProgressResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetDirectEditProgressResponse getDirectEditProgress(com.volcengine.service.vod.model.request.VodGetDirectEditProgressRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetDirectEditProgress, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodServiceImpl.VodGetDirectEditProgressResponse resp = JSON.parseObject(response.getData(), VodServiceImpl.VodGetDirectEditProgressResponse.class);
        if (resp.result != null) {
            Result res = new Result();
            res.result = (Integer) resp.result;
            resp.result = res;
        }
        com.volcengine.service.vod.model.response.VodGetDirectEditProgressResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetDirectEditProgressResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(JSON.toJSONBytes(resp))), responseBuilder);
        return responseBuilder.build();
    }

    static class VodGetDirectEditProgressResponse {
        @JSONField(name = "ResponseMetadata")
        public Map<String, Object> responseMetadata;
        @JSONField(name = "Result")
        public Object result;
    }

    static class Result {
        @JSONField(name = "Result")
        public Integer result;
    }


    /**
     * getAllPlayInfo.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetAllPlayInfoRequest
     * @return com.volcengine.service.vod.model.response.VodGetAllPlayInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetAllPlayInfoResponse getAllPlayInfo(com.volcengine.service.vod.model.request.VodGetAllPlayInfoRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetAllPlayInfo, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetAllPlayInfoResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetAllPlayInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getPlayInfo.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetPlayInfoRequest
     * @return com.volcengine.service.vod.model.response.VodGetPlayInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetPlayInfoResponse getPlayInfo(com.volcengine.service.vod.model.request.VodGetPlayInfoRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetPlayInfo, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetPlayInfoResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetPlayInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getPrivateDrmPlayAuth.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetPrivateDrmPlayAuthRequest
     * @return com.volcengine.service.vod.model.response.VodGetPrivateDrmPlayAuthResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetPrivateDrmPlayAuthResponse getPrivateDrmPlayAuth(com.volcengine.service.vod.model.request.VodGetPrivateDrmPlayAuthRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetPrivateDrmPlayAuth, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetPrivateDrmPlayAuthResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetPrivateDrmPlayAuthResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getHlsDecryptionKey.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetHlsDecryptionKeyRequest
     * @return com.volcengine.service.vod.model.response.VodGetHlsDecryptionKeyResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetHlsDecryptionKeyResponse getHlsDecryptionKey(com.volcengine.service.vod.model.request.VodGetHlsDecryptionKeyRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetHlsDecryptionKey, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetHlsDecryptionKeyResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetHlsDecryptionKeyResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getPlayInfoWithLiveTimeShiftScene.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetPlayInfoWithLiveTimeShiftSceneRequest
     * @return com.volcengine.service.vod.model.response.VodGetPlayInfoWithLiveTimeShiftSceneResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetPlayInfoWithLiveTimeShiftSceneResponse getPlayInfoWithLiveTimeShiftScene(com.volcengine.service.vod.model.request.VodGetPlayInfoWithLiveTimeShiftSceneRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetPlayInfoWithLiveTimeShiftScene, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetPlayInfoWithLiveTimeShiftSceneResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetPlayInfoWithLiveTimeShiftSceneResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * uploadMediaByUrl.
     *
     * @param input com.volcengine.service.vod.model.request.VodUrlUploadRequest
     * @return com.volcengine.service.vod.model.response.VodUrlUploadResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodUrlUploadResponse uploadMediaByUrl(com.volcengine.service.vod.model.request.VodUrlUploadRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.UploadMediaByUrl, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodUrlUploadResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodUrlUploadResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * queryUploadTaskInfo.
     *
     * @param input com.volcengine.service.vod.model.request.VodQueryUploadTaskInfoRequest
     * @return com.volcengine.service.vod.model.response.VodQueryUploadTaskInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodQueryUploadTaskInfoResponse queryUploadTaskInfo(com.volcengine.service.vod.model.request.VodQueryUploadTaskInfoRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.QueryUploadTaskInfo, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodQueryUploadTaskInfoResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodQueryUploadTaskInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * applyUploadInfo.
     *
     * @param input com.volcengine.service.vod.model.request.VodApplyUploadInfoRequest
     * @return com.volcengine.service.vod.model.response.VodApplyUploadInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodApplyUploadInfoResponse applyUploadInfo(com.volcengine.service.vod.model.request.VodApplyUploadInfoRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.ApplyUploadInfo, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodApplyUploadInfoResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodApplyUploadInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * commitUploadInfo.
     *
     * @param input com.volcengine.service.vod.model.request.VodCommitUploadInfoRequest
     * @return com.volcengine.service.vod.model.response.VodCommitUploadInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodCommitUploadInfoResponse commitUploadInfo(com.volcengine.service.vod.model.request.VodCommitUploadInfoRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.CommitUploadInfo, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodCommitUploadInfoResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodCommitUploadInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateMediaInfo.
     *
     * @param input com.volcengine.service.vod.model.request.VodUpdateMediaInfoRequest
     * @return com.volcengine.service.vod.model.response.VodUpdateMediaInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodUpdateMediaInfoResponse updateMediaInfo(com.volcengine.service.vod.model.request.VodUpdateMediaInfoRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.UpdateMediaInfo, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodUpdateMediaInfoResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodUpdateMediaInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateMediaPublishStatus.
     *
     * @param input com.volcengine.service.vod.model.request.VodUpdateMediaPublishStatusRequest
     * @return com.volcengine.service.vod.model.response.VodUpdateMediaPublishStatusResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodUpdateMediaPublishStatusResponse updateMediaPublishStatus(com.volcengine.service.vod.model.request.VodUpdateMediaPublishStatusRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.UpdateMediaPublishStatus, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodUpdateMediaPublishStatusResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodUpdateMediaPublishStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateMediaStorageClass.
     *
     * @param input com.volcengine.service.vod.model.request.VodUpdateMediaStorageClassRequest
     * @return com.volcengine.service.vod.model.response.VodUpdateMediaStorageClassResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodUpdateMediaStorageClassResponse updateMediaStorageClass(com.volcengine.service.vod.model.request.VodUpdateMediaStorageClassRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.UpdateMediaStorageClass, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodUpdateMediaStorageClassResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodUpdateMediaStorageClassResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getMediaInfos.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetMediaInfosRequest
     * @return com.volcengine.service.vod.model.response.VodGetMediaInfosResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetMediaInfosResponse getMediaInfos(com.volcengine.service.vod.model.request.VodGetMediaInfosRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetMediaInfos, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetMediaInfosResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetMediaInfosResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getRecommendedPoster.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetRecommendedPosterRequest
     * @return com.volcengine.service.vod.model.response.VodGetRecommendedPosterResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetRecommendedPosterResponse getRecommendedPoster(com.volcengine.service.vod.model.request.VodGetRecommendedPosterRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetRecommendedPoster, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetRecommendedPosterResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetRecommendedPosterResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * deleteMedia.
     *
     * @param input com.volcengine.service.vod.model.request.VodDeleteMediaRequest
     * @return com.volcengine.service.vod.model.response.VodDeleteMediaResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodDeleteMediaResponse deleteMedia(com.volcengine.service.vod.model.request.VodDeleteMediaRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.DeleteMedia, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodDeleteMediaResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodDeleteMediaResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * deleteTranscodes.
     *
     * @param input com.volcengine.service.vod.model.request.VodDeleteTranscodesRequest
     * @return com.volcengine.service.vod.model.response.VodDeleteTranscodesResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodDeleteTranscodesResponse deleteTranscodes(com.volcengine.service.vod.model.request.VodDeleteTranscodesRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.DeleteTranscodes, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodDeleteTranscodesResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodDeleteTranscodesResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getMediaList.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetMediaListRequest
     * @return com.volcengine.service.vod.model.response.VodGetMediaListResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetMediaListResponse getMediaList(com.volcengine.service.vod.model.request.VodGetMediaListRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetMediaList, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetMediaListResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetMediaListResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getSubtitleInfoList.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetSubtitleInfoListRequest
     * @return com.volcengine.service.vod.model.response.VodGetSubtitleInfoListResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetSubtitleInfoListResponse getSubtitleInfoList(com.volcengine.service.vod.model.request.VodGetSubtitleInfoListRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetSubtitleInfoList, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetSubtitleInfoListResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetSubtitleInfoListResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateSubtitleStatus.
     *
     * @param input com.volcengine.service.vod.model.request.VodUpdateSubtitleStatusRequest
     * @return com.volcengine.service.vod.model.response.VodUpdateSubtitleStatusResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodUpdateSubtitleStatusResponse updateSubtitleStatus(com.volcengine.service.vod.model.request.VodUpdateSubtitleStatusRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.UpdateSubtitleStatus, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodUpdateSubtitleStatusResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodUpdateSubtitleStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateSubtitleInfo.
     *
     * @param input com.volcengine.service.vod.model.request.VodUpdateSubtitleInfoRequest
     * @return com.volcengine.service.vod.model.response.VodUpdateSubtitleInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodUpdateSubtitleInfoResponse updateSubtitleInfo(com.volcengine.service.vod.model.request.VodUpdateSubtitleInfoRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.UpdateSubtitleInfo, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodUpdateSubtitleInfoResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodUpdateSubtitleInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getAuditFramesForAudit.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetAuditFramesForAuditRequest
     * @return com.volcengine.service.vod.model.response.VodGetAuditFramesForAuditResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetAuditFramesForAuditResponse getAuditFramesForAudit(com.volcengine.service.vod.model.request.VodGetAuditFramesForAuditRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetAuditFramesForAudit, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetAuditFramesForAuditResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetAuditFramesForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getMLFramesForAudit.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetMLFramesForAuditRequest
     * @return com.volcengine.service.vod.model.response.VodGetMLFramesForAuditResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetMLFramesForAuditResponse getMLFramesForAudit(com.volcengine.service.vod.model.request.VodGetMLFramesForAuditRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetMLFramesForAudit, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetMLFramesForAuditResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetMLFramesForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getBetterFramesForAudit.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetBetterFramesForAuditRequest
     * @return com.volcengine.service.vod.model.response.VodGetBetterFramesForAuditResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetBetterFramesForAuditResponse getBetterFramesForAudit(com.volcengine.service.vod.model.request.VodGetBetterFramesForAuditRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetBetterFramesForAudit, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetBetterFramesForAuditResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetBetterFramesForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getAudioInfoForAudit.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetAudioInfoForAuditRequest
     * @return com.volcengine.service.vod.model.response.VodGetAudioInfoForAuditResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetAudioInfoForAuditResponse getAudioInfoForAudit(com.volcengine.service.vod.model.request.VodGetAudioInfoForAuditRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetAudioInfoForAudit, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetAudioInfoForAuditResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetAudioInfoForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getAutomaticSpeechRecognitionForAudit.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetAutomaticSpeechRecognitionForAuditRequest
     * @return com.volcengine.service.vod.model.response.VodGetAutomaticSpeechRecognitionForAuditResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetAutomaticSpeechRecognitionForAuditResponse getAutomaticSpeechRecognitionForAudit(com.volcengine.service.vod.model.request.VodGetAutomaticSpeechRecognitionForAuditRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetAutomaticSpeechRecognitionForAudit, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetAutomaticSpeechRecognitionForAuditResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetAutomaticSpeechRecognitionForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getAudioEventDetectionForAudit.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetAudioEventDetectionForAuditRequest
     * @return com.volcengine.service.vod.model.response.VodGetAudioEventDetectionForAuditResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetAudioEventDetectionForAuditResponse getAudioEventDetectionForAudit(com.volcengine.service.vod.model.request.VodGetAudioEventDetectionForAuditRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetAudioEventDetectionForAudit, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetAudioEventDetectionForAuditResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetAudioEventDetectionForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * createVideoClassification.
     *
     * @param input com.volcengine.service.vod.model.request.VodCreateVideoClassificationRequest
     * @return com.volcengine.service.vod.model.response.VodCreateVideoClassificationResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodCreateVideoClassificationResponse createVideoClassification(com.volcengine.service.vod.model.request.VodCreateVideoClassificationRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.CreateVideoClassification, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodCreateVideoClassificationResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodCreateVideoClassificationResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateVideoClassification.
     *
     * @param input com.volcengine.service.vod.model.request.VodUpdateVideoClassificationRequest
     * @return com.volcengine.service.vod.model.response.VodUpdateVideoClassificationResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodUpdateVideoClassificationResponse updateVideoClassification(com.volcengine.service.vod.model.request.VodUpdateVideoClassificationRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.UpdateVideoClassification, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodUpdateVideoClassificationResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodUpdateVideoClassificationResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * deleteVideoClassification.
     *
     * @param input com.volcengine.service.vod.model.request.VodDeleteVideoClassificationRequest
     * @return com.volcengine.service.vod.model.response.VodDeleteVideoClassificationResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodDeleteVideoClassificationResponse deleteVideoClassification(com.volcengine.service.vod.model.request.VodDeleteVideoClassificationRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.DeleteVideoClassification, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodDeleteVideoClassificationResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodDeleteVideoClassificationResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listVideoClassifications.
     *
     * @param input com.volcengine.service.vod.model.request.VodListVideoClassificationsRequest
     * @return com.volcengine.service.vod.model.response.VodListVideoClassificationsResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodListVideoClassificationsResponse listVideoClassifications(com.volcengine.service.vod.model.request.VodListVideoClassificationsRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.ListVideoClassifications, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodListVideoClassificationsResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodListVideoClassificationsResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listSnapshots.
     *
     * @param input com.volcengine.service.vod.model.request.VodListSnapshotsRequest
     * @return com.volcengine.service.vod.model.response.VodListSnapshotsResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodListSnapshotsResponse listSnapshots(com.volcengine.service.vod.model.request.VodListSnapshotsRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.ListSnapshots, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodListSnapshotsResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodListSnapshotsResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * extractMediaMetaTask.
     *
     * @param input com.volcengine.service.vod.model.request.VodExtractMediaMetaTaskRequest
     * @return com.volcengine.service.vod.model.response.VodExtractMediaMetaTaskResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodExtractMediaMetaTaskResponse extractMediaMetaTask(com.volcengine.service.vod.model.request.VodExtractMediaMetaTaskRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.ExtractMediaMetaTask, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodExtractMediaMetaTaskResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodExtractMediaMetaTaskResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * startWorkflow.
     *
     * @param input com.volcengine.service.vod.model.request.VodStartWorkflowRequest
     * @return com.volcengine.service.vod.model.response.VodStartWorkflowResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodStartWorkflowResponse startWorkflow(com.volcengine.service.vod.model.request.VodStartWorkflowRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.StartWorkflow, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodStartWorkflowResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodStartWorkflowResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * retrieveTranscodeResult.
     *
     * @param input com.volcengine.service.vod.model.request.VodRetrieveTranscodeResultRequest
     * @return com.volcengine.service.vod.model.response.VodRetrieveTranscodeResultResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodRetrieveTranscodeResultResponse retrieveTranscodeResult(com.volcengine.service.vod.model.request.VodRetrieveTranscodeResultRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.RetrieveTranscodeResult, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodRetrieveTranscodeResultResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodRetrieveTranscodeResultResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * GetWorkflowExecution.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetWorkflowExecutionStatusRequest
     * @return com.volcengine.service.vod.model.response.VodGetWorkflowExecutionStatusResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetWorkflowExecutionStatusResponse GetWorkflowExecution(com.volcengine.service.vod.model.request.VodGetWorkflowExecutionStatusRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetWorkflowExecution, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetWorkflowExecutionStatusResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetWorkflowExecutionStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * createSpace.
     *
     * @param input com.volcengine.service.vod.model.request.VodCreateSpaceRequest
     * @return com.volcengine.service.vod.model.response.VodCreateSpaceResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodCreateSpaceResponse createSpace(com.volcengine.service.vod.model.request.VodCreateSpaceRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.CreateSpace, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodCreateSpaceResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodCreateSpaceResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listSpace.
     *
     * @param input com.volcengine.service.vod.model.request.VodListSpaceRequest
     * @return com.volcengine.service.vod.model.response.VodListSpaceResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodListSpaceResponse listSpace(com.volcengine.service.vod.model.request.VodListSpaceRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.ListSpace, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodListSpaceResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodListSpaceResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getSpaceDetail.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetSpaceDetailRequest
     * @return com.volcengine.service.vod.model.response.VodGetSpaceDetailResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetSpaceDetailResponse getSpaceDetail(com.volcengine.service.vod.model.request.VodGetSpaceDetailRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetSpaceDetail, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetSpaceDetailResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetSpaceDetailResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateSpace.
     *
     * @param input com.volcengine.service.vod.model.request.VodUpdateSpaceRequest
     * @return com.volcengine.service.vod.model.response.VodUpdateSpaceResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodUpdateSpaceResponse updateSpace(com.volcengine.service.vod.model.request.VodUpdateSpaceRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.UpdateSpace, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodUpdateSpaceResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodUpdateSpaceResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateSpaceUploadConfig.
     *
     * @param input com.volcengine.service.vod.model.request.VodUpdateSpaceUploadConfigRequest
     * @return com.volcengine.service.vod.model.response.VodUpdateSpaceUploadConfigResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodUpdateSpaceUploadConfigResponse updateSpaceUploadConfig(com.volcengine.service.vod.model.request.VodUpdateSpaceUploadConfigRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.UpdateSpaceUploadConfig, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodUpdateSpaceUploadConfigResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodUpdateSpaceUploadConfigResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * describeVodSpaceStorageData.
     *
     * @param input com.volcengine.service.vod.model.request.VodDescribeVodSpaceStorageDataRequest
     * @return com.volcengine.service.vod.model.response.VodDescribeVodSpaceStorageDataResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodDescribeVodSpaceStorageDataResponse describeVodSpaceStorageData(com.volcengine.service.vod.model.request.VodDescribeVodSpaceStorageDataRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.DescribeVodSpaceStorageData, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodDescribeVodSpaceStorageDataResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodDescribeVodSpaceStorageDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listDomain.
     *
     * @param input com.volcengine.service.vod.model.request.VodListDomainRequest
     * @return com.volcengine.service.vod.model.response.VodListDomainResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodListDomainResponse listDomain(com.volcengine.service.vod.model.request.VodListDomainRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.ListDomain, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodListDomainResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodListDomainResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * createCdnRefreshTask.
     *
     * @param input com.volcengine.service.vod.model.request.VodCreateCdnRefreshTaskRequest
     * @return com.volcengine.service.vod.model.response.VodCreateCdnRefreshTaskResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodCreateCdnRefreshTaskResponse createCdnRefreshTask(com.volcengine.service.vod.model.request.VodCreateCdnRefreshTaskRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.CreateCdnRefreshTask, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodCreateCdnRefreshTaskResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodCreateCdnRefreshTaskResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * createCdnPreloadTask.
     *
     * @param input com.volcengine.service.vod.model.request.VodCreateCdnPreloadTaskRequest
     * @return com.volcengine.service.vod.model.response.VodCreateCdnPreloadTaskResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodCreateCdnPreloadTaskResponse createCdnPreloadTask(com.volcengine.service.vod.model.request.VodCreateCdnPreloadTaskRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.CreateCdnPreloadTask, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodCreateCdnPreloadTaskResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodCreateCdnPreloadTaskResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listCdnTasks.
     *
     * @param input com.volcengine.service.vod.model.request.VodListCdnTasksRequest
     * @return com.volcengine.service.vod.model.response.VodListCdnTasksResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodListCdnTasksResponse listCdnTasks(com.volcengine.service.vod.model.request.VodListCdnTasksRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.ListCdnTasks, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodListCdnTasksResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodListCdnTasksResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listCdnAccessLog.
     *
     * @param input com.volcengine.service.vod.model.request.VodListCdnAccessLogRequest
     * @return com.volcengine.service.vod.model.response.VodListCdnAccessLogResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodListCdnAccessLogResponse listCdnAccessLog(com.volcengine.service.vod.model.request.VodListCdnAccessLogRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.ListCdnAccessLog, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodListCdnAccessLogResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodListCdnAccessLogResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listCdnTopAccessUrl.
     *
     * @param input com.volcengine.service.vod.model.request.VodListCdnTopAccessUrlRequest
     * @return com.volcengine.service.vod.model.response.VodListCdnTopAccessUrlResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodListCdnTopAccessUrlResponse listCdnTopAccessUrl(com.volcengine.service.vod.model.request.VodListCdnTopAccessUrlRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.ListCdnTopAccessUrl, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodListCdnTopAccessUrlResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodListCdnTopAccessUrlResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * describeVodDomainBandwidthData.
     *
     * @param input com.volcengine.service.vod.model.request.VodDescribeVodDomainBandwidthDataRequest
     * @return com.volcengine.service.vod.model.response.VodDescribeVodDomainBandwidthDataResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodDescribeVodDomainBandwidthDataResponse describeVodDomainBandwidthData(com.volcengine.service.vod.model.request.VodDescribeVodDomainBandwidthDataRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.DescribeVodDomainBandwidthData, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodDescribeVodDomainBandwidthDataResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodDescribeVodDomainBandwidthDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listCdnUsageData.
     *
     * @param input com.volcengine.service.vod.model.request.VodListCdnUsageDataRequest
     * @return com.volcengine.service.vod.model.response.VodCdnStatisticsCommonResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodCdnStatisticsCommonResponse listCdnUsageData(com.volcengine.service.vod.model.request.VodListCdnUsageDataRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.ListCdnUsageData, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodCdnStatisticsCommonResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodCdnStatisticsCommonResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listCdnStatusData.
     *
     * @param input com.volcengine.service.vod.model.request.VodListCdnStatusDataRequest
     * @return com.volcengine.service.vod.model.response.VodCdnStatisticsCommonResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodCdnStatisticsCommonResponse listCdnStatusData(com.volcengine.service.vod.model.request.VodListCdnStatusDataRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.ListCdnStatusData, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodCdnStatisticsCommonResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodCdnStatisticsCommonResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * describeIpInfo.
     *
     * @param input com.volcengine.service.vod.model.request.VodDescribeIPInfoRequest
     * @return com.volcengine.service.vod.model.response.VodDescribeIPInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodDescribeIPInfoResponse describeIpInfo(com.volcengine.service.vod.model.request.VodDescribeIPInfoRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.DescribeIpInfo, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodDescribeIPInfoResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodDescribeIPInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * describeVodDomainTrafficData.
     *
     * @param input com.volcengine.service.vod.model.request.VodDescribeVodDomainTrafficDataRequest
     * @return com.volcengine.service.vod.model.response.VodDescribeVodDomainTrafficDataResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodDescribeVodDomainTrafficDataResponse describeVodDomainTrafficData(com.volcengine.service.vod.model.request.VodDescribeVodDomainTrafficDataRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.DescribeVodDomainTrafficData, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodDescribeVodDomainTrafficDataResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodDescribeVodDomainTrafficDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listCdnPvData.
     *
     * @param input com.volcengine.service.vod.model.request.VodListCdnPvDataRequest
     * @return com.volcengine.service.vod.model.response.VodCdnStatisticsCommonResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodCdnStatisticsCommonResponse listCdnPvData(com.volcengine.service.vod.model.request.VodListCdnPvDataRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.ListCdnPvData, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodCdnStatisticsCommonResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodCdnStatisticsCommonResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * addCallbackSubscription.
     *
     * @param input com.volcengine.service.vod.model.request.VodAddCallbackSubscriptionRequest
     * @return com.volcengine.service.vod.model.response.VodAddCallbackSubscriptionResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodAddCallbackSubscriptionResponse addCallbackSubscription(com.volcengine.service.vod.model.request.VodAddCallbackSubscriptionRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.AddCallbackSubscription, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodAddCallbackSubscriptionResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodAddCallbackSubscriptionResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * setCallbackEvent.
     *
     * @param input com.volcengine.service.vod.model.request.VodSetCallbackEventRequest
     * @return com.volcengine.service.vod.model.response.VodSetCallbackEventResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodSetCallbackEventResponse setCallbackEvent(com.volcengine.service.vod.model.request.VodSetCallbackEventRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.SetCallbackEvent, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodSetCallbackEventResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodSetCallbackEventResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getSmartStrategyLitePlayInfo.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetSmartStrategyLitePlayInfoRequest
     * @return com.volcengine.service.vod.model.response.VodGetSmartStrategyLitePlayInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetSmartStrategyLitePlayInfoResponse getSmartStrategyLitePlayInfo(com.volcengine.service.vod.model.request.VodGetSmartStrategyLitePlayInfoRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetSmartStrategyLitePlayInfo, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetSmartStrategyLitePlayInfoResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetSmartStrategyLitePlayInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getAppInfo.
     *
     * @param input com.volcengine.service.vod.model.request.VodGetAppInfoRequest
     * @return com.volcengine.service.vod.model.response.VodGetAppInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.VodGetAppInfoResponse getAppInfo(com.volcengine.service.vod.model.request.VodGetAppInfoRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.GetAppInfo, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.VodGetAppInfoResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetAppInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * describeVodSpaceTranscodeData.
     *
     * @param input com.volcengine.service.vod.model.request.DescribeVodSpaceTranscodeDataRequest
     * @return com.volcengine.service.vod.model.response.DescribeVodSpaceTranscodeDataResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.DescribeVodSpaceTranscodeDataResponse describeVodSpaceTranscodeData(com.volcengine.service.vod.model.request.DescribeVodSpaceTranscodeDataRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.DescribeVodSpaceTranscodeData, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.DescribeVodSpaceTranscodeDataResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.DescribeVodSpaceTranscodeDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * describeVodSpaceAIStatisData.
     *
     * @param input com.volcengine.service.vod.model.request.DescribeVodSpaceAIStatisDataRequest
     * @return com.volcengine.service.vod.model.response.DescribeVodSpaceAIStatisDataResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.DescribeVodSpaceAIStatisDataResponse describeVodSpaceAIStatisData(com.volcengine.service.vod.model.request.DescribeVodSpaceAIStatisDataRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.DescribeVodSpaceAIStatisData, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.DescribeVodSpaceAIStatisDataResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.DescribeVodSpaceAIStatisDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * describeVodSpaceSubtitleStatisData.
     *
     * @param input com.volcengine.service.vod.model.request.DescribeVodSpaceSubtitleStatisDataRequest
     * @return com.volcengine.service.vod.model.response.DescribeVodSpaceSubtitleStatisDataResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.DescribeVodSpaceSubtitleStatisDataResponse describeVodSpaceSubtitleStatisData(com.volcengine.service.vod.model.request.DescribeVodSpaceSubtitleStatisDataRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.DescribeVodSpaceSubtitleStatisData, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.DescribeVodSpaceSubtitleStatisDataResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.DescribeVodSpaceSubtitleStatisDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * describeVodSpaceDetectStatisData.
     *
     * @param input com.volcengine.service.vod.model.request.DescribeVodSpaceDetectStatisDataRequest
     * @return com.volcengine.service.vod.model.response.DescribeVodSpaceDetectStatisDataResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.DescribeVodSpaceDetectStatisDataResponse describeVodSpaceDetectStatisData(com.volcengine.service.vod.model.request.DescribeVodSpaceDetectStatisDataRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.DescribeVodSpaceDetectStatisData, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.DescribeVodSpaceDetectStatisDataResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.DescribeVodSpaceDetectStatisDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * describeVodSnapshotData.
     *
     * @param input com.volcengine.service.vod.model.request.DescribeVodSnapshotDataRequest
     * @return com.volcengine.service.vod.model.response.DescribeVodSnapshotDataResponse
     * @throws Exception the exception
     */
    @Override
    public com.volcengine.service.vod.model.response.DescribeVodSnapshotDataResponse describeVodSnapshotData(com.volcengine.service.vod.model.request.DescribeVodSnapshotDataRequest input) throws Exception {
        com.volcengine.model.response.RawResponse response = query(com.volcengine.service.vod.Const.DescribeVodSnapshotData, com.volcengine.helper.Utils.mapToPairList(com.volcengine.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.volcengine.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.volcengine.service.vod.model.response.DescribeVodSnapshotDataResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.DescribeVodSnapshotDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


}  // end of service interface
