/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.auth.impl;

import com.volcengine.auth.ISignerV4;
import com.volcengine.auth.MetaData;
import com.volcengine.helper.Utils;
import com.volcengine.model.Credentials;
import com.volcengine.model.RequestParam;
import com.volcengine.model.SignRequest;
import com.volcengine.service.SignableRequest;
import com.volcengine.util.NameValueComparator;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class SignerV4Impl
implements ISignerV4 {
    private static final TimeZone tz;
    private static final Set<String> H_INCLUDE;
    private static final BitSet URLENCODER;
    private static final String CONST_ENCODE = "0123456789ABCDEF";

    @Override
    public void sign(SignableRequest request, Credentials credentials) throws Exception {
        URIBuilder builder = request.getUriBuilder();
        if (StringUtils.isEmpty((CharSequence)builder.getPath())) {
            builder.setPath(builder.getPath() + "/");
        }
        if (request.getFirstHeader("Content-Type") == null) {
            request.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        }
        RequestParam requestParam = RequestParam.builder().isSignUrl(false).body(request.getEntity() == null ? new byte[]{} : EntityUtils.toByteArray((HttpEntity)request.getEntity())).host(request.getUriBuilder().getHost()).path(builder.getPath()).method(request.getMethod()).date(new Date()).queryList(request.getUriBuilder().getQueryParams()).headers(request.getAllHeaders()).build();
        SignRequest signRequest = this.getSignRequest(requestParam, credentials);
        request.setHeader("Host", signRequest.getHost());
        request.setHeader("Content-Type", signRequest.getContentType());
        request.setHeader("X-Date", signRequest.getXDate());
        request.setHeader("X-Content-Sha256", signRequest.getXContentSha256());
        request.setHeader("Authorization", signRequest.getAuthorization());
        if (StringUtils.isNotEmpty((CharSequence)signRequest.getXSecurityToken())) {
            request.setHeader("X-Security-Token", signRequest.getXSecurityToken());
        }
        request.setURI(request.getUriBuilder().build());
    }

    @Override
    public String signUrl(SignableRequest request, Credentials credentials) throws Exception {
        URIBuilder uriBuilder = request.getUriBuilder();
        RequestParam requestParam = RequestParam.builder().isSignUrl(true).body(request.getEntity() == null ? new byte[]{} : EntityUtils.toByteArray((HttpEntity)request.getEntity())).host(uriBuilder.getHost()).path(uriBuilder.getPath()).method(request.getMethod()).date(new Date()).queryList(request.getUriBuilder().getQueryParams()).build();
        SignRequest signRequest = this.getSignRequest(requestParam, credentials);
        uriBuilder.setParameter("X-Date", signRequest.getXDate());
        uriBuilder.setParameter("X-NotSignBody", signRequest.getXNotSignBody());
        uriBuilder.setParameter("X-Credential", signRequest.getXCredential());
        uriBuilder.setParameter("X-Algorithm", signRequest.getXAlgorithm());
        uriBuilder.setParameter("X-SignedHeaders", signRequest.getXSignedHeaders());
        uriBuilder.setParameter("X-SignedQueries", signRequest.getXSignedQueries());
        uriBuilder.setParameter("X-Signature", signRequest.getXSignature());
        if (StringUtils.isNotEmpty((CharSequence)signRequest.getXSecurityToken())) {
            uriBuilder.setParameter("X-Security-Token", signRequest.getXSecurityToken());
        }
        return uriBuilder.build().toURL().getQuery();
    }

    @Override
    public SignRequest getSignRequest(RequestParam requestParam, Credentials credentials) throws Exception {
        String bodyHash;
        if (requestParam == null || credentials == null) {
            throw new Exception("requestParam and credentials is null");
        }
        if (requestParam.getIsSignUrl() == null || requestParam.getDate() == null || requestParam.getQueryList() == null) {
            throw new Exception("requestParam's isSignUrl or date or queryList is null");
        }
        String formatDate = this.getAppointFormatDate(requestParam.getDate());
        MetaData meta = this.getMetaDate(credentials, this.toDate(formatDate));
        HashMap<String, String> requestSignMap = new HashMap<String, String>();
        SignRequest signRequest = SignRequest.builder().xDate(formatDate).xSecurityToken(credentials.getSessionToken()).build();
        if (StringUtils.isNotEmpty((CharSequence)credentials.getSessionToken())) {
            requestSignMap.put("X-Security-Token", credentials.getSessionToken());
        }
        if (requestParam.getIsSignUrl().booleanValue()) {
            requestParam.getQueryList().forEach(nv -> requestSignMap.put(nv.getName(), nv.getValue()));
            requestSignMap.put("X-Date", formatDate);
            requestSignMap.put("X-NotSignBody", "");
            requestSignMap.put("X-Credential", credentials.getAccessKeyID() + "/" + meta.getCredentialScope());
            requestSignMap.put("X-Algorithm", meta.getAlgorithm());
            requestSignMap.put("X-SignedHeaders", meta.getSignedHeaders());
            requestSignMap.put("X-SignedQueries", "");
            ArrayList arrayList = new ArrayList(requestSignMap.keySet());
            Collections.sort(arrayList);
            requestSignMap.put("X-SignedQueries", StringUtils.join(arrayList, (String)";"));
            signRequest.setXNotSignBody("");
            signRequest.setXCredential(credentials.getAccessKeyID() + "/" + meta.getCredentialScope());
            signRequest.setXAlgorithm(meta.getAlgorithm());
            signRequest.setXSignedHeaders(meta.getSignedHeaders());
            signRequest.setXSignedQueries(StringUtils.join(arrayList, (String)";"));
            bodyHash = Utils.hashSHA256(new byte[0]);
        } else {
            for (Header header : requestParam.getHeaders()) {
                requestSignMap.put(header.getName(), header.getValue());
            }
            if (requestSignMap.get("Content-Type") != null) {
                signRequest.setContentType((String)requestSignMap.get("Content-Type"));
            }
            requestSignMap.put("X-Date", formatDate);
            requestSignMap.put("Host", requestParam.getHost());
            bodyHash = Utils.hashSHA256(requestParam.getBody() == null ? new byte[]{} : requestParam.getBody());
            requestSignMap.put("X-Content-Sha256", bodyHash);
            signRequest.setHost(requestParam.getHost());
            signRequest.setXContentSha256(bodyHash);
        }
        String string = this.getSignatureStr(requestParam, meta, credentials.getSecretAccessKey(), formatDate, requestSignMap, bodyHash);
        if (requestParam.getIsSignUrl().booleanValue()) {
            signRequest.setXSignature(string);
        } else {
            signRequest.setAuthorization(this.buildAuthHeaderV4(string, meta, credentials));
        }
        return signRequest;
    }

    private String getSignatureStr(RequestParam requestParam, MetaData meta, String secreteAccessKey, String formatDate, Map<String, String> requestSignMap, String bodyHash) throws Exception {
        String hashedCanonReq = this.hashedCanonicalRequestV4(requestParam, meta, requestSignMap, bodyHash);
        String stringToSign = StringUtils.join((Object[])new String[]{meta.getAlgorithm(), formatDate, meta.getCredentialScope(), hashedCanonReq}, (String)"\n");
        byte[] signingKey = this.genSigningSecretKeyV4(secreteAccessKey, meta.getDate(), meta.getRegion(), meta.getService());
        return this.signatureV4(signingKey, stringToSign);
    }

    private MetaData getMetaDate(Credentials credentials, String date) {
        MetaData meta = new MetaData();
        meta.setDate(date);
        meta.setService(credentials.getService());
        meta.setRegion(credentials.getRegion());
        meta.setAlgorithm("HMAC-SHA256");
        meta.setSignedHeaders("");
        meta.setCredentialScope(StringUtils.join((Object[])new String[]{meta.getDate(), meta.getRegion(), meta.getService(), "request"}, (String)"/"));
        return meta;
    }

    private String hashedCanonicalRequestV4(RequestParam requestParam, MetaData meta, Map<String, String> requestSignMap, String bodyHash) throws Exception {
        String canonicalRequest;
        ArrayList<NameValuePair> queryList = new ArrayList<NameValuePair>();
        if (requestParam.getIsSignUrl().booleanValue()) {
            for (String key : requestSignMap.keySet()) {
                queryList.add((NameValuePair)new BasicNameValuePair(key, requestSignMap.get(key)));
            }
            canonicalRequest = StringUtils.join((Object[])new String[]{requestParam.getMethod(), this.normUri(requestParam.getPath()), this.normQuery(queryList), "\n", meta.getSignedHeaders(), bodyHash}, (String)"\n");
        } else {
            String canonicalHeaders = this.getCanonicalHeaders(requestParam, meta, requestSignMap);
            canonicalRequest = StringUtils.join((Object[])new String[]{requestParam.getMethod(), this.normUri(requestParam.getPath()), this.normQuery(requestParam.getQueryList()), canonicalHeaders, meta.getSignedHeaders(), bodyHash}, (String)"\n");
        }
        return Utils.hashSHA256(canonicalRequest.getBytes());
    }

    private String getCanonicalHeaders(RequestParam requestParam, MetaData meta, Map<String, String> requestSignMap) {
        HashMap<String, String> signMap = new HashMap<String, String>();
        List<String> signedHeaders = this.sortHeaders(requestSignMap, signMap);
        if (!requestParam.getIsSignUrl().booleanValue()) {
            meta.setSignedHeaders(StringUtils.join(signedHeaders, (String)";"));
        }
        if (StringUtils.isEmpty((CharSequence)requestParam.getPath())) {
            requestParam.setPath("/");
        }
        StringBuilder signedHeadersToSignStr = new StringBuilder();
        for (String h : signedHeaders) {
            String[] split;
            String port;
            String value = ((String)signMap.get(h)).trim();
            if (h.equals("host") && value.contains(":") && ((port = (split = value.split(":"))[1]).equals("80") || port.equals("443"))) {
                value = split[0];
            }
            signedHeadersToSignStr.append(h).append(":").append(value).append("\n");
        }
        return signedHeadersToSignStr.toString();
    }

    private List<String> sortHeaders(Map<String, String> requestSignMap, Map<String, String> signMap) {
        ArrayList<String> signedHeaders = new ArrayList<String>();
        for (Map.Entry<String, String> entry : requestSignMap.entrySet()) {
            signMap.put(entry.getKey().toLowerCase(), entry.getValue());
            if (!H_INCLUDE.contains(entry.getKey()) && !entry.getKey().startsWith("X-")) continue;
            signedHeaders.add(entry.getKey().toLowerCase());
        }
        Collections.sort(signedHeaders);
        return signedHeaders;
    }

    private String signatureV4(byte[] signingKey, String stringToSign) throws Exception {
        return Hex.encodeHexString((byte[])Utils.hmacSHA256(signingKey, stringToSign));
    }

    private byte[] genSigningSecretKeyV4(String secretKey, String date, String region, String service) throws Exception {
        byte[] kDate = Utils.hmacSHA256(secretKey.getBytes(), date);
        byte[] kRegion = Utils.hmacSHA256(kDate, region);
        byte[] kService = Utils.hmacSHA256(kRegion, service);
        return Utils.hmacSHA256(kService, "request");
    }

    private String buildAuthHeaderV4(String signature, MetaData meta, Credentials credentials) {
        String credential = credentials.getAccessKeyID() + "/" + meta.getCredentialScope();
        return meta.getAlgorithm() + " Credential=" + credential + ", SignedHeaders=" + meta.getSignedHeaders() + ", Signature=" + signature;
    }

    private String getCurrentFormatDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(tz);
        return df.format(new Date());
    }

    private String getAppointFormatDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(tz);
        return df.format(date);
    }

    private String toDate(String timestamp) {
        return timestamp.substring(0, 8);
    }

    private String normUri(String path) {
        Object[] parts = path.split("/", -1);
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = this.signStringEncoder((String)parts[i]);
        }
        return StringUtils.join((Object[])parts, (String)"/");
    }

    private String normQuery(List<NameValuePair> params) {
        params.sort(NameValueComparator.INSTANCE);
        return this.signQueryEncoder(params);
    }

    private String signQueryEncoder(List<NameValuePair> params) {
        StringBuilder result = new StringBuilder();
        for (NameValuePair pair : params) {
            String encodedName = this.signStringEncoder(pair.getName());
            String encodedValue = this.signStringEncoder(pair.getValue());
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName).append("=");
            if (encodedValue == null) continue;
            result.append(encodedValue);
        }
        return result.toString();
    }

    private String signStringEncoder(String source) {
        if (source == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(source.length());
        ByteBuffer bb = Consts.UTF_8.encode(source);
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (URLENCODER.get(b)) {
                buf.append((char)b);
                continue;
            }
            if (b == 32) {
                buf.append("%20");
                continue;
            }
            buf.append("%");
            char hex1 = CONST_ENCODE.charAt(b >> 4);
            char hex2 = CONST_ENCODE.charAt(b & 0xF);
            buf.append(hex1);
            buf.append(hex2);
        }
        return buf.toString();
    }

    static {
        int i;
        tz = TimeZone.getTimeZone("UTC");
        H_INCLUDE = new HashSet<String>();
        URLENCODER = new BitSet(256);
        H_INCLUDE.add("Content-Type");
        H_INCLUDE.add("Content-Md5");
        H_INCLUDE.add("Host");
        for (i = 97; i <= 122; ++i) {
            URLENCODER.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            URLENCODER.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URLENCODER.set(i);
        }
        URLENCODER.set(45);
        URLENCODER.set(95);
        URLENCODER.set(46);
        URLENCODER.set(126);
    }
}

