/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.model.tls.util;

import com.google.common.math.LongMath;

public class TimeUtil {
    public static final int BASE_RETRY_MS = 100;
    public static final int MAX_RETRY_MS = 50000;

    private TimeUtil() {
    }

    public static long calBackOffMs(long baseBackOff, long maxBackOff, int retry) {
        long retryBackoffMs = baseBackOff * LongMath.pow((long)2L, (int)retry);
        if (retryBackoffMs <= 0L) {
            retryBackoffMs = maxBackOff;
        }
        return Math.min(retryBackoffMs, maxBackOff);
    }

    public static long calDefaultBackOffMs(int retry) {
        return TimeUtil.calBackOffMs(100L, 50000L, retry);
    }
}

