/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.businessSecurity.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.request.AsyncRiskDetectionRequest;
import com.volcengine.model.request.DataReportRequest;
import com.volcengine.model.request.RiskDetectionRequest;
import com.volcengine.model.request.RiskResultRequest;
import com.volcengine.model.response.AsyncRiskDetectionResponse;
import com.volcengine.model.response.DataReportResponse;
import com.volcengine.model.response.ElementVerifyResponse;
import com.volcengine.model.response.ElementVerifyResponseV2;
import com.volcengine.model.response.MobileStatusResponse;
import com.volcengine.model.response.MobileStatusResponseV2;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.RiskDetectionResponse;
import com.volcengine.model.response.RiskResultResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.businessSecurity.BusinessSecurityConfig;
import com.volcengine.service.businessSecurity.BusinessSecurityService;
import com.volcengine.util.AesUtil;
import java.util.ArrayList;
import org.apache.http.NameValuePair;

public class BusinessSecurityServiceImpl
extends BaseServiceImpl
implements BusinessSecurityService {
    private static final BusinessSecurityServiceImpl businessSecurityInstance = new BusinessSecurityServiceImpl();

    private BusinessSecurityServiceImpl() {
        super(BusinessSecurityConfig.serviceInfo, BusinessSecurityConfig.apiInfoList);
    }

    public static BusinessSecurityService getInstance() {
        return businessSecurityInstance;
    }

    @Override
    public RiskDetectionResponse RiskDetection(RiskDetectionRequest riskDetectionRequest) throws Exception {
        RawResponse response = this.json("RiskDetection", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RiskDetectionResponse)JSON.parseObject((byte[])response.getData(), RiskDetectionResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public AsyncRiskDetectionResponse AsyncRiskDetection(AsyncRiskDetectionRequest asyncRiskDetectionRequest) throws Exception {
        RawResponse response = this.json("AsyncRiskDetection", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)asyncRiskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (AsyncRiskDetectionResponse)JSON.parseObject((byte[])response.getData(), AsyncRiskDetectionResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RiskResultResponse RiskResult(RiskResultRequest riskResultRequest) throws Exception {
        RawResponse response = this.query("RiskResult", Utils.mapToPairList(Utils.paramsToMap(riskResultRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RiskResultResponse)JSON.parseObject((byte[])response.getData(), RiskResultResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DataReportResponse DataReport(DataReportRequest dataReportRequest) throws Exception {
        RawResponse response = this.json("DataReport", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)dataReportRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DataReportResponse)JSON.parseObject((byte[])response.getData(), DataReportResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RiskDetectionResponse AccountRisk(RiskDetectionRequest riskDetectionRequest) throws Exception {
        RawResponse response = this.json("AccountRisk", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RiskDetectionResponse)JSON.parseObject((byte[])response.getData(), RiskDetectionResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public MobileStatusResponse MobileStatus(RiskDetectionRequest riskDetectionRequest) throws Exception {
        RawResponse response = this.json("MobileStatus", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (MobileStatusResponse)JSON.parseObject((byte[])response.getData(), MobileStatusResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public MobileStatusResponseV2 MobileStatusV2(RiskDetectionRequest riskDetectionRequest) throws Exception {
        RawResponse response = this.json("MobileStatusV2", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (MobileStatusResponseV2)JSON.parseObject((byte[])response.getData(), MobileStatusResponseV2.class, (Feature[])new Feature[0]);
    }

    @Override
    public ElementVerifyResponse ElementVerify(RiskDetectionRequest riskDetectionRequest) throws Exception {
        RawResponse response = this.json("ElementVerify", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ElementVerifyResponse)JSON.parseObject((byte[])response.getData(), ElementVerifyResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ElementVerifyResponseV2 ElementVerifyV2(RiskDetectionRequest riskDetectionRequest) throws Exception {
        RawResponse response = this.json("ElementVerifyV2", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ElementVerifyResponseV2)JSON.parseObject((byte[])response.getData(), ElementVerifyResponseV2.class, (Feature[])new Feature[0]);
    }

    @Override
    public ElementVerifyResponseV2 ElementVerifyEncrypted(String key, String encryptedType, RiskDetectionRequest riskDetectionRequest) throws Exception {
        String parameters = AesUtil.aesCBCEncryptWithBase64(riskDetectionRequest.getParameters(), key);
        riskDetectionRequest.setParameters(parameters);
        riskDetectionRequest.setEncryptedType(encryptedType);
        RawResponse response = this.json("ElementVerifyEncrypted", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ElementVerifyResponseV2)JSON.parseObject((byte[])response.getData(), ElementVerifyResponseV2.class, (Feature[])new Feature[0]);
    }
}

