/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.tls;

import com.alibaba.fastjson.JSONObject;
import com.volcengine.error.SdkError;
import com.volcengine.model.ApiInfo;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.tls.ClientConfig;
import com.volcengine.model.tls.DescribeRulesRequest;
import com.volcengine.model.tls.exception.LogException;
import com.volcengine.model.tls.request.ApplyRuleToHostGroupsRequest;
import com.volcengine.model.tls.request.CloseKafkaConsumerRequest;
import com.volcengine.model.tls.request.ConsumeLogsRequest;
import com.volcengine.model.tls.request.CreateAlarmNotifyGroupRequest;
import com.volcengine.model.tls.request.CreateAlarmRequest;
import com.volcengine.model.tls.request.CreateDownloadTaskRequest;
import com.volcengine.model.tls.request.CreateHostGroupRequest;
import com.volcengine.model.tls.request.CreateIndexRequest;
import com.volcengine.model.tls.request.CreateProjectRequest;
import com.volcengine.model.tls.request.CreateRuleRequest;
import com.volcengine.model.tls.request.CreateTopicRequest;
import com.volcengine.model.tls.request.DeleteAlarmNotifyGroupRequest;
import com.volcengine.model.tls.request.DeleteAlarmRequest;
import com.volcengine.model.tls.request.DeleteHostGroupRequest;
import com.volcengine.model.tls.request.DeleteHostRequest;
import com.volcengine.model.tls.request.DeleteIndexRequest;
import com.volcengine.model.tls.request.DeleteProjectRequest;
import com.volcengine.model.tls.request.DeleteRuleFromHostGroupsRequest;
import com.volcengine.model.tls.request.DeleteRuleRequest;
import com.volcengine.model.tls.request.DeleteTopicRequest;
import com.volcengine.model.tls.request.DescribeAlarmNotifyGroupsRequest;
import com.volcengine.model.tls.request.DescribeAlarmsRequest;
import com.volcengine.model.tls.request.DescribeCursorRequest;
import com.volcengine.model.tls.request.DescribeDownloadTasksRequest;
import com.volcengine.model.tls.request.DescribeDownloadUrlRequest;
import com.volcengine.model.tls.request.DescribeHistogramRequest;
import com.volcengine.model.tls.request.DescribeHostGroupRequest;
import com.volcengine.model.tls.request.DescribeHostGroupRulesRequest;
import com.volcengine.model.tls.request.DescribeHostGroupsRequest;
import com.volcengine.model.tls.request.DescribeHostsRequest;
import com.volcengine.model.tls.request.DescribeIndexRequest;
import com.volcengine.model.tls.request.DescribeKafkaConsumerRequest;
import com.volcengine.model.tls.request.DescribeLogContextRequest;
import com.volcengine.model.tls.request.DescribeProjectRequest;
import com.volcengine.model.tls.request.DescribeProjectsRequest;
import com.volcengine.model.tls.request.DescribeRuleRequest;
import com.volcengine.model.tls.request.DescribeShardsRequest;
import com.volcengine.model.tls.request.DescribeTopicRequest;
import com.volcengine.model.tls.request.DescribeTopicsRequest;
import com.volcengine.model.tls.request.ModifyAlarmNotifyGroupRequest;
import com.volcengine.model.tls.request.ModifyAlarmRequest;
import com.volcengine.model.tls.request.ModifyHostGroupRequest;
import com.volcengine.model.tls.request.ModifyHostGroupsAutoUpdateRequest;
import com.volcengine.model.tls.request.ModifyIndexRequest;
import com.volcengine.model.tls.request.ModifyProjectRequest;
import com.volcengine.model.tls.request.ModifyRuleRequest;
import com.volcengine.model.tls.request.ModifyTopicRequest;
import com.volcengine.model.tls.request.OpenKafkaConsumerRequest;
import com.volcengine.model.tls.request.PutLogsRequest;
import com.volcengine.model.tls.request.SearchLogsRequest;
import com.volcengine.model.tls.request.WebTracksRequest;
import com.volcengine.model.tls.response.ApplyRuleToHostGroupsResponse;
import com.volcengine.model.tls.response.CloseKafkaConsumerResponse;
import com.volcengine.model.tls.response.ConsumeLogsResponse;
import com.volcengine.model.tls.response.CreateAlarmNotifyGroupResponse;
import com.volcengine.model.tls.response.CreateAlarmResponse;
import com.volcengine.model.tls.response.CreateDownloadTaskResponse;
import com.volcengine.model.tls.response.CreateHostGroupResponse;
import com.volcengine.model.tls.response.CreateIndexResponse;
import com.volcengine.model.tls.response.CreateProjectResponse;
import com.volcengine.model.tls.response.CreateRuleResponse;
import com.volcengine.model.tls.response.CreateTopicResponse;
import com.volcengine.model.tls.response.DeleteAlarmNotifyGroupResponse;
import com.volcengine.model.tls.response.DeleteAlarmResponse;
import com.volcengine.model.tls.response.DeleteHostGroupResponse;
import com.volcengine.model.tls.response.DeleteHostResponse;
import com.volcengine.model.tls.response.DeleteIndexResponse;
import com.volcengine.model.tls.response.DeleteProjectResponse;
import com.volcengine.model.tls.response.DeleteRuleFromHostGroupsResponse;
import com.volcengine.model.tls.response.DeleteRuleResponse;
import com.volcengine.model.tls.response.DeleteTopicResponse;
import com.volcengine.model.tls.response.DescribeAlarmNotifyGroupsResponse;
import com.volcengine.model.tls.response.DescribeAlarmsResponse;
import com.volcengine.model.tls.response.DescribeCursorResponse;
import com.volcengine.model.tls.response.DescribeDownloadTasksResponse;
import com.volcengine.model.tls.response.DescribeDownloadUrlResponse;
import com.volcengine.model.tls.response.DescribeHistogramResponse;
import com.volcengine.model.tls.response.DescribeHostGroupResponse;
import com.volcengine.model.tls.response.DescribeHostGroupRulesResponse;
import com.volcengine.model.tls.response.DescribeHostGroupsResponse;
import com.volcengine.model.tls.response.DescribeHostsResponse;
import com.volcengine.model.tls.response.DescribeIndexResponse;
import com.volcengine.model.tls.response.DescribeKafkaConsumerResponse;
import com.volcengine.model.tls.response.DescribeLogContextResponse;
import com.volcengine.model.tls.response.DescribeProjectResponse;
import com.volcengine.model.tls.response.DescribeProjectsResponse;
import com.volcengine.model.tls.response.DescribeRuleResponse;
import com.volcengine.model.tls.response.DescribeRulesResponse;
import com.volcengine.model.tls.response.DescribeShardsResponse;
import com.volcengine.model.tls.response.DescribeTopicResponse;
import com.volcengine.model.tls.response.DescribeTopicsResponse;
import com.volcengine.model.tls.response.ModifyAlarmNotifyGroupResponse;
import com.volcengine.model.tls.response.ModifyAlarmResponse;
import com.volcengine.model.tls.response.ModifyHostGroupResponse;
import com.volcengine.model.tls.response.ModifyHostGroupsAutoUpdateResponse;
import com.volcengine.model.tls.response.ModifyIndexResponse;
import com.volcengine.model.tls.response.ModifyProjectResponse;
import com.volcengine.model.tls.response.ModifyRuleResponse;
import com.volcengine.model.tls.response.ModifyTopicResponse;
import com.volcengine.model.tls.response.OpenKafkaConsumerResponse;
import com.volcengine.model.tls.response.PutLogsResponse;
import com.volcengine.model.tls.response.SearchLogsResponse;
import com.volcengine.model.tls.response.WebTracksResponse;
import com.volcengine.model.tls.util.MessageUtil;
import com.volcengine.model.tls.util.TimeUtil;
import com.volcengine.service.tls.TLSHttpUtil;
import com.volcengine.service.tls.TLSLogClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class TLSLogClientImpl
implements TLSLogClient {
    public static final int DEFAULT_RETRY_CNT = 5;
    private ClientConfig config;
    private final TLSHttpUtil httpRequest;
    private final int maxRetryCount = 5;

    public TLSLogClientImpl(TLSHttpUtil util, ClientConfig config) {
        this.httpRequest = util;
    }

    @Override
    public void configClient(ClientConfig config) {
        this.config = config;
        this.httpRequest.setServiceInfo(ClientConfig.initServiceInfo(config));
    }

    @Override
    public void resetAccessKeyToken(String accessKeyID, String accessKeySecret, String securityToken) {
        this.httpRequest.setAccessKey(accessKeyID);
        this.httpRequest.setSecretKey(accessKeySecret);
        this.httpRequest.setSessionToken(securityToken);
    }

    @Override
    public void setTimeout(int socketTimeout, int connectionTimeout) {
        this.httpRequest.setSocketTimeout(socketTimeout);
        this.httpRequest.setConnectionTimeout(connectionTimeout);
    }

    @Override
    public PutLogsResponse putLogs(PutLogsRequest request) throws LogException {
        String compressType;
        if (request == null || StringUtils.isEmpty((CharSequence)request.getTopicId()) || request.getLogGroupList() == null) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("TopicId", request.getTopicId()));
        HashMap<String, String> headers = new HashMap<String, String>();
        if (request.getHashKey() != null) {
            headers.put("x-tls-hashkey", request.getHashKey());
        }
        if ((compressType = request.getCompressType()) != null) {
            headers.put("x-tls-compresstype", compressType);
            headers.put("x-tls-bodyrawsize", String.valueOf(request.getLogGroupList().toByteArray().length));
        }
        RawResponse rawResponse = this.doProtoRetryRequest("/PutLogs", params, headers, request.getLogGroupList().toByteArray(), compressType, 5);
        return new PutLogsResponse(rawResponse.getHeaders());
    }

    @Override
    public DescribeCursorResponse describeCursor(DescribeCursorRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getTopicId()) || request.getShardId() == null) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("TopicId", request.getTopicId()));
        params.add((NameValuePair)new BasicNameValuePair("ShardId", String.valueOf(request.getShardId())));
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/DescribeCursor", params, requestBody);
        return new DescribeCursorResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeCursorResponse.class);
    }

    @Override
    public ConsumeLogsResponse consumeLogs(ConsumeLogsRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getTopicId()) || request.getShardId() == null) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("TopicId", request.getTopicId()));
        params.add((NameValuePair)new BasicNameValuePair("ShardId", String.valueOf(request.getShardId())));
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/ConsumeLogs", params, requestBody);
        return new ConsumeLogsResponse(rawResponse.getHeaders(), request.getCompression()).deSerialize(rawResponse.getData(), ConsumeLogsResponse.class);
    }

    @Override
    public SearchLogsResponse searchLogs(SearchLogsRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getTopicId()) || StringUtils.isEmpty((CharSequence)request.getQuery()) || request.getStartTime() == null || request.getEndTime() == null) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/SearchLogs", params, requestBody);
        return new SearchLogsResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), SearchLogsResponse.class);
    }

    @Override
    public DescribeShardsResponse describeShards(DescribeShardsRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getTopicId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("TopicId", request.getTopicId()));
        if (request.getPageNumber() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageNumber", String.valueOf(request.getPageNumber())));
        }
        if (request.getPageSize() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageSize", String.valueOf(request.getPageSize())));
        }
        RawResponse rawResponse = this.sendJsonRequest("/DescribeShards", params, "{}");
        return new DescribeShardsResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeShardsResponse.class);
    }

    @Override
    public DescribeLogContextResponse describeLogContext(DescribeLogContextRequest request) throws LogException {
        if (request == null) {
            throw new LogException("InvalidArgument", "Request is null", null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/DescribeLogContext", params, requestBody);
        return new DescribeLogContextResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeLogContextResponse.class);
    }

    @Override
    public WebTracksResponse webTracks(WebTracksRequest request) throws LogException {
        if (request == null) {
            throw new LogException("InvalidArgument", "request is null", null);
        }
        String compressType = request.getCompressType();
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (StringUtils.isNotEmpty((CharSequence)request.getTopicId())) {
            params.add((NameValuePair)new BasicNameValuePair("TopicId", String.valueOf(request.getTopicId())));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getProjectId())) {
            params.add((NameValuePair)new BasicNameValuePair("ProjectId", String.valueOf(request.getProjectId())));
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        if (compressType != null) {
            headers.put("x-tls-compresstype", compressType);
            headers.put("x-tls-bodyrawsize", String.valueOf(requestBody.length()));
        }
        RawResponse rawResponse = this.doProtoRetryRequest("/WebTracks", params, headers, requestBody.getBytes(), compressType, 5);
        return new WebTracksResponse(rawResponse.getHeaders());
    }

    @Override
    public DescribeHistogramResponse describeHistogram(DescribeHistogramRequest request) throws LogException {
        if (request == null) {
            throw new LogException("InvalidArgument", "Request is null", null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/DescribeHistogram", params, requestBody);
        return new DescribeHistogramResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeHistogramResponse.class);
    }

    @Override
    public CreateProjectResponse createProject(CreateProjectRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getProjectName()) || StringUtils.isEmpty((CharSequence)request.getRegion())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/CreateProject", new ArrayList<NameValuePair>(), requestBody);
        return new CreateProjectResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), CreateProjectResponse.class);
    }

    private RawResponse sendJsonRequest(String path, ArrayList<NameValuePair> params, String requestBody) throws LogException {
        this.checkMd5(path, requestBody.getBytes());
        RawResponse rawResponse = this.doRetryRequest(path, params, requestBody, 5);
        if (rawResponse.getCode() != SdkError.SUCCESS.getNumber()) {
            String[] error = this.getError(rawResponse);
            throw new LogException(rawResponse.getHttpCode(), error[0], error[1], rawResponse.getFirstHeader("X-Tls-Requestid"));
        }
        return rawResponse;
    }

    private RawResponse doRetryRequest(String path, ArrayList<NameValuePair> params, String requestBody, int maxRetryCount) throws LogException {
        RawResponse rawResponse = null;
        for (int i = 0; i <= maxRetryCount && (rawResponse = this.httpRequest.json(path, params, requestBody)).getCode() != SdkError.SUCCESS.getNumber() && this.needRetryStatus(rawResponse.getHttpCode()); ++i) {
            try {
                long sleepMs = TimeUtil.calDefaultBackOffMs(i);
                Thread.sleep(sleepMs);
                continue;
            }
            catch (InterruptedException e) {
                throw new LogException("sdk error", "retry thread interrupt exception", null);
            }
        }
        if (rawResponse.getCode() != SdkError.SUCCESS.getNumber()) {
            String[] error = this.getError(rawResponse);
            throw new LogException(rawResponse.getHttpCode(), error[0], error[1], rawResponse.getFirstHeader("X-Tls-Requestid"));
        }
        return rawResponse;
    }

    private boolean needRetryStatus(int httpCode) {
        return httpCode == 429 || httpCode >= 500;
    }

    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getProjectId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/DeleteProject", new ArrayList<NameValuePair>(), requestBody);
        return new DeleteProjectResponse(rawResponse.getHeaders());
    }

    @Override
    public ModifyProjectResponse modifyProject(ModifyProjectRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getProjectId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/ModifyProject", new ArrayList<NameValuePair>(), requestBody);
        return new ModifyProjectResponse(rawResponse.getHeaders());
    }

    @Override
    public DescribeProjectResponse describeProject(DescribeProjectRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getProjectId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("ProjectId", request.getProjectId()));
        RawResponse rawResponse = this.sendJsonRequest("/DescribeProject", params, "{}");
        return new DescribeProjectResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeProjectResponse.class);
    }

    @Override
    public DescribeProjectsResponse describeProjects(DescribeProjectsRequest request) throws LogException {
        if (request == null) {
            throw new LogException("InvalidArgument", "Request is null", null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (request.getIsFullName() != null) {
            params.add((NameValuePair)new BasicNameValuePair("IsFullName", String.valueOf(request.getIsFullName())));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getProjectId())) {
            params.add((NameValuePair)new BasicNameValuePair("ProjectId", request.getProjectId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getProjectName())) {
            params.add((NameValuePair)new BasicNameValuePair("ProjectName", request.getProjectName()));
        }
        if (request.getPageNumber() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageNumber", String.valueOf(request.getPageNumber())));
        }
        if (request.getPageSize() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageSize", String.valueOf(request.getPageSize())));
        }
        RawResponse rawResponse = this.sendJsonRequest("/DescribeProjects", params, "{}");
        return new DescribeProjectsResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeProjectsResponse.class);
    }

    @Override
    public CreateTopicResponse createTopic(CreateTopicRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getProjectId()) || StringUtils.isEmpty((CharSequence)request.getTopicName()) || request.getTtl() == null) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/CreateTopic", new ArrayList<NameValuePair>(), requestBody);
        return new CreateTopicResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), CreateTopicResponse.class);
    }

    @Override
    public DeleteTopicResponse deleteTopic(DeleteTopicRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getTopicId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/DeleteTopic", new ArrayList<NameValuePair>(), requestBody);
        return new DeleteTopicResponse(rawResponse.getHeaders());
    }

    @Override
    public ModifyTopicResponse modifyTopic(ModifyTopicRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getTopicId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/ModifyTopic", new ArrayList<NameValuePair>(), requestBody);
        return new ModifyTopicResponse(rawResponse.getHeaders());
    }

    @Override
    public DescribeTopicResponse describeTopic(DescribeTopicRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getTopicId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("TopicId", request.getTopicId()));
        RawResponse rawResponse = this.sendJsonRequest("/DescribeTopic", params, "{}");
        return new DescribeTopicResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeTopicResponse.class);
    }

    @Override
    public DescribeTopicsResponse describeTopics(DescribeTopicsRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getProjectId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("ProjectId", request.getProjectId()));
        if (request.getIsFullName() != null) {
            params.add((NameValuePair)new BasicNameValuePair("IsFullName", String.valueOf(request.getIsFullName())));
        }
        if (request.getPageNumber() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageNumber", String.valueOf(request.getPageNumber())));
        }
        if (request.getPageSize() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageSize", String.valueOf(request.getPageSize())));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getTopicId())) {
            params.add((NameValuePair)new BasicNameValuePair("TopicId", request.getTopicId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getTopicName())) {
            params.add((NameValuePair)new BasicNameValuePair("TopicName", request.getTopicName()));
        }
        RawResponse rawResponse = this.sendJsonRequest("/DescribeTopics", params, "{}");
        return new DescribeTopicsResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeTopicsResponse.class);
    }

    @Override
    public CreateIndexResponse createIndex(CreateIndexRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getTopicId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/CreateIndex", new ArrayList<NameValuePair>(), requestBody);
        return new CreateIndexResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), CreateIndexResponse.class);
    }

    @Override
    public DeleteIndexResponse deleteIndex(DeleteIndexRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getTopicId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/DeleteIndex", new ArrayList<NameValuePair>(), requestBody);
        return new DeleteIndexResponse(rawResponse.getHeaders());
    }

    @Override
    public ModifyIndexResponse modifyIndex(ModifyIndexRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getTopicId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/ModifyIndex", new ArrayList<NameValuePair>(), requestBody);
        return new ModifyIndexResponse(rawResponse.getHeaders());
    }

    @Override
    public DescribeIndexResponse describeIndex(DescribeIndexRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getTopicId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("TopicId", request.getTopicId()));
        RawResponse rawResponse = this.sendJsonRequest("/DescribeIndex", params, "{}");
        return new DescribeIndexResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeIndexResponse.class);
    }

    @Override
    public CreateRuleResponse createRule(CreateRuleRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getTopicId()) || StringUtils.isEmpty((CharSequence)request.getRuleName())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/CreateRule", new ArrayList<NameValuePair>(), requestBody);
        return new CreateRuleResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), CreateRuleResponse.class);
    }

    @Override
    public DeleteRuleResponse deleteRule(DeleteRuleRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getRuleId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/DeleteRule", new ArrayList<NameValuePair>(), requestBody);
        return new DeleteRuleResponse(rawResponse.getHeaders());
    }

    @Override
    public ModifyRuleResponse modifyRule(ModifyRuleRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getRuleId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/ModifyRule", new ArrayList<NameValuePair>(), requestBody);
        return new ModifyRuleResponse(rawResponse.getHeaders());
    }

    @Override
    public DescribeRuleResponse describeRule(DescribeRuleRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getRuleId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("RuleId", request.getRuleId()));
        RawResponse rawResponse = this.sendJsonRequest("/DescribeRule", params, "{}");
        return new DescribeRuleResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeRuleResponse.class);
    }

    @Override
    public DescribeRulesResponse describeRules(DescribeRulesRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getProjectId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("ProjectId", request.getProjectId()));
        if (request.getPageNumber() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageNumber", String.valueOf(request.getPageNumber())));
        }
        if (request.getPageSize() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageSize", String.valueOf(request.getPageSize())));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getRuleId())) {
            params.add((NameValuePair)new BasicNameValuePair("RuleId", request.getRuleId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getRuleName())) {
            params.add((NameValuePair)new BasicNameValuePair("RuleName", request.getRuleName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getTopicId())) {
            params.add((NameValuePair)new BasicNameValuePair("TopicId", request.getTopicId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getTopicName())) {
            params.add((NameValuePair)new BasicNameValuePair("TopicName", request.getTopicName()));
        }
        RawResponse rawResponse = this.sendJsonRequest("/DescribeRules", params, "{}");
        return new DescribeRulesResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeRulesResponse.class);
    }

    @Override
    public ApplyRuleToHostGroupsResponse applyRuleToHostGroups(ApplyRuleToHostGroupsRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getRuleId()) || request.getHostGroupIds() == null) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/ApplyRuleToHostGroups", new ArrayList<NameValuePair>(), requestBody);
        return new ApplyRuleToHostGroupsResponse(rawResponse.getHeaders());
    }

    @Override
    public DeleteRuleFromHostGroupsResponse deleteRuleFromHostGroups(DeleteRuleFromHostGroupsRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getRuleId()) || request.getHostGroupIds() == null) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/DeleteRuleFromHostGroups", new ArrayList<NameValuePair>(), requestBody);
        return new DeleteRuleFromHostGroupsResponse(rawResponse.getHeaders());
    }

    @Override
    public CreateHostGroupResponse createHostGroup(CreateHostGroupRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getHostGroupName()) || StringUtils.isEmpty((CharSequence)request.getHostGroupType())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/CreateHostGroup", new ArrayList<NameValuePair>(), requestBody);
        return new CreateHostGroupResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), CreateHostGroupResponse.class);
    }

    @Override
    public DeleteHostGroupResponse deleteHostGroup(DeleteHostGroupRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getHostGroupId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/DeleteHostGroup", new ArrayList<NameValuePair>(), requestBody);
        return new DeleteHostGroupResponse(rawResponse.getHeaders());
    }

    @Override
    public ModifyHostGroupResponse modifyHostGroup(ModifyHostGroupRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getHostGroupId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/ModifyHostGroup", new ArrayList<NameValuePair>(), requestBody);
        return new ModifyHostGroupResponse(rawResponse.getHeaders());
    }

    @Override
    public DescribeHostGroupResponse describeHostGroup(DescribeHostGroupRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getHostGroupId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("HostGroupId", request.getHostGroupId()));
        RawResponse rawResponse = this.sendJsonRequest("/DescribeHostGroup", params, "{}");
        return new DescribeHostGroupResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeHostGroupResponse.class);
    }

    @Override
    public DescribeHostGroupsResponse describeHostGroups(DescribeHostGroupsRequest request) throws LogException {
        if (request == null) {
            throw new LogException("InvalidArgument", "Request is null", null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (request.getPageNumber() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageNumber", String.valueOf(request.getPageNumber())));
        }
        if (request.getPageSize() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageSize", String.valueOf(request.getPageSize())));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getHostGroupId())) {
            params.add((NameValuePair)new BasicNameValuePair("HostGroupId", request.getHostGroupId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getHostGroupName())) {
            params.add((NameValuePair)new BasicNameValuePair("HostGroupName", request.getHostGroupName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getHostIdentifier())) {
            params.add((NameValuePair)new BasicNameValuePair("HostIdentifier", request.getHostIdentifier()));
        }
        RawResponse rawResponse = this.sendJsonRequest("/DescribeHostGroups", params, "{}");
        return new DescribeHostGroupsResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeHostGroupsResponse.class);
    }

    @Override
    public DescribeHostsResponse describeHosts(DescribeHostsRequest request) throws LogException {
        if (request == null) {
            throw new LogException("InvalidArgument", "Request is null", null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (request.getPageNumber() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageNumber", String.valueOf(request.getPageNumber())));
        }
        if (request.getPageSize() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageSize", String.valueOf(request.getPageSize())));
        }
        if (request.getHeartbeatStatus() != null) {
            params.add((NameValuePair)new BasicNameValuePair("HeartbeatStatus", String.valueOf(request.getHeartbeatStatus())));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getHostGroupId())) {
            params.add((NameValuePair)new BasicNameValuePair("HostGroupId", request.getHostGroupId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getIp())) {
            params.add((NameValuePair)new BasicNameValuePair("Ip", request.getIp()));
        }
        RawResponse rawResponse = this.sendJsonRequest("/DescribeHosts", params, "{}");
        return new DescribeHostsResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeHostsResponse.class);
    }

    @Override
    public DeleteHostResponse deleteHost(DeleteHostRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getHostGroupId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/DeleteHost", new ArrayList<NameValuePair>(), requestBody);
        return new DeleteHostResponse(rawResponse.getHeaders());
    }

    @Override
    public DescribeHostGroupRulesResponse describeHostGroupRules(DescribeHostGroupRulesRequest request) throws LogException {
        if (request == null || request.getHostGroupId() == null) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("HostGroupId", request.getHostGroupId()));
        if (request.getPageNumber() > 0) {
            params.add((NameValuePair)new BasicNameValuePair("PageNumber", String.valueOf(request.getPageNumber())));
        }
        if (request.getPageSize() > 0) {
            params.add((NameValuePair)new BasicNameValuePair("PageSize", String.valueOf(request.getPageSize())));
        }
        RawResponse rawResponse = this.sendJsonRequest("/DescribeHostGroupRules", params, "{}");
        return new DescribeHostGroupRulesResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeHostGroupRulesResponse.class);
    }

    @Override
    public ModifyHostGroupsAutoUpdateResponse modifyHostGroupsAutoUpdate(ModifyHostGroupsAutoUpdateRequest request) throws LogException {
        if (request == null) {
            throw new LogException("InvalidArgument", "Request is null", null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/ModifyHostGroupsAutoUpdate", params, requestBody);
        return new ModifyHostGroupsAutoUpdateResponse(rawResponse.getHeaders());
    }

    @Override
    public CreateAlarmResponse createAlarm(CreateAlarmRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getAlarmName()) || request.getProjectId() == null || request.getQueryRequest() == null || request.getRequestCycle() == null || request.getCondition() == null || request.getAlarmPeriod() == null || request.getAlarmNotifyGroup() == null) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/CreateAlarm", new ArrayList<NameValuePair>(), requestBody);
        return new CreateAlarmResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), CreateAlarmResponse.class);
    }

    @Override
    public DeleteAlarmResponse deleteAlarm(DeleteAlarmRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getAlarmId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/DeleteAlarm", new ArrayList<NameValuePair>(), requestBody);
        return new DeleteAlarmResponse(rawResponse.getHeaders());
    }

    @Override
    public ModifyAlarmResponse modifyAlarm(ModifyAlarmRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getAlarmId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/ModifyAlarm", new ArrayList<NameValuePair>(), requestBody);
        return new ModifyAlarmResponse(rawResponse.getHeaders());
    }

    @Override
    public DescribeAlarmsResponse describeAlarms(DescribeAlarmsRequest request) throws LogException {
        if (request == null || request.getProjectId() == null) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (request.getPageNumber() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageNumber", String.valueOf(request.getPageNumber())));
        }
        if (request.getPageSize() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageSize", String.valueOf(request.getPageSize())));
        }
        params.add((NameValuePair)new BasicNameValuePair("ProjectId", String.valueOf(request.getProjectId())));
        if (StringUtils.isNotEmpty((CharSequence)request.getAlarmName())) {
            params.add((NameValuePair)new BasicNameValuePair("AlarmName", String.valueOf(request.getAlarmName())));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getAlarmId())) {
            params.add((NameValuePair)new BasicNameValuePair("AlarmId", String.valueOf(request.getAlarmId())));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getTopicId())) {
            params.add((NameValuePair)new BasicNameValuePair("TopicId", String.valueOf(request.getTopicId())));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getTopicName())) {
            params.add((NameValuePair)new BasicNameValuePair("TopicName", String.valueOf(request.getTopicName())));
        }
        if (request.getStatus() != null) {
            params.add((NameValuePair)new BasicNameValuePair("Status", String.valueOf(request.getStatus())));
        }
        RawResponse rawResponse = this.sendJsonRequest("/DescribeAlarms", params, "{}");
        return new DescribeAlarmsResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeAlarmsResponse.class);
    }

    @Override
    public CreateAlarmNotifyGroupResponse createAlarmNotifyGroup(CreateAlarmNotifyGroupRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getAlarmNotifyGroupName()) || request.getNotifyType() == null || request.getReceivers() == null) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/CreateAlarmNotifyGroup", new ArrayList<NameValuePair>(), requestBody);
        return new CreateAlarmNotifyGroupResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), CreateAlarmNotifyGroupResponse.class);
    }

    @Override
    public DeleteAlarmNotifyGroupResponse deleteAlarmNotifyGroup(DeleteAlarmNotifyGroupRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getAlarmNotifyGroupId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/DeleteAlarmNotifyGroup", new ArrayList<NameValuePair>(), requestBody);
        return new DeleteAlarmNotifyGroupResponse(rawResponse.getHeaders());
    }

    @Override
    public ModifyAlarmNotifyGroupResponse modifyAlarmNotifyGroup(ModifyAlarmNotifyGroupRequest request) throws LogException {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getAlarmNotifyGroupId())) {
            throw new LogException("InvalidArgument", "Request is:" + request, null);
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/ModifyAlarmNotifyGroup", new ArrayList<NameValuePair>(), requestBody);
        return new ModifyAlarmNotifyGroupResponse(rawResponse.getHeaders());
    }

    @Override
    public DescribeAlarmNotifyGroupsResponse describeAlarmNotifyGroups(DescribeAlarmNotifyGroupsRequest request) throws LogException {
        if (request == null) {
            throw new LogException("InvalidArgument", "Request is null", null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (request.getPageNumber() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageNumber", String.valueOf(request.getPageNumber())));
        }
        if (request.getPageSize() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageSize", String.valueOf(request.getPageSize())));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getAlarmNotifyGroupId())) {
            params.add((NameValuePair)new BasicNameValuePair("AlarmNotifyGroupId", String.valueOf(request.getAlarmNotifyGroupId())));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getAlarmNotifyGroupName())) {
            params.add((NameValuePair)new BasicNameValuePair("AlarmNotifyGroupName", String.valueOf(request.getAlarmNotifyGroupName())));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getReceiverName())) {
            params.add((NameValuePair)new BasicNameValuePair("ReceiverName", String.valueOf(request.getReceiverName())));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getAlarmNotifyGroupId())) {
            params.add((NameValuePair)new BasicNameValuePair("AlarmNotifyGroupId", String.valueOf(request.getAlarmNotifyGroupId())));
        }
        RawResponse rawResponse = this.sendJsonRequest("/DescribeAlarmNotifyGroups", params, "{}");
        return new DescribeAlarmNotifyGroupsResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeAlarmNotifyGroupsResponse.class);
    }

    @Override
    public OpenKafkaConsumerResponse openKafkaConsumer(OpenKafkaConsumerRequest request) throws LogException {
        if (request == null) {
            throw new LogException("InvalidArgument", "Request is null", null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/OpenKafkaConsumer", params, requestBody);
        return new OpenKafkaConsumerResponse(rawResponse.getHeaders());
    }

    @Override
    public CloseKafkaConsumerResponse closeKafkaConsumer(CloseKafkaConsumerRequest request) throws LogException {
        if (request == null) {
            throw new LogException("InvalidArgument", "Request is null", null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/CloseKafkaConsumer", params, requestBody);
        return new CloseKafkaConsumerResponse(rawResponse.getHeaders());
    }

    @Override
    public DescribeKafkaConsumerResponse describeKafkaConsumer(DescribeKafkaConsumerRequest request) throws LogException {
        if (request == null) {
            throw new LogException("InvalidArgument", "Request is null", null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (StringUtils.isNotEmpty((CharSequence)request.getTopicId())) {
            params.add((NameValuePair)new BasicNameValuePair("TopicId", String.valueOf(request.getTopicId())));
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/DescribeKafkaConsumer", params, requestBody);
        return new DescribeKafkaConsumerResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeKafkaConsumerResponse.class);
    }

    @Override
    public CreateDownloadTaskResponse createDownloadTask(CreateDownloadTaskRequest request) throws LogException {
        if (request == null) {
            throw new LogException("InvalidArgument", "Request is null", null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/CreateDownloadTask", params, requestBody);
        return new CreateDownloadTaskResponse(rawResponse.getHeaders());
    }

    @Override
    public DescribeDownloadTasksResponse describeDownloadTasks(DescribeDownloadTasksRequest request) throws LogException {
        if (request == null) {
            throw new LogException("InvalidArgument", "Request is null", null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (StringUtils.isNotEmpty((CharSequence)request.getTopicId())) {
            params.add((NameValuePair)new BasicNameValuePair("TopicId", String.valueOf(request.getTopicId())));
        }
        if (request.getPageNumber() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageNumber", String.valueOf(request.getPageNumber())));
        }
        if (request.getPageSize() != null) {
            params.add((NameValuePair)new BasicNameValuePair("PageSize", String.valueOf(request.getPageSize())));
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/DescribeDownloadTasks", params, requestBody);
        return new DescribeDownloadTasksResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeDownloadTasksResponse.class);
    }

    @Override
    public DescribeDownloadUrlResponse describeDownloadUrl(DescribeDownloadUrlRequest request) throws LogException {
        if (request == null) {
            throw new LogException("InvalidArgument", "Request is null", null);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (StringUtils.isNotEmpty((CharSequence)request.getTaskId())) {
            params.add((NameValuePair)new BasicNameValuePair("TaskId", String.valueOf(request.getTaskId())));
        }
        String requestBody = JSONObject.toJSONString((Object)request);
        RawResponse rawResponse = this.sendJsonRequest("/DescribeDownloadUrl", params, requestBody);
        return new DescribeDownloadUrlResponse(rawResponse.getHeaders()).deSerialize(rawResponse.getData(), DescribeDownloadUrlResponse.class);
    }

    private RawResponse doProtoRetryRequest(String api, List<NameValuePair> params, Map<String, String> headers, byte[] body, String compressType, int maxRetryCount) throws LogException {
        RawResponse rawResponse = null;
        for (int i = 0; i <= maxRetryCount && (rawResponse = this.httpRequest.proto(api, params, headers, body, compressType)).getCode() != SdkError.SUCCESS.getNumber() && this.needRetryStatus(rawResponse.getHttpCode()); ++i) {
            try {
                long sleepMs = TimeUtil.calDefaultBackOffMs(i);
                Thread.sleep(sleepMs);
                continue;
            }
            catch (InterruptedException e) {
                throw new LogException("sdk error", "retry thread interrupt exception", null);
            }
        }
        if (rawResponse.getCode() != SdkError.SUCCESS.getNumber()) {
            String[] error = this.getError(rawResponse);
            throw new LogException(rawResponse.getHttpCode(), error[0], error[1], rawResponse.getFirstHeader("X-Tls-Requestid"));
        }
        return rawResponse;
    }

    private void checkMd5(String path, byte[] body) throws LogException {
        String checkSum;
        ApiInfo apiInfo = this.httpRequest.getApiInfoList().get(path);
        List<Header> header = apiInfo.getHeader();
        if (header == null) {
            header = new ArrayList<Header>();
        }
        if ((checkSum = MessageUtil.md5CheckSum(body)) != null) {
            header.add((Header)new BasicHeader("Content-MD5", checkSum));
        }
    }

    private String[] getError(RawResponse response) {
        String message = "";
        String code = SdkError.getErrorDesc(SdkError.getError(response.getCode()));
        if (response.getException() != null) {
            message = response.getException().getMessage();
        }
        return new String[]{code, message};
    }
}

