/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.imagex;

import com.volcengine.model.ApiInfo;
import com.volcengine.model.Credentials;
import com.volcengine.model.ServiceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class ImageXConfig {
    public static final String RESOURCE_SERVICE_ID_FORMAT = "trn:ImageX:*:*:ServiceId/%s";
    public static final String RESOURCE_STORE_KEY_FORMAT = "trn:ImageX:*:*:StoreKeys/%s";
    public static final int MIN_CHUNK_SIZE = 0x1400000;
    public static final int LARGE_FILE_SIZE = 0x40000000;
    public static Map<String, ServiceInfo> serviceInfoMap = new HashMap<String, ServiceInfo>(){
        {
            this.put("cn-north-1", new ServiceInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("ConnectionTimeout", 5000);
                    this.put("SocketTimeout", 5000);
                    this.put("Scheme", "https");
                    this.put("Host", "imagex.volcengineapi.com");
                    this.put("Header", new ArrayList<Header>(){
                        {
                            this.add(new BasicHeader("Accept", "application/json"));
                        }
                    });
                    this.put("Credentials", new Credentials("cn-north-1", "ImageX"));
                }
            }));
            this.put("us-east-1", new ServiceInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("ConnectionTimeout", 5000);
                    this.put("SocketTimeout", 5000);
                    this.put("Scheme", "https");
                    this.put("Host", "imagex-us-east-1.volcengineapi.com");
                    this.put("Header", new ArrayList<Header>(){
                        {
                            this.add(new BasicHeader("Accept", "application/json"));
                        }
                    });
                    this.put("Credentials", new Credentials("us-east-1", "ImageX"));
                }
            }));
            this.put("ap-singapore-1", new ServiceInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("ConnectionTimeout", 5000);
                    this.put("SocketTimeout", 5000);
                    this.put("Scheme", "https");
                    this.put("Host", "imagex-ap-singapore-1.volcengineapi.com");
                    this.put("Header", new ArrayList<Header>(){
                        {
                            this.add(new BasicHeader("Accept", "application/json"));
                        }
                    });
                    this.put("Credentials", new Credentials("ap-singapore-1", "ImageX"));
                }
            }));
        }
    };
    public static Map<String, ApiInfo> apiInfoList = new HashMap<String, ApiInfo>(){
        {
            this.put("GetImageServiceSubscription", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageServiceSubscription"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("CreateImageService", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "CreateImageService"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageService", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageService"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetAllImageServices", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetAllImageServices"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("DeleteImageService", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "DeleteImageService"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("UpdateImageAuthKey", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "UpdateImageAuthKey"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageAuthKey", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageAuthKey"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("UpdateImageObjectAccess", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "UpdateImageObjectAccess"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("UpdateImageMirrorConf", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "UpdateImageMirrorConf"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("DelDomain", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "DelDomain"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetServiceDomains", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetServiceDomains"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetDomainConfig", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetDomainConfig"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("SetDefaultDomain", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "SetDefaultDomain"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("UpdateResponseHeader", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "UpdateResponseHeader"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("UpdateRefer", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "UpdateRefer"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("UpdateHttps", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "UpdateHttps"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetResponseHeaderValidateKeys", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetResponseHeaderValidateKeys"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("CreateImageTemplate", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "CreateImageTemplate"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("DeleteImageTemplate", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "DeleteImageTemplate"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageTemplate", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageTemplate"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetAllImageTemplates", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetAllImageTemplates"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetTemplatesFromBin", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetTemplatesFromBin"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("CreateTemplatesFromBin", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "CreateTemplatesFromBin"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("DeleteTemplatesFromBin", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "DeleteTemplatesFromBin"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("ApplyImageUpload", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "ApplyImageUpload"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("CommitImageUpload", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "CommitImageUpload"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageUploadFile", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageUploadFile"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageUploadFiles", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageUploadFiles"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("DeleteImageUploadFiles", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "DeleteImageUploadFiles"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("PreviewImageUploadFile", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "PreviewImageUploadFile"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("CreateImageContentTask", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "CreateImageContentTask"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageContentTaskDetail", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageContentTaskDetail"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageContentBlockList", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageContentBlockList"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageUpdateFiles", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageUpdateFiles"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("FetchImageUrl", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "FetchImageUrl"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetUrlFetchTask", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetUrlFetchTask"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("UpdateServiceName", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "UpdateServiceName"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageOCR", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageOCR"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageQuality", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageQuality"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageEraseModels", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "GET");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageEraseModels"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageEnhanceResult", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageEnhanceResult"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageBgFillResult", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageBgFillResult"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageDuplicateDetection", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageDuplicateDetection"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetDenoisingImage", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetDenoisingImage"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetSegmentImage", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetSegmentImage"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageComicResult", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageComicResult"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageSuperResolutionResult", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageSuperResolutionResult"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageSmartCropResult", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageSmartCropResult"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetLicensePlateDetection", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetLicensePlateDetection"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImagePSDetection", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImagePSDetection"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetPrivateImageType", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetPrivateImageType"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("CreateImageHmEmbed", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "CreateImageHmEmbed"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("CreateImageHmExtract", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "CreateImageHmExtract"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageEraseResult", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageEraseResult"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            this.put("GetImageStyleResult", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("Method", "POST");
                    this.put("Path", "/");
                    this.put("Query", new ArrayList<NameValuePair>(){
                        {
                            this.add(new BasicNameValuePair("Action", "GetImageStyleResult"));
                            this.add(new BasicNameValuePair("Version", "2018-08-01"));
                        }
                    });
                }
            }));
            new ArrayList<String>(){
                {
                    this.add("DescribeImageXDomainTrafficData");
                    this.add("DescribeImageXDomainBandwidthData");
                    this.add("DescribeImageXBucketUsage");
                    this.add("DescribeImageXRequestCntUsage");
                    this.add("DescribeImageXBaseOpUsage");
                    this.add("DescribeImageXCompressUsage");
                    this.add("DescribeImageXEdgeRequest");
                    this.add("DescribeImageXHitRateTrafficData");
                    this.add("DescribeImageXHitRateRequestData");
                    this.add("DescribeImageXCDNTopRequestData");
                    this.add("DescribeImageXSummary");
                    this.add("DescribeImageXEdgeRequestBandwidth");
                    this.add("DescribeImageXEdgeRequestTraffic");
                    this.add("DescribeImageXEdgeRequestRegions");
                    this.add("DescribeImageXServiceQuality");
                    this.add("GetImageXQueryApps");
                    this.add("GetImageXQueryRegions");
                    this.add("GetImageXQueryDims");
                    this.add("GetImageXQueryVals");
                }
            }.forEach(ImageXConfig.addApi(this, "GET"));
            new ArrayList<String>(){
                {
                    this.add("DescribeImageXMirrorRequestTraffic");
                    this.add("DescribeImageXMirrorRequestBandwidth");
                    this.add("DescribeImageXMirrorRequestHttpCodeByTime");
                    this.add("DescribeImageXMirrorRequestHttpCodeOverview");
                    this.add("DescribeImageXUploadSuccessRateByTime");
                    this.add("DescribeImageXUploadErrorCodeAll");
                    this.add("DescribeImageXUploadErrorCodeByTime");
                    this.add("DescribeImageXUploadCountByTime");
                    this.add("DescribeImageXUploadFileSize");
                    this.add("DescribeImageXUploadSpeed");
                    this.add("DescribeImageXUploadDuration");
                    this.add("DescribeImageXUploadSegmentSpeedByTime");
                    this.add("DescribeImageXCdnSuccessRateByTime");
                    this.add("DescribeImageXCdnSuccessRateAll");
                    this.add("DescribeImageXCdnErrorCodeByTime");
                    this.add("DescribeImageXCdnErrorCodeAll");
                    this.add("DescribeImageXCdnDurationDetailByTime");
                    this.add("DescribeImageXCdnDurationAll");
                    this.add("DescribeImageXCdnReuseRateByTime");
                    this.add("DescribeImageXCdnReuseRateAll");
                    this.add("DescribeImageXCdnProtocolRateByTime");
                    this.add("DescribeImageXClientErrorCodeAll");
                    this.add("DescribeImageXClientErrorCodeByTime");
                    this.add("DescribeImageXClientDecodeSuccessRateByTime");
                    this.add("DescribeImageXClientDecodeDurationByTime");
                    this.add("DescribeImageXClientQueueDurationByTime");
                    this.add("DescribeImageXClientLoadDurationAll");
                    this.add("DescribeImageXClientLoadDuration");
                    this.add("DescribeImageXClientFailureRate");
                    this.add("DescribeImageXClientSdkVerByTime");
                    this.add("DescribeImageXClientFileSize");
                    this.add("DescribeImageXClientTopFileSize");
                    this.add("DescribeImageXClientCountByTime");
                    this.add("DescribeImageXClientScoreByTime");
                    this.add("DescribeImageXClientDemotionRateByTime");
                    this.add("DescribeImageXClientTopDemotionURL");
                    this.add("DescribeImageXClientQualityRateByTime");
                    this.add("DescribeImageXClientTopQualityURL");
                    this.add("DescribeImageXSensibleCountByTime");
                    this.add("DescribeImageXSensibleCacheHitRateByTime");
                    this.add("DescribeImageXSensibleTopSizeURL");
                    this.add("DescribeImageXSensibleTopRamURL");
                    this.add("DescribeImageXSensibleTopResolutionURL");
                    this.add("DescribeImageXSensibleTopUnknownURL");
                }
            }.forEach(ImageXConfig.addApi(this, "POST"));
            new ArrayList<String>(){
                {
                    this.add("DescribeImageVolcCdnAccessLog");
                }
            }.forEach(ImageXConfig.addApi(this, "POST"));
        }
    };

    private static Consumer<String> addApi(HashMap<String, ApiInfo> apiInfoList, final String method) {
        return it -> apiInfoList.put((String)it, new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("Method", method);
                this.put("Path", "/");
                this.put("Query", new ArrayList<NameValuePair>(){
                    {
                        this.add(new BasicNameValuePair("Action", it));
                        this.add(new BasicNameValuePair("Version", "2018-08-01"));
                    }
                });
            }
        }));
    }
}

