/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.numberpool.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.response.RawResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.numberpool.NumberPoolConfig;
import com.volcengine.service.numberpool.NumberPoolService;
import com.volcengine.service.numberpool.request.CreateNumberPoolRequest;
import com.volcengine.service.numberpool.request.EnableNumberRequest;
import com.volcengine.service.numberpool.request.NumberListRequest;
import com.volcengine.service.numberpool.request.NumberPoolListRequest;
import com.volcengine.service.numberpool.request.SelectNumberRequest;
import com.volcengine.service.numberpool.request.UpdateNumberPoolRequest;
import com.volcengine.service.numberpool.response.CreateNumberPoolResponse;
import com.volcengine.service.numberpool.response.EnableNumberResponse;
import com.volcengine.service.numberpool.response.NumberListResponse;
import com.volcengine.service.numberpool.response.NumberPoolListResponse;
import com.volcengine.service.numberpool.response.SelectNumberResponse;
import com.volcengine.service.numberpool.response.UpdateNumberPoolResponse;
import java.util.Collections;
import java.util.List;
import org.apache.http.NameValuePair;

public class NumberPoolServiceImpl
extends BaseServiceImpl
implements NumberPoolService {
    protected NumberPoolServiceImpl() {
        super(NumberPoolConfig.serviceInfoMap.get("cn-north-1"), NumberPoolConfig.apiInfoList);
    }

    public static NumberPoolServiceImpl getInstance() {
        return new NumberPoolServiceImpl();
    }

    @Override
    public NumberPoolListResponse queryNumberPoolList(NumberPoolListRequest request) throws Exception {
        RawResponse response = this.query("NumberPoolList", Utils.mapToPairList(Utils.paramsToMap(request)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (NumberPoolListResponse)JSON.parseObject((byte[])response.getData(), NumberPoolListResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public NumberListResponse queryNumberList(NumberListRequest request) throws Exception {
        RawResponse response = this.query("NumberList", Utils.mapToPairList(Utils.paramsToMap(request)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (NumberListResponse)JSON.parseObject((byte[])response.getData(), NumberListResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CreateNumberPoolResponse createNumberPool(CreateNumberPoolRequest request) throws Exception {
        RawResponse response = this.formPost("CreateNumberPool", Utils.mapToPairList(Utils.paramsToMap(request)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CreateNumberPoolResponse)JSON.parseObject((byte[])response.getData(), CreateNumberPoolResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public UpdateNumberPoolResponse updateNumberPool(UpdateNumberPoolRequest request) throws Exception {
        RawResponse response = this.formPost("UpdateNumberPool", Utils.mapToPairList(Utils.paramsToMap(request)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (UpdateNumberPoolResponse)JSON.parseObject((byte[])response.getData(), UpdateNumberPoolResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public EnableNumberResponse enableOrDisableNumber(EnableNumberRequest request) throws Exception {
        RawResponse response = this.formPost("EnableOrDisableNumber", Utils.mapToPairList(Utils.paramsToMap(request)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (EnableNumberResponse)JSON.parseObject((byte[])response.getData(), EnableNumberResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public SelectNumberResponse selectNumber(SelectNumberRequest request) throws Exception {
        RawResponse response = this.query("SelectNumber", Utils.mapToPairList(Utils.paramsToMap(request)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (SelectNumberResponse)JSON.parseObject((byte[])response.getData(), SelectNumberResponse.class, (Feature[])new Feature[0]);
    }

    private RawResponse formPost(String api, List<NameValuePair> nameValuePairs) {
        return this.post(api, Collections.emptyList(), nameValuePairs);
    }
}

