/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.stream.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.stream.CheckRelationRequest;
import com.volcengine.model.stream.CheckRelationResponse;
import com.volcengine.model.stream.CommonPo;
import com.volcengine.model.stream.DiggRequest;
import com.volcengine.model.stream.DiggResponse;
import com.volcengine.model.stream.FeedBackRequest;
import com.volcengine.model.stream.FeedBackResponse;
import com.volcengine.model.stream.FollowArticlesRequest;
import com.volcengine.model.stream.FollowArticlesResponse;
import com.volcengine.model.stream.FollowRequest;
import com.volcengine.model.stream.FollowResponse;
import com.volcengine.model.stream.GetArticleRequest;
import com.volcengine.model.stream.GetArticleResponse;
import com.volcengine.model.stream.GetArticlesRequest;
import com.volcengine.model.stream.GetArticlesResponse;
import com.volcengine.model.stream.GetDiggListRequest;
import com.volcengine.model.stream.GetDiggListResponse;
import com.volcengine.model.stream.GetFollowingListRequest;
import com.volcengine.model.stream.GetFollowingListResponse;
import com.volcengine.model.stream.GetListRequest;
import com.volcengine.model.stream.GetListResponse;
import com.volcengine.model.stream.GetUnionProductRequest;
import com.volcengine.model.stream.GetUnionProductResponse;
import com.volcengine.model.stream.GetVideoUrlRequest;
import com.volcengine.model.stream.GetVideoUrlResponse;
import com.volcengine.model.stream.HotBoardArticleRequest;
import com.volcengine.model.stream.HotBoardArticleResponse;
import com.volcengine.model.stream.HotBoardBaseRequest;
import com.volcengine.model.stream.HotBoardBoardRequest;
import com.volcengine.model.stream.HotBoardBoardResponse;
import com.volcengine.model.stream.HotBoardListRequest;
import com.volcengine.model.stream.HotBoardListResponse;
import com.volcengine.model.stream.HotBoardRequest;
import com.volcengine.model.stream.HotBoardResponse;
import com.volcengine.model.stream.RecommendCategoryInfoRequest;
import com.volcengine.model.stream.RecommendCategoryInfoResponse;
import com.volcengine.model.stream.RecommendCategoryUserRequest;
import com.volcengine.model.stream.RecommendCategoryUserResponse;
import com.volcengine.model.stream.RecommendRelatedUserRequest;
import com.volcengine.model.stream.RecommendRelatedUserResponse;
import com.volcengine.model.stream.RefreshTipsRequest;
import com.volcengine.model.stream.RefreshTipsResponse;
import com.volcengine.model.stream.RelatedArticleRequest;
import com.volcengine.model.stream.RelatedArticleResponse;
import com.volcengine.model.stream.UnfollowRequest;
import com.volcengine.model.stream.UnfollowResponse;
import com.volcengine.model.stream.WapRegisterRequest;
import com.volcengine.model.stream.WapRegisterResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.stream.MonitorService;
import com.volcengine.service.stream.StreamConfig;
import com.volcengine.service.stream.StreamService;
import com.volcengine.service.stream.impl.MonitorServiceImpl;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpHost;

public class StreamServiceImpl
extends BaseServiceImpl
implements StreamService {
    static HttpHost Mproxy;
    boolean needMonitor = true;
    private static volatile StreamServiceImpl instance;

    private StreamServiceImpl() {
        super(StreamConfig.serviceInfo, StreamConfig.apiInfoList);
    }

    private StreamServiceImpl(HttpHost proxy) {
        super(StreamConfig.serviceInfo, proxy, StreamConfig.apiInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StreamService getInstance() {
        if (instance != null) return instance;
        Class<StreamServiceImpl> clazz = StreamServiceImpl.class;
        synchronized (StreamServiceImpl.class) {
            if (instance != null) return instance;
            instance = new StreamServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StreamService getInstance(HttpHost proxy) {
        if (instance != null) return instance;
        Class<StreamServiceImpl> clazz = StreamServiceImpl.class;
        synchronized (StreamServiceImpl.class) {
            if (instance != null) return instance;
            instance = new StreamServiceImpl(proxy);
            Mproxy = proxy;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void SetNeedMonitor(boolean open) {
        this.needMonitor = open;
    }

    @Override
    public WapRegisterResponse wapRegister(WapRegisterRequest wapRegisterRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("WapRegister", Utils.mapToPairList(Utils.paramsToMap(wapRegisterRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, wapRegisterRequest.getPartner(), "", "", "WapRegister", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (WapRegisterResponse)JSON.parseObject((byte[])response.getData(), WapRegisterResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetListResponse getList(GetListRequest getListRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("ContentStream", Utils.mapToPairList(Utils.paramsToMap(getListRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, getListRequest.getPartner(), getListRequest.getCategory(), getListRequest.getAccessToken(), "ContentStream", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetListResponse)JSON.parseObject((byte[])response.getData(), GetListResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DiggResponse digg(DiggRequest diggRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("Digg", Utils.mapToPairList(Utils.paramsToMap(diggRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, diggRequest.getPartner(), "", diggRequest.getAccessToken(), "Digg", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DiggResponse)JSON.parseObject((byte[])response.getData(), DiggResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DiggResponse bury(DiggRequest diggRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("Bury", Utils.mapToPairList(Utils.paramsToMap(diggRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, diggRequest.getPartner(), "", diggRequest.getAccessToken(), "Bury", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DiggResponse)JSON.parseObject((byte[])response.getData(), DiggResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DiggResponse unDigg(DiggRequest diggRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("UnDigg", Utils.mapToPairList(Utils.paramsToMap(diggRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, diggRequest.getPartner(), "", diggRequest.getAccessToken(), "UnDigg", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DiggResponse)JSON.parseObject((byte[])response.getData(), DiggResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DiggResponse unBury(DiggRequest diggRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("UnBury", Utils.mapToPairList(Utils.paramsToMap(diggRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, diggRequest.getPartner(), "", diggRequest.getAccessToken(), "UnBury", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DiggResponse)JSON.parseObject((byte[])response.getData(), DiggResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetArticleResponse getArticle(GetArticleRequest getArticleRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("SingleArticleInfo", Utils.mapToPairList(Utils.paramsToMap(getArticleRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, getArticleRequest.getPartner(), "", getArticleRequest.getAccessToken(), "SingleArticleInfo", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetArticleResponse)JSON.parseObject((byte[])response.getData(), GetArticleResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetArticlesResponse getArticles(GetArticlesRequest getArticlesRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("MultiArticleInfo", Utils.mapToPairList(Utils.paramsToMap(getArticlesRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, getArticlesRequest.getPartner(), "", getArticlesRequest.getAccessToken(), "MultiArticleInfo", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        String jsonString = new String(response.getData());
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        GetArticlesResponse getArticlesResponse = new GetArticlesResponse();
        ArrayList<GetArticleResponse.Result> articleList = new ArrayList<GetArticleResponse.Result>();
        JSONObject result1 = jsonObject.getJSONObject("Result");
        JSONObject responseMetadataJson = jsonObject.getJSONObject("ResponseMetadata");
        CommonPo.ResponseMetadata responseMetadata = (CommonPo.ResponseMetadata)JSONObject.toJavaObject((JSON)responseMetadataJson, CommonPo.ResponseMetadata.class);
        getArticlesResponse.setResponseMetadata(responseMetadata);
        if (result1 == null) {
            return getArticlesResponse;
        }
        for (Map.Entry entry : result1.entrySet()) {
            GetArticleResponse.Result articleInfo = (GetArticleResponse.Result)JSONObject.toJavaObject((JSON)((JSONObject)entry.getValue()), GetArticleResponse.Result.class);
            articleInfo.setGroupId((String)entry.getKey());
            articleList.add(articleInfo);
        }
        GetArticlesResponse.Result result = new GetArticlesResponse.Result();
        result.setArticleInfos(articleList);
        getArticlesResponse.setResult(result);
        return getArticlesResponse;
    }

    @Override
    public FeedBackResponse feedBack(FeedBackRequest feedBackRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("Feedback", Utils.mapToPairList(Utils.paramsToMap(feedBackRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, feedBackRequest.getPartner(), "", feedBackRequest.getAccessToken(), "Feedback", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (FeedBackResponse)JSON.parseObject((byte[])response.getData(), FeedBackResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public FollowResponse follow(FollowRequest followRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("Follow", Utils.mapToPairList(Utils.paramsToMap(followRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, followRequest.getPartner(), "", followRequest.getAccessToken(), "Follow", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (FollowResponse)JSON.parseObject((byte[])response.getData(), FollowResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public UnfollowResponse unfollow(UnfollowRequest unfollowRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("Unfollow", Utils.mapToPairList(Utils.paramsToMap(unfollowRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, unfollowRequest.getPartner(), "", unfollowRequest.getAccessToken(), "Unfollow", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (UnfollowResponse)JSON.parseObject((byte[])response.getData(), UnfollowResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CheckRelationResponse checkRelation(CheckRelationRequest checkRelationRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("CheckRelation", Utils.mapToPairList(Utils.paramsToMap(checkRelationRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, checkRelationRequest.getPartner(), "", checkRelationRequest.getAccessToken(), "CheckRelation", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CheckRelationResponse)JSON.parseObject((byte[])response.getData(), CheckRelationResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetFollowingListResponse getFollowingList(GetFollowingListRequest getFollowingListRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("FollowingList", Utils.mapToPairList(Utils.paramsToMap(getFollowingListRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, getFollowingListRequest.getPartner(), "", getFollowingListRequest.getAccessToken(), "FollowingList", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetFollowingListResponse)JSON.parseObject((byte[])response.getData(), GetFollowingListResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RefreshTipsResponse refreshTips(RefreshTipsRequest refreshTipsRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("RefreshTips", Utils.mapToPairList(Utils.paramsToMap(refreshTipsRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, refreshTipsRequest.getPartner(), "", refreshTipsRequest.getAccessToken(), "RefreshTips", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RefreshTipsResponse)JSON.parseObject((byte[])response.getData(), RefreshTipsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public FollowArticlesResponse getFollowArticles(FollowArticlesRequest followArticlesRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("FollowArticles", Utils.mapToPairList(Utils.paramsToMap(followArticlesRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, followArticlesRequest.getPartner(), "", followArticlesRequest.getAccessToken(), "FollowArticles", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (FollowArticlesResponse)JSON.parseObject((byte[])response.getData(), FollowArticlesResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RecommendRelatedUserResponse recommendRelatedUser(RecommendRelatedUserRequest recommendRelatedUserRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("RecommendRelatedUser", Utils.mapToPairList(Utils.paramsToMap(recommendRelatedUserRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, recommendRelatedUserRequest.getPartner(), "", recommendRelatedUserRequest.getAccessToken(), "RecommendRelatedUser", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RecommendRelatedUserResponse)JSON.parseObject((byte[])response.getData(), RecommendRelatedUserResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RecommendCategoryUserResponse recommendCategoryUser(RecommendCategoryUserRequest recommendCategoryUserRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("RecommendCategoryUser", Utils.mapToPairList(Utils.paramsToMap(recommendCategoryUserRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, recommendCategoryUserRequest.getPartner(), "", recommendCategoryUserRequest.getAccessToken(), "RecommendCategoryUser", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RecommendCategoryUserResponse)JSON.parseObject((byte[])response.getData(), RecommendCategoryUserResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RecommendCategoryInfoResponse recommendCategoryInfo(RecommendCategoryInfoRequest recommendCategoryInfoRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("RecommendCategoryInfo", Utils.mapToPairList(Utils.paramsToMap(recommendCategoryInfoRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, recommendCategoryInfoRequest.getPartner(), "", recommendCategoryInfoRequest.getAccessToken(), "RecommendCategoryInfo", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RecommendCategoryInfoResponse)JSON.parseObject((byte[])response.getData(), RecommendCategoryInfoResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RelatedArticleResponse relatedArticle(RelatedArticleRequest relatedArticleRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("RelatedArticle", Utils.mapToPairList(Utils.paramsToMap(relatedArticleRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, relatedArticleRequest.getPartner(), "", relatedArticleRequest.getAccessToken(), "RelatedArticle", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RelatedArticleResponse)JSON.parseObject((byte[])response.getData(), RelatedArticleResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetDiggListResponse getDiggList(GetDiggListRequest getDiggListRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("DiggList", Utils.mapToPairList(Utils.paramsToMap(getDiggListRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, getDiggListRequest.getPartner(), "", getDiggListRequest.getAccessToken(), "DiggList", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetDiggListResponse)JSON.parseObject((byte[])response.getData(), GetDiggListResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetVideoUrlResponse getVideoUrl(GetVideoUrlRequest getVideoUrlRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("VideoUrl", Utils.mapToPairList(Utils.paramsToMap(getVideoUrlRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, getVideoUrlRequest.getPartner(), "", getVideoUrlRequest.getAccessToken(), "VideoUrl", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        String jsonString = new String(response.getData());
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        GetVideoUrlResponse getVideoUrlResponse = new GetVideoUrlResponse();
        JSONObject result1 = jsonObject.getJSONObject("Result");
        JSONObject responseMetadataJson = jsonObject.getJSONObject("ResponseMetadata");
        CommonPo.ResponseMetadata responseMetadata = (CommonPo.ResponseMetadata)JSONObject.toJavaObject((JSON)responseMetadataJson, CommonPo.ResponseMetadata.class);
        getVideoUrlResponse.setResponseMetadata(responseMetadata);
        if (result1 == null) {
            return getVideoUrlResponse;
        }
        JSONObject resultData = result1.getJSONObject("data");
        GetVideoUrlResponse.Result videoUrlResult = (GetVideoUrlResponse.Result)JSONObject.toJavaObject((JSON)resultData, GetVideoUrlResponse.Result.class);
        getVideoUrlResponse.setResult(videoUrlResult);
        return getVideoUrlResponse;
    }

    @Override
    public GetUnionProductResponse getUnionProduct(GetUnionProductRequest getUnionProductRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("UnionProduct", Utils.mapToPairList(Utils.paramsToMap(getUnionProductRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, getUnionProductRequest.getPartner(), "", getUnionProductRequest.getAccessToken(), "UnionProduct", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetUnionProductResponse)JSON.parseObject((byte[])response.getData(), GetUnionProductResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public HotBoardResponse hotBoard(HotBoardRequest hotBoardRequest) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("HotBoard", Utils.mapToPairList(Utils.paramsToMap(hotBoardRequest)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, hotBoardRequest.getPartner(), "", hotBoardRequest.getAccessToken(), "HotBoard", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (HotBoardResponse)JSON.parseObject((byte[])response.getData(), HotBoardResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public HotBoardListResponse hotBoardList(HotBoardListRequest hotBoardListRequest) throws Exception {
        long start = System.currentTimeMillis();
        HotBoardBaseRequest request = HotBoardBaseRequest.builder().accessToken(hotBoardListRequest.getAccessToken()).partner(hotBoardListRequest.getPartner()).timestamp(hotBoardListRequest.getTimestamp()).biz("list").build();
        RawResponse response = this.query("HotBoard", Utils.mapToPairList(Utils.paramsToMap(request)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, hotBoardListRequest.getPartner(), "", hotBoardListRequest.getAccessToken(), "HotBoard", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (HotBoardListResponse)JSON.parseObject((byte[])response.getData(), HotBoardListResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public HotBoardBoardResponse hotBoardBoard(HotBoardBoardRequest hotBoardBoardRequest) throws Exception {
        long start = System.currentTimeMillis();
        HotBoardBaseRequest request = HotBoardBaseRequest.builder().accessToken(hotBoardBoardRequest.getAccessToken()).partner(hotBoardBoardRequest.getPartner()).timestamp(hotBoardBoardRequest.getTimestamp()).hotBoardGid(hotBoardBoardRequest.getHotBoardGid()).biz("board").build();
        RawResponse response = this.query("HotBoard", Utils.mapToPairList(Utils.paramsToMap(request)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, hotBoardBoardRequest.getPartner(), "", hotBoardBoardRequest.getAccessToken(), "HotBoard", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (HotBoardBoardResponse)JSON.parseObject((byte[])response.getData(), HotBoardBoardResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public HotBoardArticleResponse hotBoardArticle(HotBoardArticleRequest hotBoardArticleRequest) throws Exception {
        long start = System.currentTimeMillis();
        HotBoardBaseRequest request = HotBoardBaseRequest.builder().accessToken(hotBoardArticleRequest.getAccessToken()).partner(hotBoardArticleRequest.getPartner()).timestamp(hotBoardArticleRequest.getTimestamp()).offset(hotBoardArticleRequest.getOffset()).limit(hotBoardArticleRequest.getLimit()).hotBoardGid(hotBoardArticleRequest.getHotBoardGid()).collectionID(hotBoardArticleRequest.getCollectionID()).from(hotBoardArticleRequest.getFrom()).biz("article").build();
        RawResponse response = this.query("HotBoard", Utils.mapToPairList(Utils.paramsToMap(request)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, hotBoardArticleRequest.getPartner(), "", hotBoardArticleRequest.getAccessToken(), "HotBoard", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (HotBoardArticleResponse)JSON.parseObject((byte[])response.getData(), HotBoardArticleResponse.class, (Feature[])new Feature[0]);
    }

    private void sendToMonitor(StreamService streamService, String partner, String category, String accessToken, String action, int httpCode, int topRespCode, byte[] respData, long latency) {
        if (this.needMonitor) {
            MonitorService monitorService = MonitorServiceImpl.getInstance(streamService.getAccessKey(), streamService.getSecretKey(), Mproxy);
            monitorService.monitor(partner, category, accessToken, action, httpCode, topRespCode, respData, latency);
        }
    }

    static {
        instance = null;
    }
}

