/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.interceptor;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang.RandomStringUtils;

public class RequestIdInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder requestBuilder = chain.request().newBuilder();
        if (chain.request().header("X-Client-Request-Id") == null || chain.request().header("X-Client-Request-Id").length() == 0) {
            requestBuilder = requestBuilder.header("X-Client-Request-Id", this.genRequestId());
        }
        Request request = requestBuilder.build();
        return chain.proceed(request);
    }

    private String genRequestId() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        return dateFormat.format(date) + RandomStringUtils.randomAlphanumeric((int)20);
    }
}

