/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.interceptor;

import java.io.IOException;
import java.io.InterruptedIOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RetryInterceptor
implements Interceptor {
    private final int retryTimes;
    private final double INITIAL_RETRY_DELAY = 0.5;
    private final double MAX_RETRY_DELAY = 8.0;

    public RetryInterceptor(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        for (int tryCount = 0; (response.code() >= 500 || response.code() == 429) && tryCount < this.retryTimes; ++tryCount) {
            response.close();
            try {
                double interval = this.retryInterval(this.retryTimes, this.retryTimes - tryCount) * 1000.0;
                Thread.sleep(Math.round(interval));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
            response = chain.proceed(request);
        }
        return response;
    }

    public double retryInterval(int max, int remain) {
        int nbRetries = max - remain;
        double sleepSeconds = Math.min(0.5 * Math.pow(2.0, nbRetries), 8.0);
        double jitter = 1.0 - 0.25 * Math.random();
        return sleepSeconds * jitter;
    }
}

