/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.volcengine.ark.runtime.exception.ArkAPIError;
import com.volcengine.ark.runtime.exception.ArkException;
import com.volcengine.ark.runtime.exception.ArkHttpException;
import com.volcengine.ark.runtime.interceptor.ArkResourceStsAuthenticationInterceptor;
import com.volcengine.ark.runtime.interceptor.AuthenticationInterceptor;
import com.volcengine.ark.runtime.interceptor.RequestIdInterceptor;
import com.volcengine.ark.runtime.interceptor.RetryInterceptor;
import com.volcengine.ark.runtime.model.bot.completion.chat.BotChatCompletionChunk;
import com.volcengine.ark.runtime.model.bot.completion.chat.BotChatCompletionRequest;
import com.volcengine.ark.runtime.model.bot.completion.chat.BotChatCompletionResult;
import com.volcengine.ark.runtime.model.completion.chat.ChatCompletionChunk;
import com.volcengine.ark.runtime.model.completion.chat.ChatCompletionRequest;
import com.volcengine.ark.runtime.model.completion.chat.ChatCompletionResult;
import com.volcengine.ark.runtime.model.embeddings.EmbeddingRequest;
import com.volcengine.ark.runtime.model.embeddings.EmbeddingResult;
import com.volcengine.ark.runtime.model.tokenization.TokenizationRequest;
import com.volcengine.ark.runtime.model.tokenization.TokenizationResult;
import com.volcengine.ark.runtime.service.ArkApi;
import com.volcengine.ark.runtime.service.ArkBaseService;
import com.volcengine.ark.runtime.service.ArkBaseServiceImpl;
import com.volcengine.ark.runtime.utils.ResponseBodyCallback;
import com.volcengine.ark.runtime.utils.SSE;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Single;
import java.io.IOException;
import java.net.Proxy;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class ArkService
extends ArkBaseService
implements ArkBaseServiceImpl {
    private static final ObjectMapper mapper = ArkService.defaultObjectMapper();
    private final ArkApi api;
    private final ExecutorService executorService;

    public ArkService(String apiKey) {
        this(apiKey, DEFAULT_TIMEOUT);
    }

    public ArkService(String apiKey, Duration timeout) {
        ObjectMapper mapper = ArkService.defaultObjectMapper();
        OkHttpClient client = ArkService.defaultApiKeyClient(apiKey, timeout);
        Retrofit retrofit = ArkService.defaultRetrofit(client, mapper, "https://ark.cn-beijing.volces.com");
        this.api = (ArkApi)retrofit.create(ArkApi.class);
        this.executorService = client.dispatcher().executorService();
    }

    public ArkService(String ak, String sk) {
        this(ak, sk, DEFAULT_TIMEOUT);
    }

    public ArkService(String ak, String sk, Duration timeout) {
        ObjectMapper mapper = ArkService.defaultObjectMapper();
        OkHttpClient client = ArkService.defaultResourceStsClient(ak, sk, timeout, "cn-beijing");
        Retrofit retrofit = ArkService.defaultRetrofit(client, mapper, "https://ark.cn-beijing.volces.com");
        this.api = (ArkApi)retrofit.create(ArkApi.class);
        this.executorService = client.dispatcher().executorService();
    }

    public ArkService(ArkApi api) {
        this.api = api;
        this.executorService = null;
    }

    public ArkService(ArkApi api, ExecutorService executorService) {
        this.api = api;
        this.executorService = executorService;
    }

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        return mapper;
    }

    public static OkHttpClient defaultApiKeyClient(String apiKey, Duration timeout) {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthenticationInterceptor(apiKey)).addInterceptor((Interceptor)new RequestIdInterceptor()).connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).build();
    }

    public static OkHttpClient defaultResourceStsClient(String ak, String sk, Duration timeout, String region) {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new ArkResourceStsAuthenticationInterceptor(ak, sk, region)).addInterceptor((Interceptor)new RequestIdInterceptor()).connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).build();
    }

    public static Retrofit defaultRetrofit(OkHttpClient client, ObjectMapper mapper, String baseUrl) {
        return new Retrofit.Builder().baseUrl(baseUrl).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
    }

    public static <T> T execute(Single<T> apiCall) {
        try {
            Object resp = apiCall.blockingGet();
            return (T)resp;
        }
        catch (HttpException e) {
            String requestId = "";
            try {
                Headers headers = e.response().raw().request().headers();
                requestId = headers.get("X-Client-Request-Id");
            }
            catch (Exception headers) {
                // empty catch block
            }
            try {
                if (e.response() == null || e.response().errorBody() == null) {
                    throw e;
                }
                String errorBody = e.response().errorBody().string();
                ArkAPIError error = (ArkAPIError)mapper.readValue(errorBody, ArkAPIError.class);
                throw new ArkHttpException(error, (Exception)((Object)e), e.code(), requestId);
            }
            catch (IOException ex) {
                throw e;
            }
        }
    }

    public static Flowable<SSE> stream(Call<ResponseBody> apiCall) {
        return ArkService.stream(apiCall, false);
    }

    public static Flowable<SSE> stream(Call<ResponseBody> apiCall, boolean emitDone) {
        return Flowable.create(emitter -> apiCall.enqueue((Callback)new ResponseBodyCallback((FlowableEmitter<SSE>)emitter, emitDone)), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    public static <T> Flowable<T> stream(Call<ResponseBody> apiCall, Class<T> cl) {
        return ArkService.stream(apiCall).map(sse -> mapper.readValue(sse.getData(), cl));
    }

    @Override
    public ChatCompletionResult createChatCompletion(ChatCompletionRequest request) {
        return ArkService.execute(this.api.createChatCompletion(request, request.getModel(), new HashMap<String, String>()));
    }

    public ChatCompletionResult createChatCompletion(ChatCompletionRequest request, Map<String, String> customHeaders) {
        return ArkService.execute(this.api.createChatCompletion(request, request.getModel(), customHeaders));
    }

    @Override
    public Flowable<ChatCompletionChunk> streamChatCompletion(ChatCompletionRequest request) {
        request.setStream(true);
        return ArkService.stream(this.api.createChatCompletionStream(request, request.getModel(), new HashMap<String, String>()), ChatCompletionChunk.class);
    }

    public Flowable<ChatCompletionChunk> streamChatCompletion(ChatCompletionRequest request, Map<String, String> customHeaders) {
        request.setStream(true);
        return ArkService.stream(this.api.createChatCompletionStream(request, request.getModel(), customHeaders), ChatCompletionChunk.class);
    }

    @Override
    public EmbeddingResult createEmbeddings(EmbeddingRequest request) {
        return ArkService.execute(this.api.createEmbeddings(request, request.getModel(), new HashMap<String, String>()));
    }

    public EmbeddingResult createEmbeddings(EmbeddingRequest request, Map<String, String> customHeaders) {
        return ArkService.execute(this.api.createEmbeddings(request, request.getModel(), customHeaders));
    }

    @Override
    public BotChatCompletionResult createBotChatCompletion(BotChatCompletionRequest request) {
        return ArkService.execute(this.api.createBotChatCompletion(request, request.getModel(), new HashMap<String, String>()));
    }

    public BotChatCompletionResult createBotChatCompletion(BotChatCompletionRequest request, Map<String, String> customHeaders) {
        return ArkService.execute(this.api.createBotChatCompletion(request, request.getModel(), customHeaders));
    }

    @Override
    public Flowable<BotChatCompletionChunk> streamBotChatCompletion(BotChatCompletionRequest request) {
        request.setStream(true);
        return ArkService.stream(this.api.createBotChatCompletionStream(request, request.getModel(), new HashMap<String, String>()), BotChatCompletionChunk.class);
    }

    public Flowable<BotChatCompletionChunk> streamBotChatCompletion(BotChatCompletionRequest request, Map<String, String> customHeaders) {
        request.setStream(true);
        return ArkService.stream(this.api.createBotChatCompletionStream(request, request.getModel(), customHeaders), BotChatCompletionChunk.class);
    }

    @Override
    public TokenizationResult createTokenization(TokenizationRequest request) {
        return ArkService.execute(this.api.createTokenization(request, request.getModel(), new HashMap<String, String>()));
    }

    public TokenizationResult createTokenization(TokenizationRequest request, Map<String, String> customHeaders) {
        return ArkService.execute(this.api.createTokenization(request, request.getModel(), customHeaders));
    }

    public void shutdownExecutor() {
        Objects.requireNonNull(this.executorService, "executorService must be set in order to shut down");
        this.executorService.shutdown();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String ak;
        private String sk;
        private String apiKey;
        private String region = "cn-beijing";
        private String baseUrl = "https://ark.cn-beijing.volces.com";
        private Duration timeout = ArkBaseService.DEFAULT_TIMEOUT;
        private Duration connectTimeout = ArkBaseService.DEFAULT_CONNECT_TIMEOUT;
        private int retryTimes = 0;
        private Proxy proxy;
        private ConnectionPool connectionPool;
        private Dispatcher dispatcher;

        public Builder ak(String ak) {
            this.ak = ak;
            return this;
        }

        public Builder sk(String sk) {
            this.sk = sk;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            if (!baseUrl.endsWith("/")) {
                this.baseUrl = baseUrl + "/";
            }
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder retryTimes(int retryTimes) {
            this.retryTimes = retryTimes;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder connectionPool(ConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
            return this;
        }

        public Builder dispatcher(Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        public ArkService build() {
            ObjectMapper mapper = ArkService.defaultObjectMapper();
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            if (this.apiKey != null && this.apiKey.length() > 0) {
                clientBuilder.addInterceptor((Interceptor)new AuthenticationInterceptor(this.apiKey));
            } else if (this.ak != null && this.sk != null && this.ak.length() > 0 && this.sk.length() > 0) {
                clientBuilder.addInterceptor((Interceptor)new ArkResourceStsAuthenticationInterceptor(this.ak, this.sk, this.region));
            } else {
                throw new ArkException("missing api_key or ak&sk.");
            }
            if (this.proxy != null) {
                clientBuilder.proxy(this.proxy);
            }
            if (this.connectionPool != null) {
                clientBuilder.connectionPool(this.connectionPool);
            } else {
                clientBuilder.connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS));
            }
            if (this.dispatcher != null) {
                clientBuilder.dispatcher(this.dispatcher);
            }
            OkHttpClient client = clientBuilder.addInterceptor((Interceptor)new RequestIdInterceptor()).addInterceptor((Interceptor)new RetryInterceptor(this.retryTimes)).readTimeout(this.timeout.toMillis(), TimeUnit.MILLISECONDS).connectTimeout(this.connectTimeout).build();
            Retrofit retrofit = ArkService.defaultRetrofit(client, mapper, this.baseUrl);
            return new ArkService((ArkApi)retrofit.create(ArkApi.class), client.dispatcher().executorService());
        }
    }
}

