/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.model.content.generation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CreateContentGenerationTaskRequest {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="content")
    private List<Content> content;

    public CreateContentGenerationTaskRequest() {
    }

    public CreateContentGenerationTaskRequest(String model, List<Content> content) {
        this.model = model;
        this.content = content;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public List<Content> getContent() {
        return this.content;
    }

    public void setContent(List<Content> content) {
        this.content = content;
    }

    public String toString() {
        return "CreateContentGenerationTaskRequest{model='" + this.model + '\'' + ", content=" + this.content + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ImageUrl {
        @JsonProperty(value="url")
        private String url;

        public ImageUrl() {
        }

        public ImageUrl(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String toString() {
            return "ImageUrl{url='" + this.url + '\'' + '}';
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String url;

            private Builder() {
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public ImageUrl build() {
                ImageUrl imageUrl = new ImageUrl();
                imageUrl.setUrl(this.url);
                return imageUrl;
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Content {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="text")
        private String text;
        @JsonProperty(value="image_url")
        private ImageUrl imageUrl;

        public Content() {
        }

        public Content(String type, String text, ImageUrl imageUrl) {
            this.type = type;
            this.text = text;
            this.imageUrl = imageUrl;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public ImageUrl getImageUrl() {
            return this.imageUrl;
        }

        public void setImageUrl(ImageUrl imageUrl) {
            this.imageUrl = imageUrl;
        }

        public String toString() {
            return "Content{type='" + this.type + '\'' + ", text='" + this.text + '\'' + ", imageUrl=" + this.imageUrl + '}';
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String type;
            private String text;
            private ImageUrl imageUrl;

            private Builder() {
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            public Builder imageUrl(ImageUrl imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public Content build() {
                Content content = new Content();
                content.setType(this.type);
                content.setText(this.text);
                content.setImageUrl(this.imageUrl);
                return content;
            }
        }
    }

    public static class Builder {
        private String model;
        private List<Content> content;

        private Builder() {
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder content(List<Content> content) {
            this.content = content;
            return this;
        }

        public CreateContentGenerationTaskRequest build() {
            CreateContentGenerationTaskRequest createContentGenerationTaskRequest = new CreateContentGenerationTaskRequest();
            createContentGenerationTaskRequest.setModel(this.model);
            createContentGenerationTaskRequest.setContent(this.content);
            return createContentGenerationTaskRequest;
        }
    }
}

