/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.model.completion.chat;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.volcengine.ark.runtime.model.completion.chat.ChatMessage;
import com.volcengine.ark.runtime.model.completion.chat.ChatTool;
import com.volcengine.ark.runtime.utils.JacksonUtil;
import java.util.List;
import java.util.Map;

public class ChatCompletionRequest {
    String model;
    List<ChatMessage> messages;
    Double temperature;
    @JsonProperty(value="top_p")
    Double topP;
    Boolean stream;
    @JsonProperty(value="stream_options")
    ChatCompletionRequestStreamOptions streamOptions;
    @JsonProperty(value="service_tier")
    String serviceTier;
    List<String> stop;
    @JsonProperty(value="max_tokens")
    Integer maxTokens;
    @JsonProperty(value="presence_penalty")
    Double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    Double frequencyPenalty;
    @JsonProperty(value="logit_bias")
    Map<String, Integer> logitBias;
    String user;
    List<ChatTool> tools;
    @JsonProperty(value="function_call")
    ChatCompletionRequestFunctionCall functionCall;
    Boolean logprobs;
    @JsonProperty(value="top_logprobs")
    Integer topLogprobs;
    @JsonProperty(value="repetition_penalty")
    Double repetitionPenalty;
    Integer n;
    Boolean parallelToolCalls;
    @JsonProperty(value="tool_choice")
    Object toolChoice;
    @JsonProperty(value="response_format")
    ChatCompletionRequestResponseFormat responseFormat;
    @JsonProperty(value="thinking")
    ChatCompletionRequestThinking thinking;

    public String toString() {
        return "ChatCompletionRequest{model='" + this.model + '\'' + ", messages=" + this.messages + ", temperature=" + this.temperature + ", topP=" + this.topP + ", stream=" + this.stream + ", streamOptions=" + this.streamOptions + ", serviceTier='" + this.serviceTier + '\'' + ", stop=" + this.stop + ", maxTokens=" + this.maxTokens + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", user='" + this.user + '\'' + ", tools=" + this.tools + ", functionCall=" + this.functionCall + ", logprobs=" + this.logprobs + ", topLogprobs=" + this.topLogprobs + ", repetitionPenalty=" + this.repetitionPenalty + ", n=" + this.n + ", parallelToolCalls=" + this.parallelToolCalls + ", toolChoice=" + this.toolChoice + ", responseFormat=" + this.responseFormat + ", thinking=" + this.thinking + '}';
    }

    public ChatCompletionRequestThinking getThinking() {
        return this.thinking;
    }

    public void setThinking(ChatCompletionRequestThinking thinking) {
        this.thinking = thinking;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<ChatMessage> messages) {
        this.messages = messages;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public ChatCompletionRequestStreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    public void setStreamOptions(ChatCompletionRequestStreamOptions streamOptions) {
        this.streamOptions = streamOptions;
    }

    public String getServiceTier() {
        return this.serviceTier;
    }

    public void setServiceTier(String serviceTier) {
        this.serviceTier = serviceTier;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public void setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public List<ChatTool> getTools() {
        return this.tools;
    }

    public void setTools(List<ChatTool> tools) {
        this.tools = tools;
    }

    public ChatCompletionRequestFunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public void setFunctionCall(ChatCompletionRequestFunctionCall functionCall) {
        this.functionCall = functionCall;
    }

    public Boolean getLogprobs() {
        return this.logprobs;
    }

    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public void setTopLogprobs(Integer topLogprobs) {
        this.topLogprobs = topLogprobs;
    }

    public Double getRepetitionPenalty() {
        return this.repetitionPenalty;
    }

    public void setRepetitionPenalty(Double repetitionPenalty) {
        this.repetitionPenalty = repetitionPenalty;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public void setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(Object toolChoice) {
        this.toolChoice = toolChoice;
    }

    public ChatCompletionRequestResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(ChatCompletionRequestResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String model;
        private List<ChatMessage> messages;
        private Double temperature;
        private Double topP;
        private Boolean stream;
        private ChatCompletionRequestStreamOptions streamOptions;
        private String serviceTier;
        private List<String> stop;
        private Integer maxTokens;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Map<String, Integer> logitBias;
        private String user;
        private List<ChatTool> tools;
        private ChatCompletionRequestFunctionCall functionCall;
        private Boolean logprobs;
        private Integer topLogprobs;
        private Double repetitionPenalty;
        private Integer n;
        private Boolean parallelToolCalls;
        private Object toolChoice;
        private ChatCompletionRequestResponseFormat responseFormat;
        private ChatCompletionRequestThinking thinking;

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder messages(List<ChatMessage> messages) {
            this.messages = messages;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder streamOptions(ChatCompletionRequestStreamOptions streamOptions) {
            this.streamOptions = streamOptions;
            return this;
        }

        public Builder serviceTier(String serviceTier) {
            this.serviceTier = serviceTier;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder tools(List<ChatTool> tools) {
            this.tools = tools;
            return this;
        }

        public Builder functionCall(ChatCompletionRequestFunctionCall functionCall) {
            this.functionCall = functionCall;
            return this;
        }

        public Builder logprobs(Boolean logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public Builder topLogprobs(Integer topLogprobs) {
            this.topLogprobs = topLogprobs;
            return this;
        }

        public Builder repetitionPenalty(Double repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public Builder n(Integer n) {
            this.n = n;
            return this;
        }

        public Builder parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls = parallelToolCalls;
            return this;
        }

        public Builder toolChoice(String toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public Builder toolChoice(ChatCompletionRequestToolChoice toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public Builder responseFormat(ChatCompletionRequestResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder thinking(ChatCompletionRequestThinking thinking) {
            this.thinking = thinking;
            return this;
        }

        public ChatCompletionRequest build() {
            ChatCompletionRequest chatCompletionRequest = new ChatCompletionRequest();
            chatCompletionRequest.setModel(this.model);
            chatCompletionRequest.setMessages(this.messages);
            chatCompletionRequest.setTemperature(this.temperature);
            chatCompletionRequest.setTopP(this.topP);
            chatCompletionRequest.setStream(this.stream);
            chatCompletionRequest.setStreamOptions(this.streamOptions);
            chatCompletionRequest.setServiceTier(this.serviceTier);
            chatCompletionRequest.setStop(this.stop);
            chatCompletionRequest.setMaxTokens(this.maxTokens);
            chatCompletionRequest.setPresencePenalty(this.presencePenalty);
            chatCompletionRequest.setFrequencyPenalty(this.frequencyPenalty);
            chatCompletionRequest.setLogitBias(this.logitBias);
            chatCompletionRequest.setUser(this.user);
            chatCompletionRequest.setTools(this.tools);
            chatCompletionRequest.setFunctionCall(this.functionCall);
            chatCompletionRequest.setLogprobs(this.logprobs);
            chatCompletionRequest.setTopLogprobs(this.topLogprobs);
            chatCompletionRequest.setRepetitionPenalty(this.repetitionPenalty);
            chatCompletionRequest.setN(this.n);
            chatCompletionRequest.setParallelToolCalls(this.parallelToolCalls);
            chatCompletionRequest.setToolChoice(this.toolChoice);
            chatCompletionRequest.setResponseFormat(this.responseFormat);
            chatCompletionRequest.setThinking(this.thinking);
            return chatCompletionRequest;
        }
    }

    public static class ChatCompletionRequestToolChoiceFunction {
        String name;

        public ChatCompletionRequestToolChoiceFunction(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class ChatCompletionRequestThinking {
        String type;

        public ChatCompletionRequestThinking(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class ChatCompletionRequestToolChoice {
        String type;
        ChatCompletionRequestToolChoiceFunction function;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public ChatCompletionRequestToolChoiceFunction getFunction() {
            return this.function;
        }

        public void setFunction(ChatCompletionRequestToolChoiceFunction function) {
            this.function = function;
        }

        public ChatCompletionRequestToolChoice(String type, ChatCompletionRequestToolChoiceFunction function) {
            this.type = type;
            this.function = function;
        }
    }

    public static class ChatCompletionRequestResponseFormat {
        String type;
        JsonNode schema;

        public ChatCompletionRequestResponseFormat(String type) {
            this.type = type;
        }

        public ChatCompletionRequestResponseFormat(String type, Object schema) {
            this.type = type;
            this.schema = JacksonUtil.clsToJsonNode(schema);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public JsonNode getSchema() {
            return this.schema;
        }

        public void setSchema(JsonNode schema) {
            this.schema = schema;
        }
    }

    public static class ChatCompletionRequestStreamOptions {
        @JsonProperty(value="include_usage")
        Boolean includeUsage;
        @JsonProperty(value="chunk_include_usage")
        Boolean chunkIncludeUsage;

        public ChatCompletionRequestStreamOptions(Boolean includeUsage) {
            this.includeUsage = includeUsage;
        }

        public ChatCompletionRequestStreamOptions(Boolean includeUsage, Boolean chunkIncludeUsage) {
            this.includeUsage = includeUsage;
            this.chunkIncludeUsage = chunkIncludeUsage;
        }

        public static ChatCompletionRequestStreamOptions of(Boolean includeUsage) {
            return new ChatCompletionRequestStreamOptions(includeUsage);
        }

        public static ChatCompletionRequestStreamOptions of(Boolean includeUsage, Boolean chunkIncludeUsage) {
            return new ChatCompletionRequestStreamOptions(includeUsage, chunkIncludeUsage);
        }

        public Boolean getIncludeUsage() {
            return this.includeUsage;
        }

        public void setIncludeUsage(Boolean includeUsage) {
            this.includeUsage = includeUsage;
        }

        public Boolean getChunkIncludeUsage() {
            return this.chunkIncludeUsage;
        }

        public void setChunkIncludeUsage(Boolean chunkIncludeUsage) {
            this.chunkIncludeUsage = chunkIncludeUsage;
        }
    }

    public static class ChatCompletionRequestFunctionCall {
        String name;

        public ChatCompletionRequestFunctionCall(String name) {
            this.name = name;
        }

        public static ChatCompletionRequestFunctionCall of(String name) {
            return new ChatCompletionRequestFunctionCall(name);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

