/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.interceptor;

import com.volcengine.ark.runtime.utils.ModelBreaker;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class BatchInterceptor
implements Interceptor {
    private final ConcurrentHashMap<String, ModelBreaker> modelBreakerMap = new ConcurrentHashMap();

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        HttpUrl url = request.url();
        if (!url.encodedPath().startsWith("/api/v3/batch")) {
            return chain.proceed(request);
        }
        String endpoint = request.header("X-Request-Model");
        try {
            this.waitModelForRetryAfter(endpoint);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Response response = chain.proceed(chain.request());
        String retryAfter = response.header("Retry-After");
        if (retryAfter != null && !retryAfter.isEmpty()) {
            try {
                int delay = Integer.parseInt(retryAfter);
                this.setModelForRetryAfter(endpoint, Duration.ofSeconds(delay));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return response;
    }

    private void waitModelForRetryAfter(String model) throws InterruptedException {
        ModelBreaker breaker = this.getModelBreaker(model);
        while (!breaker.Allow()) {
            Duration duration = breaker.GetAllowedDuration();
            if (duration.getSeconds() <= 0L) continue;
            Thread.sleep(duration.toMillis());
        }
    }

    private void setModelForRetryAfter(String model, Duration duration) {
        ModelBreaker breaker = this.getModelBreaker(model);
        breaker.Reset(duration);
    }

    private ModelBreaker getModelBreaker(String model) {
        ModelBreaker breaker;
        if (this.modelBreakerMap.containsKey(model)) {
            breaker = this.modelBreakerMap.get(model);
        } else {
            breaker = new ModelBreaker();
            this.modelBreakerMap.put(model, breaker);
        }
        return breaker;
    }
}

