/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.model.responses.tool.mcp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MCPTool {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="input_schema")
    private Map<String, Object> inputSchema;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getInputSchema() {
        return this.inputSchema;
    }

    public void setInputSchema(Map<String, Object> inputSchema) {
        this.inputSchema = inputSchema;
    }

    public String toString() {
        return "MCPTool{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", inputSchema=" + this.inputSchema + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String description;
        private Map<String, Object> inputSchema;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder inputSchema(Map<String, Object> inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public MCPTool build() {
            MCPTool mCPTool = new MCPTool();
            mCPTool.setName(this.name);
            mCPTool.setDescription(this.description);
            mCPTool.setInputSchema(this.inputSchema);
            return mCPTool;
        }
    }
}

