/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.clb.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.volcengine.clb.model.TagForTagNLBResourcesInput;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class TagNLBResourcesRequest {
    @SerializedName(value="ResourceIds")
    private List<String> resourceIds = null;
    @SerializedName(value="ResourceType")
    private ResourceTypeEnum resourceType = null;
    @SerializedName(value="Tags")
    private List<TagForTagNLBResourcesInput> tags = null;

    public TagNLBResourcesRequest resourceIds(List<String> resourceIds) {
        this.resourceIds = resourceIds;
        return this;
    }

    public TagNLBResourcesRequest addResourceIdsItem(String resourceIdsItem) {
        if (this.resourceIds == null) {
            this.resourceIds = new ArrayList<String>();
        }
        this.resourceIds.add(resourceIdsItem);
        return this;
    }

    @Schema(description="")
    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(List<String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public TagNLBResourcesRequest resourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @NotNull
    @Schema(required=true, description="")
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public TagNLBResourcesRequest tags(List<TagForTagNLBResourcesInput> tags) {
        this.tags = tags;
        return this;
    }

    public TagNLBResourcesRequest addTagsItem(TagForTagNLBResourcesInput tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagForTagNLBResourcesInput>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Valid
    @Schema(description="")
    public List<TagForTagNLBResourcesInput> getTags() {
        return this.tags;
    }

    public void setTags(List<TagForTagNLBResourcesInput> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagNLBResourcesRequest tagNLBResourcesRequest = (TagNLBResourcesRequest)o;
        return Objects.equals(this.resourceIds, tagNLBResourcesRequest.resourceIds) && Objects.equals((Object)this.resourceType, (Object)tagNLBResourcesRequest.resourceType) && Objects.equals(this.tags, tagNLBResourcesRequest.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourceIds, this.resourceType, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TagNLBResourcesRequest {\n");
        sb.append("    resourceIds: ").append(this.toIndentedString(this.resourceIds)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResourceTypeEnum {
        NLB("nlb"),
        NLB_LISTENER("nlb_listener"),
        NLB_SERVERGROUP("nlb_servergroup"),
        NLB_SECURITY_POLICY("nlb_security_policy");

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResourceTypeEnum fromValue(String input) {
            for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ResourceTypeEnum> {
            public void write(JsonWriter jsonWriter, ResourceTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ResourceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResourceTypeEnum.fromValue(value);
            }
        }
    }
}

