/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.endpoint;

import com.volcengine.endpoint.EndpointResolver;
import com.volcengine.endpoint.ResolveEndpointOption;
import com.volcengine.endpoint.ResolvedEndpoint;
import java.util.HashMap;
import java.util.Map;

public class DefaultEndpointProvider
implements EndpointResolver {
    private static final String SEPARATOR = ".";
    private static final String OPEN_PREFIX = "open";
    private static final String ENDPOINT_SUFFIX = ".volcengineapi.com";
    public static final String REGION_CODE_CN_BEIJING_AUTODRIVING = "cn-beijing-autodriving";
    public static final String REGION_CODE_AP_SOUTH_EAST_3 = "ap-southeast-3";
    private static final String ENDPOINT = "open.volcengineapi.com";
    private static final Map<String, ServiceEndpointInfo> DEFAULT_ENDPOINT_MAP = new HashMap<String, ServiceEndpointInfo>();

    private static RegionEndpointMap createRegionEndpointMap(String ... keyValuePairs) {
        RegionEndpointMap map = new RegionEndpointMap();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            String regionCode = keyValuePairs[i];
            String servicePrefix = keyValuePairs[i + 1];
            map.put(regionCode, servicePrefix + SEPARATOR + regionCode + ENDPOINT_SUFFIX);
        }
        return map;
    }

    @Override
    public ResolvedEndpoint endpointFor(ResolveEndpointOption option) {
        String endpoint = DefaultEndpointProvider.getDefaultEndpointByServiceInfo(option.getService(), option.getRegion());
        ResolvedEndpoint result = new ResolvedEndpoint();
        result.setEndpoint(endpoint);
        return result;
    }

    public static String getDefaultEndpointByServiceInfo(String service, String regionCode) {
        String resultEndpoint = ENDPOINT;
        ServiceEndpointInfo endpointInfo = DEFAULT_ENDPOINT_MAP.get(service);
        if (endpointInfo == null) {
            return resultEndpoint;
        }
        if (endpointInfo.isGlobal) {
            if (!endpointInfo.globalEndpoint.isEmpty()) {
                resultEndpoint = endpointInfo.globalEndpoint;
                return resultEndpoint;
            }
        } else {
            String regionEndpoint = (String)endpointInfo.regionEndpointMap.get(regionCode);
            if (regionEndpoint != null) {
                resultEndpoint = regionEndpoint;
                return resultEndpoint;
            }
        }
        if (!endpointInfo.defaultEndpoint.isEmpty()) {
            resultEndpoint = endpointInfo.defaultEndpoint;
        }
        return resultEndpoint;
    }

    static {
        DEFAULT_ENDPOINT_MAP.put("vke", new ServiceEndpointInfo("vke", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "vke")));
        DEFAULT_ENDPOINT_MAP.put("Redis", new ServiceEndpointInfo("Redis", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "redis", REGION_CODE_AP_SOUTH_EAST_3, "redis")));
        DEFAULT_ENDPOINT_MAP.put("privatelink", new ServiceEndpointInfo("privatelink", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "privatelink", REGION_CODE_AP_SOUTH_EAST_3, "privatelink")));
        DEFAULT_ENDPOINT_MAP.put("vpc", new ServiceEndpointInfo("vpc", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "vpc", REGION_CODE_AP_SOUTH_EAST_3, "vpc")));
        DEFAULT_ENDPOINT_MAP.put("RocketMQ", new ServiceEndpointInfo("RocketMQ", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "rocketmq", REGION_CODE_AP_SOUTH_EAST_3, "rocketmq")));
        DEFAULT_ENDPOINT_MAP.put("Kafka", new ServiceEndpointInfo("Kafka", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "kafka", REGION_CODE_AP_SOUTH_EAST_3, "kafka")));
        DEFAULT_ENDPOINT_MAP.put("rds_mysql", new ServiceEndpointInfo("rds_mysql", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "rds-mysql", REGION_CODE_AP_SOUTH_EAST_3, "rds-mysql")));
        DEFAULT_ENDPOINT_MAP.put("rds_postgresql", new ServiceEndpointInfo("rds_postgresql", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "rds-postgresql", REGION_CODE_AP_SOUTH_EAST_3, "rds-postgresql")));
        DEFAULT_ENDPOINT_MAP.put("storage_ebs", new ServiceEndpointInfo("storage_ebs", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "storage-ebs", REGION_CODE_AP_SOUTH_EAST_3, "storage-ebs")));
        DEFAULT_ENDPOINT_MAP.put("clb", new ServiceEndpointInfo("clb", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "clb")));
        DEFAULT_ENDPOINT_MAP.put("ecs", new ServiceEndpointInfo("ecs", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "ecs", REGION_CODE_AP_SOUTH_EAST_3, "ecs")));
        DEFAULT_ENDPOINT_MAP.put("alb", new ServiceEndpointInfo("alb", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "alb", REGION_CODE_AP_SOUTH_EAST_3, "alb")));
        DEFAULT_ENDPOINT_MAP.put("FileNAS", new ServiceEndpointInfo("FileNAS", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "filenas")));
        DEFAULT_ENDPOINT_MAP.put("configcenter", new ServiceEndpointInfo("configcenter", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "configcenter")));
        DEFAULT_ENDPOINT_MAP.put("cr", new ServiceEndpointInfo("cr", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "cr")));
        DEFAULT_ENDPOINT_MAP.put("sts", new ServiceEndpointInfo("sts", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "sts")));
        DEFAULT_ENDPOINT_MAP.put("mongodb", new ServiceEndpointInfo("mongodb", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "mongodb", REGION_CODE_AP_SOUTH_EAST_3, "mongodb")));
        DEFAULT_ENDPOINT_MAP.put("transitrouter", new ServiceEndpointInfo("transitrouter", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "transitrouter", REGION_CODE_AP_SOUTH_EAST_3, "transitrouter")));
        DEFAULT_ENDPOINT_MAP.put("Volc_Observe", new ServiceEndpointInfo("Volc_Observe", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "volc-observe", REGION_CODE_AP_SOUTH_EAST_3, "volc-observe")));
        DEFAULT_ENDPOINT_MAP.put("dms", new ServiceEndpointInfo("dms", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "dms", REGION_CODE_AP_SOUTH_EAST_3, "dms")));
        DEFAULT_ENDPOINT_MAP.put("auto_scaling", new ServiceEndpointInfo("auto_scaling", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "auto-scaling", REGION_CODE_AP_SOUTH_EAST_3, "auto-scaling")));
        DEFAULT_ENDPOINT_MAP.put("directconnect", new ServiceEndpointInfo("directconnect", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "directconnect", REGION_CODE_AP_SOUTH_EAST_3, "directconnect")));
        DEFAULT_ENDPOINT_MAP.put("kms", new ServiceEndpointInfo("kms", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "kms")));
        DEFAULT_ENDPOINT_MAP.put("dbw", new ServiceEndpointInfo("dbw", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_AP_SOUTH_EAST_3, "dbw")));
        DEFAULT_ENDPOINT_MAP.put("dts", new ServiceEndpointInfo("dts", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "dts", REGION_CODE_AP_SOUTH_EAST_3, "dts")));
        DEFAULT_ENDPOINT_MAP.put("natgateway", new ServiceEndpointInfo("natgateway", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_AP_SOUTH_EAST_3, "natgateway")));
        DEFAULT_ENDPOINT_MAP.put("tos", new ServiceEndpointInfo("tos", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "tos", REGION_CODE_AP_SOUTH_EAST_3, "tos")));
        DEFAULT_ENDPOINT_MAP.put("TLS", new ServiceEndpointInfo("TLS", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_CN_BEIJING_AUTODRIVING, "tls", REGION_CODE_AP_SOUTH_EAST_3, "tls")));
        DEFAULT_ENDPOINT_MAP.put("vpn", new ServiceEndpointInfo("vpn", false, "", ENDPOINT, DefaultEndpointProvider.createRegionEndpointMap(REGION_CODE_AP_SOUTH_EAST_3, "vpn")));
    }

    private static class ServiceEndpointInfo {
        private String service;
        private boolean isGlobal;
        private String globalEndpoint;
        private String defaultEndpoint;
        private RegionEndpointMap regionEndpointMap;

        public ServiceEndpointInfo(String service, boolean isGlobal, String globalEndpoint, String defaultEndpoint, RegionEndpointMap regionEndpointMap) {
            this.service = service;
            this.isGlobal = isGlobal;
            this.globalEndpoint = globalEndpoint;
            this.defaultEndpoint = defaultEndpoint;
            this.regionEndpointMap = regionEndpointMap;
        }
    }

    private static class RegionEndpointMap
    extends HashMap<String, String> {
        private RegionEndpointMap() {
        }
    }
}

