/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.sign;

import com.volcengine.Pair;
import com.volcengine.auth.Authentication;
import com.volcengine.sign.Credentials;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;

public class VolcstackSign
implements Authentication {
    private static final String CONST_ENCODE = "0123456789ABCDEF";
    private static final BitSet URL_ENCODER;
    private Credentials credentials;
    private String region;
    private String service;
    private String method;

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, String payload) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Pair p : queryParams) {
            params.put(p.getName(), p.getValue());
        }
        try {
            this.sign(params, headerParams, payload);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public VolcstackSign() {
    }

    public VolcstackSign(Credentials credentials) {
        this.credentials = credentials;
    }

    private List<String> sortParamKeys(Map<String, String> queryParams) {
        ArrayList<String> listParamKeys = new ArrayList<String>(queryParams.keySet());
        Collections.sort(listParamKeys);
        return listParamKeys;
    }

    private List<String> sortHeaderKeys(Map<String, String> headerParams) {
        ArrayList<String> listHeaderKeys = new ArrayList<String>(headerParams.keySet());
        Collections.sort(listHeaderKeys);
        return listHeaderKeys;
    }

    private void buildCredentialScope(Map<String, String> headerParams, SignRequest signRequest) {
        StringBuilder credentialScope = new StringBuilder("");
        credentialScope.append(headerParams.get("X-Date").substring(0, 8));
        credentialScope.append("/");
        credentialScope.append(this.region);
        credentialScope.append("/");
        credentialScope.append(this.service);
        credentialScope.append("/request");
        signRequest.credentialScope = credentialScope;
    }

    private void buildStringToSign(Map<String, String> headerParams, SignRequest signRequest) throws Exception {
        StringBuilder stringToSign = new StringBuilder("");
        stringToSign.append("HMAC-SHA256");
        stringToSign.append("\n");
        stringToSign.append(headerParams.get("X-Date"));
        stringToSign.append("\n");
        stringToSign.append((CharSequence)signRequest.credentialScope);
        stringToSign.append("\n");
        stringToSign.append(this.getSHA256(signRequest.canonicalRequest.toString()));
        signRequest.stringToSign = stringToSign;
    }

    private void buildAuthorization(Map<String, String> headerParams, SignRequest signRequest) throws Exception {
        byte[] signingkeyByte = this.getHmacSHA256("request", this.getHmacSHA256(this.service, this.getHmacSHA256(this.region, this.getHmacSHA256(headerParams.get("X-Date").substring(0, 8), this.credentials.getSecretKey().getBytes(StandardCharsets.UTF_8)))));
        String signature = this.getHmacSHA256Hex(signRequest.stringToSign.toString(), signingkeyByte);
        StringBuilder authorization = new StringBuilder();
        authorization.append("HMAC-SHA256 Credential=");
        authorization.append(this.credentials.getAccessKey());
        authorization.append("/");
        authorization.append((CharSequence)signRequest.credentialScope);
        authorization.append(", ");
        authorization.append("SignedHeaders=");
        authorization.append(signRequest.signedHeaders.substring(0, signRequest.signedHeaders.length() - 1));
        authorization.append(", ");
        authorization.append("Signature=");
        authorization.append(signature);
        headerParams.put("Authorization", authorization.toString());
    }

    private void buildPayload(SignRequest signRequest, String payload) throws Exception {
        signRequest.canonicalRequest.append((CharSequence)signRequest.canonicalHeaders);
        signRequest.canonicalRequest.append("\n");
        signRequest.canonicalRequest.append(signRequest.signedHeaders.substring(0, signRequest.signedHeaders.length() - 1));
        signRequest.canonicalRequest.append("\n");
        signRequest.canonicalRequest.append(this.getSHA256(payload));
    }

    private void buildSignedHeaders(Map<String, String> headerParams, SignRequest signRequest) {
        List<String> listHeaderKeys = this.sortHeaderKeys(headerParams);
        StringBuilder canonicalHeaders = new StringBuilder("");
        StringBuilder signedHeaders = new StringBuilder("");
        for (String key : listHeaderKeys) {
            if (!key.equalsIgnoreCase("x-date")) continue;
            canonicalHeaders.append(key.toLowerCase());
            canonicalHeaders.append(":");
            canonicalHeaders.append(headerParams.get(key));
            canonicalHeaders.append("\n");
            signedHeaders.append(key.toLowerCase());
            signedHeaders.append(";");
        }
        signRequest.canonicalHeaders = canonicalHeaders;
        signRequest.signedHeaders = signedHeaders;
    }

    private void initHeaders(Map<String, String> headerParams) {
        if (!StringUtils.isEmpty((String)this.credentials.getSessionToken())) {
            headerParams.put("X-Security-Token", this.credentials.getSessionToken());
        }
        if (!headerParams.containsKey("X-Date")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            headerParams.put("X-Date", sdf.format(new Date()));
        }
    }

    private void buildCanonicalRequest(Map<String, String> queryParams, SignRequest signRequest) throws Exception {
        List<String> listParamKeys = this.sortParamKeys(queryParams);
        StringBuilder canonicalRequest = new StringBuilder();
        String httpRequestMethod = this.method;
        canonicalRequest.append(httpRequestMethod);
        canonicalRequest.append("\n");
        String canonicalURI = "/";
        canonicalRequest.append(canonicalURI);
        canonicalRequest.append("\n");
        StringBuilder canonicalQueryString = new StringBuilder();
        for (String key : listParamKeys) {
            canonicalQueryString.append(this.signStringEncoder(key));
            canonicalQueryString.append("=");
            canonicalQueryString.append(this.signStringEncoder(queryParams.get(key)));
            canonicalQueryString.append("&");
        }
        canonicalRequest.append(canonicalQueryString.substring(0, canonicalQueryString.length() - 1));
        canonicalRequest.append("\n");
        signRequest.canonicalRequest = canonicalRequest;
    }

    private void sign(Map<String, String> queryParams, Map<String, String> headerParams, String payload) throws Exception {
        SignRequest signRequest = new SignRequest();
        this.initHeaders(headerParams);
        this.buildCanonicalRequest(queryParams, signRequest);
        this.buildSignedHeaders(headerParams, signRequest);
        this.buildPayload(signRequest, payload);
        this.buildCredentialScope(headerParams, signRequest);
        this.buildStringToSign(headerParams, signRequest);
        this.buildAuthorization(headerParams, signRequest);
    }

    private String getSHA256(String str) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(str.getBytes(StandardCharsets.UTF_8));
        return this.byte2Hex(messageDigest.digest());
    }

    private byte[] getHmacSHA256(String str, byte[] key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key, "HmacSHA256");
        sha256_HMAC.init(secret_key);
        return sha256_HMAC.doFinal(str.getBytes(StandardCharsets.UTF_8));
    }

    private String getHmacSHA256Hex(String str, byte[] key) throws Exception {
        return this.byte2Hex(this.getHmacSHA256(str, key));
    }

    private String byte2Hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            String temp = Integer.toHexString(aByte & 0xFF);
            if (temp.length() == 1) {
                sb.append("0");
            }
            sb.append(temp);
        }
        return sb.toString();
    }

    private String signStringEncoder(String source) {
        if (source == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(source.length());
        ByteBuffer bb = StandardCharsets.UTF_8.encode(source);
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (URL_ENCODER.get(b)) {
                buf.append((char)b);
                continue;
            }
            if (b == 32) {
                buf.append("%20");
                continue;
            }
            buf.append("%");
            char hex1 = CONST_ENCODE.charAt(b >> 4);
            char hex2 = CONST_ENCODE.charAt(b & 0xF);
            buf.append(hex1);
            buf.append(hex2);
        }
        return buf.toString();
    }

    public VolcstackSign copy() {
        VolcstackSign copySign = new VolcstackSign();
        copySign.setRegion(this.region);
        copySign.setCredentials(this.credentials);
        copySign.setService(this.service);
        copySign.setMethod(this.method);
        return copySign;
    }

    static {
        int i;
        URL_ENCODER = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            URL_ENCODER.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            URL_ENCODER.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URL_ENCODER.set(i);
        }
        URL_ENCODER.set(45);
        URL_ENCODER.set(95);
        URL_ENCODER.set(46);
        URL_ENCODER.set(126);
    }

    private static class SignRequest {
        private StringBuilder canonicalRequest;
        private StringBuilder signedHeaders;
        private StringBuilder canonicalHeaders;
        private StringBuilder credentialScope;
        private StringBuilder stringToSign;

        private SignRequest() {
        }
    }
}

