/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.cr.model;

import com.google.gson.annotations.SerializedName;
import com.volcengine.cr.model.FilterForListRegistriesInput;
import com.volcengine.cr.model.ResourceTagFilterForListRegistriesInput;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class ListRegistriesRequest {
    @SerializedName(value="Filter")
    private FilterForListRegistriesInput filter = null;
    @SerializedName(value="PageNumber")
    private Long pageNumber = null;
    @SerializedName(value="PageSize")
    private Long pageSize = null;
    @SerializedName(value="ResourceTagFilters")
    private List<ResourceTagFilterForListRegistriesInput> resourceTagFilters = null;

    public ListRegistriesRequest filter(FilterForListRegistriesInput filter) {
        this.filter = filter;
        return this;
    }

    @Valid
    @Schema(description="")
    public FilterForListRegistriesInput getFilter() {
        return this.filter;
    }

    public void setFilter(FilterForListRegistriesInput filter) {
        this.filter = filter;
    }

    public ListRegistriesRequest pageNumber(Long pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Schema(description="")
    public Long getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Long pageNumber) {
        this.pageNumber = pageNumber;
    }

    public ListRegistriesRequest pageSize(Long pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Min(value=1L)
    @Max(value=100L)
    @Schema(description="")
    public Long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Long pageSize) {
        this.pageSize = pageSize;
    }

    public ListRegistriesRequest resourceTagFilters(List<ResourceTagFilterForListRegistriesInput> resourceTagFilters) {
        this.resourceTagFilters = resourceTagFilters;
        return this;
    }

    public ListRegistriesRequest addResourceTagFiltersItem(ResourceTagFilterForListRegistriesInput resourceTagFiltersItem) {
        if (this.resourceTagFilters == null) {
            this.resourceTagFilters = new ArrayList<ResourceTagFilterForListRegistriesInput>();
        }
        this.resourceTagFilters.add(resourceTagFiltersItem);
        return this;
    }

    @Valid
    @Schema(description="")
    public List<ResourceTagFilterForListRegistriesInput> getResourceTagFilters() {
        return this.resourceTagFilters;
    }

    public void setResourceTagFilters(List<ResourceTagFilterForListRegistriesInput> resourceTagFilters) {
        this.resourceTagFilters = resourceTagFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListRegistriesRequest listRegistriesRequest = (ListRegistriesRequest)o;
        return Objects.equals(this.filter, listRegistriesRequest.filter) && Objects.equals(this.pageNumber, listRegistriesRequest.pageNumber) && Objects.equals(this.pageSize, listRegistriesRequest.pageSize) && Objects.equals(this.resourceTagFilters, listRegistriesRequest.resourceTagFilters);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.pageNumber, this.pageSize, this.resourceTagFilters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListRegistriesRequest {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    resourceTagFilters: ").append(this.toIndentedString(this.resourceTagFilters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

