/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.cr.model;

import com.google.gson.annotations.SerializedName;
import com.volcengine.cr.model.FilterForListTagsInput;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class ListTagsRequest {
    @SerializedName(value="Filter")
    private FilterForListTagsInput filter = null;
    @SerializedName(value="Namespace")
    private String namespace = null;
    @SerializedName(value="PageNumber")
    private Long pageNumber = null;
    @SerializedName(value="PageSize")
    private Long pageSize = null;
    @SerializedName(value="Registry")
    private String registry = null;
    @SerializedName(value="Repository")
    private String repository = null;

    public ListTagsRequest filter(FilterForListTagsInput filter) {
        this.filter = filter;
        return this;
    }

    @Valid
    @Schema(description="")
    public FilterForListTagsInput getFilter() {
        return this.filter;
    }

    public void setFilter(FilterForListTagsInput filter) {
        this.filter = filter;
    }

    public ListTagsRequest namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @NotNull
    @Size(min=2, max=90)
    @Schema(required=true, description="")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ListTagsRequest pageNumber(Long pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Schema(description="")
    public Long getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Long pageNumber) {
        this.pageNumber = pageNumber;
    }

    public ListTagsRequest pageSize(Long pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Min(value=1L)
    @Max(value=100L)
    @Schema(description="")
    public Long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Long pageSize) {
        this.pageSize = pageSize;
    }

    public ListTagsRequest registry(String registry) {
        this.registry = registry;
        return this;
    }

    @NotNull
    @Size(min=3, max=30)
    @Schema(required=true, description="")
    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public ListTagsRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    @NotNull
    @Schema(required=true, description="")
    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTagsRequest listTagsRequest = (ListTagsRequest)o;
        return Objects.equals(this.filter, listTagsRequest.filter) && Objects.equals(this.namespace, listTagsRequest.namespace) && Objects.equals(this.pageNumber, listTagsRequest.pageNumber) && Objects.equals(this.pageSize, listTagsRequest.pageSize) && Objects.equals(this.registry, listTagsRequest.registry) && Objects.equals(this.repository, listTagsRequest.repository);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.namespace, this.pageNumber, this.pageSize, this.registry, this.repository);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTagsRequest {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    registry: ").append(this.toIndentedString(this.registry)).append("\n");
        sb.append("    repository: ").append(this.toIndentedString(this.repository)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

