/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ecs.examples;

import com.volcengine.ApiClient;
import com.volcengine.ApiException;
import com.volcengine.ecs.EcsApi;
import com.volcengine.ecs.model.NetworkInterfaceForRunInstancesInput;
import com.volcengine.ecs.model.RunInstancesRequest;
import com.volcengine.ecs.model.RunInstancesResponse;
import com.volcengine.ecs.model.VolumeForRunInstancesInput;
import com.volcengine.sign.Credentials;
import java.util.Arrays;

public class TestRunInstances {
    public static void main(String[] args) throws Exception {
        String ak = "Your AK";
        String sk = "Your SK";
        String region = "cn-beijing";
        ApiClient apiClient = new ApiClient().setCredentials(Credentials.getCredentials((String)ak, (String)sk)).setRegion(region);
        EcsApi api = new EcsApi(apiClient);
        NetworkInterfaceForRunInstancesInput reqNetworkInterfaces = new NetworkInterfaceForRunInstancesInput();
        reqNetworkInterfaces.setSecurityGroupIds(Arrays.asList("sg-3ti78x9h8t4bw*****"));
        reqNetworkInterfaces.setSubnetId("subnet-3tispp1nai4e8i****");
        VolumeForRunInstancesInput reqVolumes = new VolumeForRunInstancesInput();
        reqVolumes.setSize(40);
        reqVolumes.setVolumeType("ESSD_PL0");
        RunInstancesRequest runInstancesRequest = new RunInstancesRequest();
        runInstancesRequest.setCount(1);
        runInstancesRequest.setImageId("image-3tefr6wgx63vj0******");
        runInstancesRequest.setInstanceName("instance-test");
        runInstancesRequest.setInstanceTypeId("ecs.g1ie.xlarge");
        runInstancesRequest.setNetworkInterfaces(Arrays.asList(reqNetworkInterfaces));
        runInstancesRequest.setPassword("password@123");
        runInstancesRequest.setVolumes(Arrays.asList(reqVolumes));
        runInstancesRequest.setZoneId("cn-beijing-a");
        try {
            RunInstancesResponse response = api.runInstances(runInstancesRequest);
            System.out.println((Object)response);
        }
        catch (ApiException e) {
            System.out.println(e.getResponseBody());
        }
    }
}

