/**
* Example Code generated by Beijing Volcanoengine Technology.
*/
package com.volcengine.ecs.examples;

import com.volcengine.ApiClient;
import com.volcengine.ApiException;
import com.volcengine.sign.Credentials;

import com.volcengine.ecs.EcsApi;
import com.volcengine.ecs.model.*;


public class TestImportKeyPair {
    public static void main(String[] args) throws Exception {
        String ak = "Your AK";
        String sk = "Your SK";
        String region = "Your Region";

        ApiClient apiClient = new ApiClient()
                .setCredentials(Credentials.getCredentials(ak, sk))
                .setRegion(region);

        EcsApi api = new EcsApi(apiClient);
        
        ImportKeyPairRequest importKeyPairRequest = new ImportKeyPairRequest();
        importKeyPairRequest.setKeyPairName("ssh_key_pair");
        importKeyPairRequest.setPublicKey("ssh-rsa AaaAAB3NzaC1yc2EAAAADAQ******");
        
        try {
            ImportKeyPairResponse response = api.importKeyPair(importKeyPairRequest);
            System.out.println(response);
        } catch (ApiException e) {
            System.out.println(e.getResponseBody());
        }
    }
}