/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.emr.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class ListNodesRequest {
    @SerializedName(value="ClusterId")
    private String clusterId = null;
    @SerializedName(value="Fqdns")
    private List<String> fqdns = null;
    @SerializedName(value="MaxResults")
    private Integer maxResults = null;
    @SerializedName(value="NextToken")
    private String nextToken = null;
    @SerializedName(value="NodeGroupIds")
    private List<String> nodeGroupIds = null;
    @SerializedName(value="NodeIds")
    private List<String> nodeIds = null;
    @SerializedName(value="NodeNames")
    private List<String> nodeNames = null;
    @SerializedName(value="NodeStates")
    private List<NodeStatesEnum> nodeStates = null;
    @SerializedName(value="PrivateIps")
    private List<String> privateIps = null;
    @SerializedName(value="PublicIps")
    private List<String> publicIps = null;

    public ListNodesRequest clusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    @NotNull
    @Schema(required=true, description="")
    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public ListNodesRequest fqdns(List<String> fqdns) {
        this.fqdns = fqdns;
        return this;
    }

    public ListNodesRequest addFqdnsItem(String fqdnsItem) {
        if (this.fqdns == null) {
            this.fqdns = new ArrayList<String>();
        }
        this.fqdns.add(fqdnsItem);
        return this;
    }

    @Schema(description="")
    public List<String> getFqdns() {
        return this.fqdns;
    }

    public void setFqdns(List<String> fqdns) {
        this.fqdns = fqdns;
    }

    public ListNodesRequest maxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Min(value=1L)
    @Max(value=100L)
    @Schema(description="")
    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public ListNodesRequest nextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    @Schema(description="")
    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListNodesRequest nodeGroupIds(List<String> nodeGroupIds) {
        this.nodeGroupIds = nodeGroupIds;
        return this;
    }

    public ListNodesRequest addNodeGroupIdsItem(String nodeGroupIdsItem) {
        if (this.nodeGroupIds == null) {
            this.nodeGroupIds = new ArrayList<String>();
        }
        this.nodeGroupIds.add(nodeGroupIdsItem);
        return this;
    }

    @Schema(description="")
    public List<String> getNodeGroupIds() {
        return this.nodeGroupIds;
    }

    public void setNodeGroupIds(List<String> nodeGroupIds) {
        this.nodeGroupIds = nodeGroupIds;
    }

    public ListNodesRequest nodeIds(List<String> nodeIds) {
        this.nodeIds = nodeIds;
        return this;
    }

    public ListNodesRequest addNodeIdsItem(String nodeIdsItem) {
        if (this.nodeIds == null) {
            this.nodeIds = new ArrayList<String>();
        }
        this.nodeIds.add(nodeIdsItem);
        return this;
    }

    @Schema(description="")
    public List<String> getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(List<String> nodeIds) {
        this.nodeIds = nodeIds;
    }

    public ListNodesRequest nodeNames(List<String> nodeNames) {
        this.nodeNames = nodeNames;
        return this;
    }

    public ListNodesRequest addNodeNamesItem(String nodeNamesItem) {
        if (this.nodeNames == null) {
            this.nodeNames = new ArrayList<String>();
        }
        this.nodeNames.add(nodeNamesItem);
        return this;
    }

    @Schema(description="")
    public List<String> getNodeNames() {
        return this.nodeNames;
    }

    public void setNodeNames(List<String> nodeNames) {
        this.nodeNames = nodeNames;
    }

    public ListNodesRequest nodeStates(List<NodeStatesEnum> nodeStates) {
        this.nodeStates = nodeStates;
        return this;
    }

    public ListNodesRequest addNodeStatesItem(NodeStatesEnum nodeStatesItem) {
        if (this.nodeStates == null) {
            this.nodeStates = new ArrayList<NodeStatesEnum>();
        }
        this.nodeStates.add(nodeStatesItem);
        return this;
    }

    @Schema(description="")
    public List<NodeStatesEnum> getNodeStates() {
        return this.nodeStates;
    }

    public void setNodeStates(List<NodeStatesEnum> nodeStates) {
        this.nodeStates = nodeStates;
    }

    public ListNodesRequest privateIps(List<String> privateIps) {
        this.privateIps = privateIps;
        return this;
    }

    public ListNodesRequest addPrivateIpsItem(String privateIpsItem) {
        if (this.privateIps == null) {
            this.privateIps = new ArrayList<String>();
        }
        this.privateIps.add(privateIpsItem);
        return this;
    }

    @Schema(description="")
    public List<String> getPrivateIps() {
        return this.privateIps;
    }

    public void setPrivateIps(List<String> privateIps) {
        this.privateIps = privateIps;
    }

    public ListNodesRequest publicIps(List<String> publicIps) {
        this.publicIps = publicIps;
        return this;
    }

    public ListNodesRequest addPublicIpsItem(String publicIpsItem) {
        if (this.publicIps == null) {
            this.publicIps = new ArrayList<String>();
        }
        this.publicIps.add(publicIpsItem);
        return this;
    }

    @Schema(description="")
    public List<String> getPublicIps() {
        return this.publicIps;
    }

    public void setPublicIps(List<String> publicIps) {
        this.publicIps = publicIps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListNodesRequest listNodesRequest = (ListNodesRequest)o;
        return Objects.equals(this.clusterId, listNodesRequest.clusterId) && Objects.equals(this.fqdns, listNodesRequest.fqdns) && Objects.equals(this.maxResults, listNodesRequest.maxResults) && Objects.equals(this.nextToken, listNodesRequest.nextToken) && Objects.equals(this.nodeGroupIds, listNodesRequest.nodeGroupIds) && Objects.equals(this.nodeIds, listNodesRequest.nodeIds) && Objects.equals(this.nodeNames, listNodesRequest.nodeNames) && Objects.equals(this.nodeStates, listNodesRequest.nodeStates) && Objects.equals(this.privateIps, listNodesRequest.privateIps) && Objects.equals(this.publicIps, listNodesRequest.publicIps);
    }

    public int hashCode() {
        return Objects.hash(this.clusterId, this.fqdns, this.maxResults, this.nextToken, this.nodeGroupIds, this.nodeIds, this.nodeNames, this.nodeStates, this.privateIps, this.publicIps);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListNodesRequest {\n");
        sb.append("    clusterId: ").append(this.toIndentedString(this.clusterId)).append("\n");
        sb.append("    fqdns: ").append(this.toIndentedString(this.fqdns)).append("\n");
        sb.append("    maxResults: ").append(this.toIndentedString(this.maxResults)).append("\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("    nodeGroupIds: ").append(this.toIndentedString(this.nodeGroupIds)).append("\n");
        sb.append("    nodeIds: ").append(this.toIndentedString(this.nodeIds)).append("\n");
        sb.append("    nodeNames: ").append(this.toIndentedString(this.nodeNames)).append("\n");
        sb.append("    nodeStates: ").append(this.toIndentedString(this.nodeStates)).append("\n");
        sb.append("    privateIps: ").append(this.toIndentedString(this.privateIps)).append("\n");
        sb.append("    publicIps: ").append(this.toIndentedString(this.publicIps)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum NodeStatesEnum {
        UNKNOWN("UNKNOWN"),
        CREATING("CREATING"),
        RUNNING("RUNNING"),
        STOPPING("STOPPING"),
        STOPPED("STOPPED"),
        REBOOTING("REBOOTING"),
        REBUILDING("REBUILDING"),
        DELETED("DELETED");

        private String value;

        private NodeStatesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NodeStatesEnum fromValue(String input) {
            for (NodeStatesEnum b : NodeStatesEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<NodeStatesEnum> {
            public void write(JsonWriter jsonWriter, NodeStatesEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public NodeStatesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return NodeStatesEnum.fromValue(value);
            }
        }
    }
}

