/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.kms.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class CreateSecretRequest {
    @SerializedName(value="AutomaticRotation")
    private Boolean automaticRotation = null;
    @SerializedName(value="Description")
    private String description = null;
    @SerializedName(value="EncryptionKey")
    private String encryptionKey = null;
    @SerializedName(value="ExtendedConfig")
    private String extendedConfig = null;
    @SerializedName(value="ProjectName")
    private String projectName = null;
    @SerializedName(value="RotationInterval")
    private String rotationInterval = null;
    @SerializedName(value="SecretName")
    private String secretName = null;
    @SerializedName(value="SecretType")
    private SecretTypeEnum secretType = null;
    @SerializedName(value="SecretValue")
    private String secretValue = null;

    public CreateSecretRequest automaticRotation(Boolean automaticRotation) {
        this.automaticRotation = automaticRotation;
        return this;
    }

    @Schema(description="")
    public Boolean isAutomaticRotation() {
        return this.automaticRotation;
    }

    public void setAutomaticRotation(Boolean automaticRotation) {
        this.automaticRotation = automaticRotation;
    }

    public CreateSecretRequest description(String description) {
        this.description = description;
        return this;
    }

    @Size(max=8192)
    @Schema(description="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateSecretRequest encryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    @Schema(description="")
    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public CreateSecretRequest extendedConfig(String extendedConfig) {
        this.extendedConfig = extendedConfig;
        return this;
    }

    @Size(max=1024)
    @Schema(description="")
    public String getExtendedConfig() {
        return this.extendedConfig;
    }

    public void setExtendedConfig(String extendedConfig) {
        this.extendedConfig = extendedConfig;
    }

    public CreateSecretRequest projectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    @Schema(description="")
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public CreateSecretRequest rotationInterval(String rotationInterval) {
        this.rotationInterval = rotationInterval;
        return this;
    }

    @Schema(description="")
    public String getRotationInterval() {
        return this.rotationInterval;
    }

    public void setRotationInterval(String rotationInterval) {
        this.rotationInterval = rotationInterval;
    }

    public CreateSecretRequest secretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    @NotNull
    @Size(min=2, max=31)
    @Schema(required=true, description="")
    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public CreateSecretRequest secretType(SecretTypeEnum secretType) {
        this.secretType = secretType;
        return this;
    }

    @NotNull
    @Schema(required=true, description="")
    public SecretTypeEnum getSecretType() {
        return this.secretType;
    }

    public void setSecretType(SecretTypeEnum secretType) {
        this.secretType = secretType;
    }

    public CreateSecretRequest secretValue(String secretValue) {
        this.secretValue = secretValue;
        return this;
    }

    @NotNull
    @Size(max=30720)
    @Schema(required=true, description="")
    public String getSecretValue() {
        return this.secretValue;
    }

    public void setSecretValue(String secretValue) {
        this.secretValue = secretValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSecretRequest createSecretRequest = (CreateSecretRequest)o;
        return Objects.equals(this.automaticRotation, createSecretRequest.automaticRotation) && Objects.equals(this.description, createSecretRequest.description) && Objects.equals(this.encryptionKey, createSecretRequest.encryptionKey) && Objects.equals(this.extendedConfig, createSecretRequest.extendedConfig) && Objects.equals(this.projectName, createSecretRequest.projectName) && Objects.equals(this.rotationInterval, createSecretRequest.rotationInterval) && Objects.equals(this.secretName, createSecretRequest.secretName) && Objects.equals((Object)this.secretType, (Object)createSecretRequest.secretType) && Objects.equals(this.secretValue, createSecretRequest.secretValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.automaticRotation, this.description, this.encryptionKey, this.extendedConfig, this.projectName, this.rotationInterval, this.secretName, this.secretType, this.secretValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateSecretRequest {\n");
        sb.append("    automaticRotation: ").append(this.toIndentedString(this.automaticRotation)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    encryptionKey: ").append(this.toIndentedString(this.encryptionKey)).append("\n");
        sb.append("    extendedConfig: ").append(this.toIndentedString(this.extendedConfig)).append("\n");
        sb.append("    projectName: ").append(this.toIndentedString(this.projectName)).append("\n");
        sb.append("    rotationInterval: ").append(this.toIndentedString(this.rotationInterval)).append("\n");
        sb.append("    secretName: ").append(this.toIndentedString(this.secretName)).append("\n");
        sb.append("    secretType: ").append(this.toIndentedString((Object)this.secretType)).append("\n");
        sb.append("    secretValue: ").append(this.toIndentedString(this.secretValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SecretTypeEnum {
        GENERIC("Generic"),
        IAM("IAM"),
        RDS("RDS"),
        REDIS("Redis"),
        ECS("ECS");

        private String value;

        private SecretTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SecretTypeEnum fromValue(String input) {
            for (SecretTypeEnum b : SecretTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SecretTypeEnum> {
            public void write(JsonWriter jsonWriter, SecretTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public SecretTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SecretTypeEnum.fromValue(value);
            }
        }
    }
}

