/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.kms.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;

public class GenerateDataKeyRequest {
    @SerializedName(value="EncryptionContext")
    private Map<String, String> encryptionContext = null;
    @SerializedName(value="KeyID")
    private String keyID = null;
    @SerializedName(value="KeyName")
    private String keyName = null;
    @SerializedName(value="KeyringName")
    private String keyringName = null;
    @SerializedName(value="NumberOfBytes")
    private Integer numberOfBytes = null;

    public GenerateDataKeyRequest encryptionContext(Map<String, String> encryptionContext) {
        this.encryptionContext = encryptionContext;
        return this;
    }

    public GenerateDataKeyRequest putEncryptionContextItem(String key, String encryptionContextItem) {
        if (this.encryptionContext == null) {
            this.encryptionContext = new HashMap<String, String>();
        }
        this.encryptionContext.put(key, encryptionContextItem);
        return this;
    }

    @Schema(description="")
    public Map<String, String> getEncryptionContext() {
        return this.encryptionContext;
    }

    public void setEncryptionContext(Map<String, String> encryptionContext) {
        this.encryptionContext = encryptionContext;
    }

    public GenerateDataKeyRequest keyID(String keyID) {
        this.keyID = keyID;
        return this;
    }

    @Schema(description="")
    public String getKeyID() {
        return this.keyID;
    }

    public void setKeyID(String keyID) {
        this.keyID = keyID;
    }

    public GenerateDataKeyRequest keyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    @Size(min=2, max=31)
    @Schema(description="")
    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public GenerateDataKeyRequest keyringName(String keyringName) {
        this.keyringName = keyringName;
        return this;
    }

    @Size(min=2, max=31)
    @Schema(description="")
    public String getKeyringName() {
        return this.keyringName;
    }

    public void setKeyringName(String keyringName) {
        this.keyringName = keyringName;
    }

    public GenerateDataKeyRequest numberOfBytes(Integer numberOfBytes) {
        this.numberOfBytes = numberOfBytes;
        return this;
    }

    @Min(value=1L)
    @Max(value=1024L)
    @Schema(description="")
    public Integer getNumberOfBytes() {
        return this.numberOfBytes;
    }

    public void setNumberOfBytes(Integer numberOfBytes) {
        this.numberOfBytes = numberOfBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenerateDataKeyRequest generateDataKeyRequest = (GenerateDataKeyRequest)o;
        return Objects.equals(this.encryptionContext, generateDataKeyRequest.encryptionContext) && Objects.equals(this.keyID, generateDataKeyRequest.keyID) && Objects.equals(this.keyName, generateDataKeyRequest.keyName) && Objects.equals(this.keyringName, generateDataKeyRequest.keyringName) && Objects.equals(this.numberOfBytes, generateDataKeyRequest.numberOfBytes);
    }

    public int hashCode() {
        return Objects.hash(this.encryptionContext, this.keyID, this.keyName, this.keyringName, this.numberOfBytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GenerateDataKeyRequest {\n");
        sb.append("    encryptionContext: ").append(this.toIndentedString(this.encryptionContext)).append("\n");
        sb.append("    keyID: ").append(this.toIndentedString(this.keyID)).append("\n");
        sb.append("    keyName: ").append(this.toIndentedString(this.keyName)).append("\n");
        sb.append("    keyringName: ").append(this.toIndentedString(this.keyringName)).append("\n");
        sb.append("    numberOfBytes: ").append(this.toIndentedString(this.numberOfBytes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

