/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.kms.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class ReEncryptRequest {
    @SerializedName(value="CiphertextBlob")
    private String ciphertextBlob = null;
    @SerializedName(value="NewEncryptionContext")
    private Map<String, String> newEncryptionContext = null;
    @SerializedName(value="NewKeyID")
    private String newKeyID = null;
    @SerializedName(value="NewKeyName")
    private String newKeyName = null;
    @SerializedName(value="NewKeyringName")
    private String newKeyringName = null;
    @SerializedName(value="OldEncryptionContext")
    private Map<String, String> oldEncryptionContext = null;

    public ReEncryptRequest ciphertextBlob(String ciphertextBlob) {
        this.ciphertextBlob = ciphertextBlob;
        return this;
    }

    @NotNull
    @Size(min=19)
    @Schema(required=true, description="")
    public String getCiphertextBlob() {
        return this.ciphertextBlob;
    }

    public void setCiphertextBlob(String ciphertextBlob) {
        this.ciphertextBlob = ciphertextBlob;
    }

    public ReEncryptRequest newEncryptionContext(Map<String, String> newEncryptionContext) {
        this.newEncryptionContext = newEncryptionContext;
        return this;
    }

    public ReEncryptRequest putNewEncryptionContextItem(String key, String newEncryptionContextItem) {
        if (this.newEncryptionContext == null) {
            this.newEncryptionContext = new HashMap<String, String>();
        }
        this.newEncryptionContext.put(key, newEncryptionContextItem);
        return this;
    }

    @Schema(description="")
    public Map<String, String> getNewEncryptionContext() {
        return this.newEncryptionContext;
    }

    public void setNewEncryptionContext(Map<String, String> newEncryptionContext) {
        this.newEncryptionContext = newEncryptionContext;
    }

    public ReEncryptRequest newKeyID(String newKeyID) {
        this.newKeyID = newKeyID;
        return this;
    }

    @Schema(description="")
    public String getNewKeyID() {
        return this.newKeyID;
    }

    public void setNewKeyID(String newKeyID) {
        this.newKeyID = newKeyID;
    }

    public ReEncryptRequest newKeyName(String newKeyName) {
        this.newKeyName = newKeyName;
        return this;
    }

    @Size(min=2, max=31)
    @Schema(description="")
    public String getNewKeyName() {
        return this.newKeyName;
    }

    public void setNewKeyName(String newKeyName) {
        this.newKeyName = newKeyName;
    }

    public ReEncryptRequest newKeyringName(String newKeyringName) {
        this.newKeyringName = newKeyringName;
        return this;
    }

    @Size(min=2, max=31)
    @Schema(description="")
    public String getNewKeyringName() {
        return this.newKeyringName;
    }

    public void setNewKeyringName(String newKeyringName) {
        this.newKeyringName = newKeyringName;
    }

    public ReEncryptRequest oldEncryptionContext(Map<String, String> oldEncryptionContext) {
        this.oldEncryptionContext = oldEncryptionContext;
        return this;
    }

    public ReEncryptRequest putOldEncryptionContextItem(String key, String oldEncryptionContextItem) {
        if (this.oldEncryptionContext == null) {
            this.oldEncryptionContext = new HashMap<String, String>();
        }
        this.oldEncryptionContext.put(key, oldEncryptionContextItem);
        return this;
    }

    @Schema(description="")
    public Map<String, String> getOldEncryptionContext() {
        return this.oldEncryptionContext;
    }

    public void setOldEncryptionContext(Map<String, String> oldEncryptionContext) {
        this.oldEncryptionContext = oldEncryptionContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReEncryptRequest reEncryptRequest = (ReEncryptRequest)o;
        return Objects.equals(this.ciphertextBlob, reEncryptRequest.ciphertextBlob) && Objects.equals(this.newEncryptionContext, reEncryptRequest.newEncryptionContext) && Objects.equals(this.newKeyID, reEncryptRequest.newKeyID) && Objects.equals(this.newKeyName, reEncryptRequest.newKeyName) && Objects.equals(this.newKeyringName, reEncryptRequest.newKeyringName) && Objects.equals(this.oldEncryptionContext, reEncryptRequest.oldEncryptionContext);
    }

    public int hashCode() {
        return Objects.hash(this.ciphertextBlob, this.newEncryptionContext, this.newKeyID, this.newKeyName, this.newKeyringName, this.oldEncryptionContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReEncryptRequest {\n");
        sb.append("    ciphertextBlob: ").append(this.toIndentedString(this.ciphertextBlob)).append("\n");
        sb.append("    newEncryptionContext: ").append(this.toIndentedString(this.newEncryptionContext)).append("\n");
        sb.append("    newKeyID: ").append(this.toIndentedString(this.newKeyID)).append("\n");
        sb.append("    newKeyName: ").append(this.toIndentedString(this.newKeyName)).append("\n");
        sb.append("    newKeyringName: ").append(this.toIndentedString(this.newKeyringName)).append("\n");
        sb.append("    oldEncryptionContext: ").append(this.toIndentedString(this.oldEncryptionContext)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

