/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.kms.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class CreateCustomKeyStoreRequest {
    @SerializedName(value="CustomKeyStoreName")
    private String customKeyStoreName = null;
    @SerializedName(value="CustomKeyStoreType")
    private CustomKeyStoreTypeEnum customKeyStoreType = null;
    @SerializedName(value="TrustAnchorCertificate")
    private String trustAnchorCertificate = null;
    @SerializedName(value="XksAccessKey")
    private String xksAccessKey = null;
    @SerializedName(value="XksProxyConnectivity")
    private XksProxyConnectivityEnum xksProxyConnectivity = null;
    @SerializedName(value="XksProxyUriEndpoint")
    private String xksProxyUriEndpoint = null;
    @SerializedName(value="XksProxyUriPath")
    private String xksProxyUriPath = null;
    @SerializedName(value="XksProxyVpcEndpointServiceName")
    private String xksProxyVpcEndpointServiceName = null;
    @SerializedName(value="XksSecretAccessKey")
    private String xksSecretAccessKey = null;

    public CreateCustomKeyStoreRequest customKeyStoreName(String customKeyStoreName) {
        this.customKeyStoreName = customKeyStoreName;
        return this;
    }

    @NotNull
    @Size(min=2, max=31)
    @Schema(required=true, description="")
    public String getCustomKeyStoreName() {
        return this.customKeyStoreName;
    }

    public void setCustomKeyStoreName(String customKeyStoreName) {
        this.customKeyStoreName = customKeyStoreName;
    }

    public CreateCustomKeyStoreRequest customKeyStoreType(CustomKeyStoreTypeEnum customKeyStoreType) {
        this.customKeyStoreType = customKeyStoreType;
        return this;
    }

    @NotNull
    @Schema(required=true, description="")
    public CustomKeyStoreTypeEnum getCustomKeyStoreType() {
        return this.customKeyStoreType;
    }

    public void setCustomKeyStoreType(CustomKeyStoreTypeEnum customKeyStoreType) {
        this.customKeyStoreType = customKeyStoreType;
    }

    public CreateCustomKeyStoreRequest trustAnchorCertificate(String trustAnchorCertificate) {
        this.trustAnchorCertificate = trustAnchorCertificate;
        return this;
    }

    @NotNull
    @Size(min=1, max=5000)
    @Schema(required=true, description="")
    public String getTrustAnchorCertificate() {
        return this.trustAnchorCertificate;
    }

    public void setTrustAnchorCertificate(String trustAnchorCertificate) {
        this.trustAnchorCertificate = trustAnchorCertificate;
    }

    public CreateCustomKeyStoreRequest xksAccessKey(String xksAccessKey) {
        this.xksAccessKey = xksAccessKey;
        return this;
    }

    @Size(min=20, max=30)
    @Schema(description="")
    public String getXksAccessKey() {
        return this.xksAccessKey;
    }

    public void setXksAccessKey(String xksAccessKey) {
        this.xksAccessKey = xksAccessKey;
    }

    public CreateCustomKeyStoreRequest xksProxyConnectivity(XksProxyConnectivityEnum xksProxyConnectivity) {
        this.xksProxyConnectivity = xksProxyConnectivity;
        return this;
    }

    @Schema(description="")
    public XksProxyConnectivityEnum getXksProxyConnectivity() {
        return this.xksProxyConnectivity;
    }

    public void setXksProxyConnectivity(XksProxyConnectivityEnum xksProxyConnectivity) {
        this.xksProxyConnectivity = xksProxyConnectivity;
    }

    public CreateCustomKeyStoreRequest xksProxyUriEndpoint(String xksProxyUriEndpoint) {
        this.xksProxyUriEndpoint = xksProxyUriEndpoint;
        return this;
    }

    @Size(min=10, max=128)
    @Schema(description="")
    public String getXksProxyUriEndpoint() {
        return this.xksProxyUriEndpoint;
    }

    public void setXksProxyUriEndpoint(String xksProxyUriEndpoint) {
        this.xksProxyUriEndpoint = xksProxyUriEndpoint;
    }

    public CreateCustomKeyStoreRequest xksProxyUriPath(String xksProxyUriPath) {
        this.xksProxyUriPath = xksProxyUriPath;
        return this;
    }

    @Size(min=10, max=128)
    @Schema(description="")
    public String getXksProxyUriPath() {
        return this.xksProxyUriPath;
    }

    public void setXksProxyUriPath(String xksProxyUriPath) {
        this.xksProxyUriPath = xksProxyUriPath;
    }

    public CreateCustomKeyStoreRequest xksProxyVpcEndpointServiceName(String xksProxyVpcEndpointServiceName) {
        this.xksProxyVpcEndpointServiceName = xksProxyVpcEndpointServiceName;
        return this;
    }

    @Size(min=20, max=128)
    @Schema(description="")
    public String getXksProxyVpcEndpointServiceName() {
        return this.xksProxyVpcEndpointServiceName;
    }

    public void setXksProxyVpcEndpointServiceName(String xksProxyVpcEndpointServiceName) {
        this.xksProxyVpcEndpointServiceName = xksProxyVpcEndpointServiceName;
    }

    public CreateCustomKeyStoreRequest xksSecretAccessKey(String xksSecretAccessKey) {
        this.xksSecretAccessKey = xksSecretAccessKey;
        return this;
    }

    @Size(min=43, max=64)
    @Schema(description="")
    public String getXksSecretAccessKey() {
        return this.xksSecretAccessKey;
    }

    public void setXksSecretAccessKey(String xksSecretAccessKey) {
        this.xksSecretAccessKey = xksSecretAccessKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCustomKeyStoreRequest createCustomKeyStoreRequest = (CreateCustomKeyStoreRequest)o;
        return Objects.equals(this.customKeyStoreName, createCustomKeyStoreRequest.customKeyStoreName) && Objects.equals((Object)this.customKeyStoreType, (Object)createCustomKeyStoreRequest.customKeyStoreType) && Objects.equals(this.trustAnchorCertificate, createCustomKeyStoreRequest.trustAnchorCertificate) && Objects.equals(this.xksAccessKey, createCustomKeyStoreRequest.xksAccessKey) && Objects.equals((Object)this.xksProxyConnectivity, (Object)createCustomKeyStoreRequest.xksProxyConnectivity) && Objects.equals(this.xksProxyUriEndpoint, createCustomKeyStoreRequest.xksProxyUriEndpoint) && Objects.equals(this.xksProxyUriPath, createCustomKeyStoreRequest.xksProxyUriPath) && Objects.equals(this.xksProxyVpcEndpointServiceName, createCustomKeyStoreRequest.xksProxyVpcEndpointServiceName) && Objects.equals(this.xksSecretAccessKey, createCustomKeyStoreRequest.xksSecretAccessKey);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customKeyStoreName, this.customKeyStoreType, this.trustAnchorCertificate, this.xksAccessKey, this.xksProxyConnectivity, this.xksProxyUriEndpoint, this.xksProxyUriPath, this.xksProxyVpcEndpointServiceName, this.xksSecretAccessKey});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCustomKeyStoreRequest {\n");
        sb.append("    customKeyStoreName: ").append(this.toIndentedString(this.customKeyStoreName)).append("\n");
        sb.append("    customKeyStoreType: ").append(this.toIndentedString((Object)this.customKeyStoreType)).append("\n");
        sb.append("    trustAnchorCertificate: ").append(this.toIndentedString(this.trustAnchorCertificate)).append("\n");
        sb.append("    xksAccessKey: ").append(this.toIndentedString(this.xksAccessKey)).append("\n");
        sb.append("    xksProxyConnectivity: ").append(this.toIndentedString((Object)this.xksProxyConnectivity)).append("\n");
        sb.append("    xksProxyUriEndpoint: ").append(this.toIndentedString(this.xksProxyUriEndpoint)).append("\n");
        sb.append("    xksProxyUriPath: ").append(this.toIndentedString(this.xksProxyUriPath)).append("\n");
        sb.append("    xksProxyVpcEndpointServiceName: ").append(this.toIndentedString(this.xksProxyVpcEndpointServiceName)).append("\n");
        sb.append("    xksSecretAccessKey: ").append(this.toIndentedString(this.xksSecretAccessKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum XksProxyConnectivityEnum {
        PUBLIC_ENDPOINT("PUBLIC_ENDPOINT"),
        VPC_ENDPOINT_SERVICE("VPC_ENDPOINT_SERVICE");

        private String value;

        private XksProxyConnectivityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static XksProxyConnectivityEnum fromValue(String input) {
            for (XksProxyConnectivityEnum b : XksProxyConnectivityEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<XksProxyConnectivityEnum> {
            public void write(JsonWriter jsonWriter, XksProxyConnectivityEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public XksProxyConnectivityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return XksProxyConnectivityEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CustomKeyStoreTypeEnum {
        EXTERNALKEYSTORE("ExternalKeyStore");

        private String value;

        private CustomKeyStoreTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CustomKeyStoreTypeEnum fromValue(String input) {
            for (CustomKeyStoreTypeEnum b : CustomKeyStoreTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CustomKeyStoreTypeEnum> {
            public void write(JsonWriter jsonWriter, CustomKeyStoreTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public CustomKeyStoreTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CustomKeyStoreTypeEnum.fromValue(value);
            }
        }
    }
}

