/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.kms.model;

import com.google.gson.annotations.SerializedName;
import com.volcengine.kms.model.TagFilterForDescribeKeysInput;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;

public class DescribeKeysRequest {
    @SerializedName(value="CurrentPage")
    private Integer currentPage = null;
    @SerializedName(value="Filters")
    private String filters = null;
    @SerializedName(value="KeyringID")
    private String keyringID = null;
    @SerializedName(value="KeyringName")
    private String keyringName = null;
    @SerializedName(value="PageSize")
    private Integer pageSize = null;
    @SerializedName(value="TagFilters")
    private List<TagFilterForDescribeKeysInput> tagFilters = null;

    public DescribeKeysRequest currentPage(Integer currentPage) {
        this.currentPage = currentPage;
        return this;
    }

    @Min(value=1L)
    @Schema(description="")
    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public DescribeKeysRequest filters(String filters) {
        this.filters = filters;
        return this;
    }

    @Size(max=2048)
    @Schema(description="")
    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public DescribeKeysRequest keyringID(String keyringID) {
        this.keyringID = keyringID;
        return this;
    }

    @Schema(description="")
    public String getKeyringID() {
        return this.keyringID;
    }

    public void setKeyringID(String keyringID) {
        this.keyringID = keyringID;
    }

    public DescribeKeysRequest keyringName(String keyringName) {
        this.keyringName = keyringName;
        return this;
    }

    @Size(min=2, max=31)
    @Schema(description="")
    public String getKeyringName() {
        return this.keyringName;
    }

    public void setKeyringName(String keyringName) {
        this.keyringName = keyringName;
    }

    public DescribeKeysRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Min(value=1L)
    @Max(value=100L)
    @Schema(description="")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public DescribeKeysRequest tagFilters(List<TagFilterForDescribeKeysInput> tagFilters) {
        this.tagFilters = tagFilters;
        return this;
    }

    public DescribeKeysRequest addTagFiltersItem(TagFilterForDescribeKeysInput tagFiltersItem) {
        if (this.tagFilters == null) {
            this.tagFilters = new ArrayList<TagFilterForDescribeKeysInput>();
        }
        this.tagFilters.add(tagFiltersItem);
        return this;
    }

    @Valid
    @Schema(description="")
    public List<TagFilterForDescribeKeysInput> getTagFilters() {
        return this.tagFilters;
    }

    public void setTagFilters(List<TagFilterForDescribeKeysInput> tagFilters) {
        this.tagFilters = tagFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescribeKeysRequest describeKeysRequest = (DescribeKeysRequest)o;
        return Objects.equals(this.currentPage, describeKeysRequest.currentPage) && Objects.equals(this.filters, describeKeysRequest.filters) && Objects.equals(this.keyringID, describeKeysRequest.keyringID) && Objects.equals(this.keyringName, describeKeysRequest.keyringName) && Objects.equals(this.pageSize, describeKeysRequest.pageSize) && Objects.equals(this.tagFilters, describeKeysRequest.tagFilters);
    }

    public int hashCode() {
        return Objects.hash(this.currentPage, this.filters, this.keyringID, this.keyringName, this.pageSize, this.tagFilters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DescribeKeysRequest {\n");
        sb.append("    currentPage: ").append(this.toIndentedString(this.currentPage)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    keyringID: ").append(this.toIndentedString(this.keyringID)).append("\n");
        sb.append("    keyringName: ").append(this.toIndentedString(this.keyringName)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    tagFilters: ").append(this.toIndentedString(this.tagFilters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

