/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.rocketmq.model;

import com.google.gson.annotations.SerializedName;
import com.volcengine.rocketmq.model.AccessPolicyForCreateTopicInput;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class CreateTopicRequest {
    @SerializedName(value="AccessPolicies")
    private List<AccessPolicyForCreateTopicInput> accessPolicies = null;
    @SerializedName(value="Description")
    private String description = null;
    @SerializedName(value="InstanceId")
    private String instanceId = null;
    @SerializedName(value="MessageType")
    private Integer messageType = null;
    @SerializedName(value="QueueNumber")
    private Integer queueNumber = null;
    @SerializedName(value="TopicName")
    private String topicName = null;

    public CreateTopicRequest accessPolicies(List<AccessPolicyForCreateTopicInput> accessPolicies) {
        this.accessPolicies = accessPolicies;
        return this;
    }

    public CreateTopicRequest addAccessPoliciesItem(AccessPolicyForCreateTopicInput accessPoliciesItem) {
        if (this.accessPolicies == null) {
            this.accessPolicies = new ArrayList<AccessPolicyForCreateTopicInput>();
        }
        this.accessPolicies.add(accessPoliciesItem);
        return this;
    }

    @Valid
    @Schema(description="")
    public List<AccessPolicyForCreateTopicInput> getAccessPolicies() {
        return this.accessPolicies;
    }

    public void setAccessPolicies(List<AccessPolicyForCreateTopicInput> accessPolicies) {
        this.accessPolicies = accessPolicies;
    }

    public CreateTopicRequest description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateTopicRequest instanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    @NotNull
    @Schema(required=true, description="")
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public CreateTopicRequest messageType(Integer messageType) {
        this.messageType = messageType;
        return this;
    }

    @NotNull
    @Min(value=0L)
    @Max(value=4L)
    @Schema(required=true, description="")
    public Integer getMessageType() {
        return this.messageType;
    }

    public void setMessageType(Integer messageType) {
        this.messageType = messageType;
    }

    public CreateTopicRequest queueNumber(Integer queueNumber) {
        this.queueNumber = queueNumber;
        return this;
    }

    @NotNull
    @Min(value=1L)
    @Max(value=120L)
    @Schema(required=true, description="")
    public Integer getQueueNumber() {
        return this.queueNumber;
    }

    public void setQueueNumber(Integer queueNumber) {
        this.queueNumber = queueNumber;
    }

    public CreateTopicRequest topicName(String topicName) {
        this.topicName = topicName;
        return this;
    }

    @NotNull
    @Size(max=128)
    @Schema(required=true, description="")
    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTopicRequest createTopicRequest = (CreateTopicRequest)o;
        return Objects.equals(this.accessPolicies, createTopicRequest.accessPolicies) && Objects.equals(this.description, createTopicRequest.description) && Objects.equals(this.instanceId, createTopicRequest.instanceId) && Objects.equals(this.messageType, createTopicRequest.messageType) && Objects.equals(this.queueNumber, createTopicRequest.queueNumber) && Objects.equals(this.topicName, createTopicRequest.topicName);
    }

    public int hashCode() {
        return Objects.hash(this.accessPolicies, this.description, this.instanceId, this.messageType, this.queueNumber, this.topicName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTopicRequest {\n");
        sb.append("    accessPolicies: ").append(this.toIndentedString(this.accessPolicies)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    instanceId: ").append(this.toIndentedString(this.instanceId)).append("\n");
        sb.append("    messageType: ").append(this.toIndentedString(this.messageType)).append("\n");
        sb.append("    queueNumber: ").append(this.toIndentedString(this.queueNumber)).append("\n");
        sb.append("    topicName: ").append(this.toIndentedString(this.topicName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

