/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.vke.example;

import com.volcengine.ApiClient;
import com.volcengine.ApiException;
import com.volcengine.sign.Credentials;
import com.volcengine.vke.VkeApi;
import com.volcengine.vke.example.CreateCluster;
import com.volcengine.vke.example.CreateNodePool;
import com.volcengine.vke.example.GetCluster;
import com.volcengine.vke.example.GetNodePool;
import com.volcengine.vke.example.InstallAddon;
import com.volcengine.vke.example.ListNodes;
import com.volcengine.vke.example.UpdateNodePool;
import com.volcengine.vke.model.ItemForListClustersOutput;
import com.volcengine.vke.model.ItemForListNodePoolsOutput;
import com.volcengine.vke.model.ListNodesResponse;
import com.volcengine.vke.model.PodsConfigForCreateClusterInput;
import com.volcengine.vke.model.StatusForListClustersInput;
import com.volcengine.vke.model.StatusForListNodePoolsInput;

public class example {
    public static void main(String[] args) throws Exception {
        String ak = "your_ak";
        String sk = "your_sk";
        String region = "your_region";
        ApiClient apiClient = new ApiClient().setCredentials(Credentials.getCredentials((String)ak, (String)sk)).setRegion(region).setDisableSSL(true);
        VkeApi vkeApi = new VkeApi(apiClient);
        example.CreateFlannelVKE(vkeApi);
    }

    public static void CreateFlannelVKE(VkeApi vkeApi) throws Exception {
        example.CreateVKE(vkeApi, PodsConfigForCreateClusterInput.PodNetworkModeEnum.FLANNEL);
    }

    public static void CreateVpcCniVKE(VkeApi vkeApi) throws Exception {
        example.CreateVKE(vkeApi, PodsConfigForCreateClusterInput.PodNetworkModeEnum.VPCCNISHARED);
    }

    public static void CreateVKE(VkeApi vkeApi, PodsConfigForCreateClusterInput.PodNetworkModeEnum networkMode) throws Exception {
        ListNodesResponse nodes;
        String nodePoolID;
        String clusterID;
        String clusterName = "your_cluster_name";
        String subnetID = "your_subnet_id";
        String podCidr = "your_pod_cidr";
        String serviceCidr = "your_service_cidr";
        String nodePoolName = "your_node_pool_name";
        String instanceType = "your_instance_type";
        String password = "your_password";
        Boolean autoScaling = false;
        System.out.println("creating cluster");
        try {
            clusterID = CreateCluster.Call(vkeApi, new CreateCluster.Option().setClusterName(clusterName).setPodCidr(podCidr).setServiceCidr(serviceCidr).setSubnetID(subnetID).setNetworkMode(networkMode));
        }
        catch (ApiException e) {
            System.out.println(e.getResponseBody());
            return;
        }
        System.out.println("check cluster status");
        ItemForListClustersOutput cluster = null;
        while (cluster == null || cluster.getStatus().getPhase().equals(StatusForListClustersInput.PhaseEnum.CREATING.toString())) {
            try {
                cluster = GetCluster.Call(vkeApi, new GetCluster.Option().setClusterId(clusterID));
            }
            catch (ApiException e) {
                System.out.println(e.getResponseBody());
                return;
            }
            catch (GetCluster.ItemsCountException e) {
                System.out.println(e.getMessage());
                return;
            }
            if (cluster.getStatus() == null || cluster.getStatus().getPhase() == null) {
                System.out.println("cluster status or phase nil");
                return;
            }
            Thread.sleep(10000L);
        }
        System.out.println("create node pool");
        try {
            nodePoolID = CreateNodePool.Call(vkeApi, new CreateNodePool.Option().setClusterId(clusterID).setNodePoolName(nodePoolName).setInstanceType(instanceType).setPassword(password).setSubnetID(subnetID));
        }
        catch (ApiException e) {
            System.out.println(e.getResponseBody());
            return;
        }
        System.out.println("check node pool status");
        ItemForListNodePoolsOutput nodePool = null;
        while (nodePool == null || nodePool.getStatus().getPhase().equals(StatusForListNodePoolsInput.PhaseEnum.CREATING.toString())) {
            try {
                nodePool = GetNodePool.Call(vkeApi, new GetNodePool.Option().setNodePoolId(nodePoolID));
            }
            catch (ApiException e) {
                System.out.println(e.getResponseBody());
                return;
            }
            catch (GetNodePool.ItemsCountException e) {
                System.out.println(e.getMessage());
                return;
            }
            if (nodePool.getStatus() == null || nodePool.getStatus().getPhase() == null) {
                System.out.println("nodePool status or phase nil");
                return;
            }
            Thread.sleep(1000L);
        }
        System.out.println("node pool:");
        System.out.println(nodePool);
        System.out.println("list nodes");
        try {
            nodes = ListNodes.Call(vkeApi, new ListNodes.Option().setNodePoolId(nodePoolID));
        }
        catch (ApiException e) {
            System.out.println(e.getResponseBody());
            return;
        }
        System.out.println("node list:");
        System.out.println((Object)nodes);
        System.out.println("install addon");
        try {
            InstallAddon.Call(vkeApi, new InstallAddon.Option().setClusterId(clusterID));
        }
        catch (ApiException e) {
            System.out.println(e.getResponseBody());
            return;
        }
        System.out.println("update node number");
        try {
            UpdateNodePool.Call(vkeApi, new UpdateNodePool.Option().setClusterId(clusterID).setNodePoolId(nodePoolID).setAutoScaling(autoScaling));
        }
        catch (ApiException e) {
            System.out.println(e.getResponseBody());
            return;
        }
        System.out.println("check nodes count");
        while (nodes.getItems().size() == 0) {
            try {
                nodes = ListNodes.Call(vkeApi, new ListNodes.Option().setNodePoolId(nodePoolID));
            }
            catch (ApiException e) {
                System.out.println(e.getResponseBody());
                return;
            }
            Thread.sleep(1000L);
        }
        System.out.println("node list:");
        System.out.println((Object)nodes);
    }
}

