/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.vpc.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.volcengine.vpc.model.TagFilterForDescribeEipAddressesInput;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class DescribeEipAddressesRequest {
    @SerializedName(value="AllocationIds")
    private List<String> allocationIds = null;
    @SerializedName(value="AssociatedInstanceId")
    private String associatedInstanceId = null;
    @SerializedName(value="AssociatedInstanceType")
    private AssociatedInstanceTypeEnum associatedInstanceType = null;
    @SerializedName(value="BillingType")
    private Integer billingType = null;
    @SerializedName(value="EipAddresses")
    private List<String> eipAddresses = null;
    @SerializedName(value="ISP")
    private ISPEnum ISP = null;
    @SerializedName(value="MaxResults")
    private Integer maxResults = null;
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="NextToken")
    private String nextToken = null;
    @SerializedName(value="PageNumber")
    private Integer pageNumber = null;
    @SerializedName(value="PageSize")
    private Integer pageSize = null;
    @SerializedName(value="ProjectName")
    private String projectName = null;
    @SerializedName(value="SecurityProtectionEnabled")
    private Boolean securityProtectionEnabled = null;
    @SerializedName(value="Status")
    private StatusEnum status = null;
    @SerializedName(value="TagFilters")
    private List<TagFilterForDescribeEipAddressesInput> tagFilters = null;

    public DescribeEipAddressesRequest allocationIds(List<String> allocationIds) {
        this.allocationIds = allocationIds;
        return this;
    }

    public DescribeEipAddressesRequest addAllocationIdsItem(String allocationIdsItem) {
        if (this.allocationIds == null) {
            this.allocationIds = new ArrayList<String>();
        }
        this.allocationIds.add(allocationIdsItem);
        return this;
    }

    @Schema(description="")
    public List<String> getAllocationIds() {
        return this.allocationIds;
    }

    public void setAllocationIds(List<String> allocationIds) {
        this.allocationIds = allocationIds;
    }

    public DescribeEipAddressesRequest associatedInstanceId(String associatedInstanceId) {
        this.associatedInstanceId = associatedInstanceId;
        return this;
    }

    @Schema(description="")
    public String getAssociatedInstanceId() {
        return this.associatedInstanceId;
    }

    public void setAssociatedInstanceId(String associatedInstanceId) {
        this.associatedInstanceId = associatedInstanceId;
    }

    public DescribeEipAddressesRequest associatedInstanceType(AssociatedInstanceTypeEnum associatedInstanceType) {
        this.associatedInstanceType = associatedInstanceType;
        return this;
    }

    @Schema(description="")
    public AssociatedInstanceTypeEnum getAssociatedInstanceType() {
        return this.associatedInstanceType;
    }

    public void setAssociatedInstanceType(AssociatedInstanceTypeEnum associatedInstanceType) {
        this.associatedInstanceType = associatedInstanceType;
    }

    public DescribeEipAddressesRequest billingType(Integer billingType) {
        this.billingType = billingType;
        return this;
    }

    @Min(value=1L)
    @Max(value=3L)
    @Schema(description="")
    public Integer getBillingType() {
        return this.billingType;
    }

    public void setBillingType(Integer billingType) {
        this.billingType = billingType;
    }

    public DescribeEipAddressesRequest eipAddresses(List<String> eipAddresses) {
        this.eipAddresses = eipAddresses;
        return this;
    }

    public DescribeEipAddressesRequest addEipAddressesItem(String eipAddressesItem) {
        if (this.eipAddresses == null) {
            this.eipAddresses = new ArrayList<String>();
        }
        this.eipAddresses.add(eipAddressesItem);
        return this;
    }

    @Schema(description="")
    public List<String> getEipAddresses() {
        return this.eipAddresses;
    }

    public void setEipAddresses(List<String> eipAddresses) {
        this.eipAddresses = eipAddresses;
    }

    public DescribeEipAddressesRequest ISP(ISPEnum ISP) {
        this.ISP = ISP;
        return this;
    }

    @Schema(description="")
    public ISPEnum getISP() {
        return this.ISP;
    }

    public void setISP(ISPEnum ISP) {
        this.ISP = ISP;
    }

    public DescribeEipAddressesRequest maxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Min(value=1L)
    @Max(value=100L)
    @Schema(description="")
    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public DescribeEipAddressesRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DescribeEipAddressesRequest nextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    @Schema(description="")
    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeEipAddressesRequest pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Schema(description="")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public DescribeEipAddressesRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Max(value=100L)
    @Schema(description="")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public DescribeEipAddressesRequest projectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    @Schema(description="")
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public DescribeEipAddressesRequest securityProtectionEnabled(Boolean securityProtectionEnabled) {
        this.securityProtectionEnabled = securityProtectionEnabled;
        return this;
    }

    @Schema(description="")
    public Boolean isSecurityProtectionEnabled() {
        return this.securityProtectionEnabled;
    }

    public void setSecurityProtectionEnabled(Boolean securityProtectionEnabled) {
        this.securityProtectionEnabled = securityProtectionEnabled;
    }

    public DescribeEipAddressesRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(description="")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public DescribeEipAddressesRequest tagFilters(List<TagFilterForDescribeEipAddressesInput> tagFilters) {
        this.tagFilters = tagFilters;
        return this;
    }

    public DescribeEipAddressesRequest addTagFiltersItem(TagFilterForDescribeEipAddressesInput tagFiltersItem) {
        if (this.tagFilters == null) {
            this.tagFilters = new ArrayList<TagFilterForDescribeEipAddressesInput>();
        }
        this.tagFilters.add(tagFiltersItem);
        return this;
    }

    @Valid
    @Schema(description="")
    public List<TagFilterForDescribeEipAddressesInput> getTagFilters() {
        return this.tagFilters;
    }

    public void setTagFilters(List<TagFilterForDescribeEipAddressesInput> tagFilters) {
        this.tagFilters = tagFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescribeEipAddressesRequest describeEipAddressesRequest = (DescribeEipAddressesRequest)o;
        return Objects.equals(this.allocationIds, describeEipAddressesRequest.allocationIds) && Objects.equals(this.associatedInstanceId, describeEipAddressesRequest.associatedInstanceId) && Objects.equals((Object)this.associatedInstanceType, (Object)describeEipAddressesRequest.associatedInstanceType) && Objects.equals(this.billingType, describeEipAddressesRequest.billingType) && Objects.equals(this.eipAddresses, describeEipAddressesRequest.eipAddresses) && Objects.equals((Object)this.ISP, (Object)describeEipAddressesRequest.ISP) && Objects.equals(this.maxResults, describeEipAddressesRequest.maxResults) && Objects.equals(this.name, describeEipAddressesRequest.name) && Objects.equals(this.nextToken, describeEipAddressesRequest.nextToken) && Objects.equals(this.pageNumber, describeEipAddressesRequest.pageNumber) && Objects.equals(this.pageSize, describeEipAddressesRequest.pageSize) && Objects.equals(this.projectName, describeEipAddressesRequest.projectName) && Objects.equals(this.securityProtectionEnabled, describeEipAddressesRequest.securityProtectionEnabled) && Objects.equals((Object)this.status, (Object)describeEipAddressesRequest.status) && Objects.equals(this.tagFilters, describeEipAddressesRequest.tagFilters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allocationIds, this.associatedInstanceId, this.associatedInstanceType, this.billingType, this.eipAddresses, this.ISP, this.maxResults, this.name, this.nextToken, this.pageNumber, this.pageSize, this.projectName, this.securityProtectionEnabled, this.status, this.tagFilters});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DescribeEipAddressesRequest {\n");
        sb.append("    allocationIds: ").append(this.toIndentedString(this.allocationIds)).append("\n");
        sb.append("    associatedInstanceId: ").append(this.toIndentedString(this.associatedInstanceId)).append("\n");
        sb.append("    associatedInstanceType: ").append(this.toIndentedString((Object)this.associatedInstanceType)).append("\n");
        sb.append("    billingType: ").append(this.toIndentedString(this.billingType)).append("\n");
        sb.append("    eipAddresses: ").append(this.toIndentedString(this.eipAddresses)).append("\n");
        sb.append("    ISP: ").append(this.toIndentedString((Object)this.ISP)).append("\n");
        sb.append("    maxResults: ").append(this.toIndentedString(this.maxResults)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    projectName: ").append(this.toIndentedString(this.projectName)).append("\n");
        sb.append("    securityProtectionEnabled: ").append(this.toIndentedString(this.securityProtectionEnabled)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    tagFilters: ").append(this.toIndentedString(this.tagFilters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ATTACHING("Attaching"),
        DETACHING("Detaching"),
        ATTACHED("Attached"),
        AVAILABLE("Available");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String input) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ISPEnum {
        BGP("BGP"),
        SINGLELINE_BGP("SingleLine_BGP"),
        STATIC_BGP("Static_BGP"),
        FUSION_BGP("Fusion_BGP"),
        CHINAMOBILE("ChinaMobile"),
        CHINAUNICOM("ChinaUnicom"),
        CHINATELECOM("ChinaTelecom"),
        CHINAMOBILE_VALUE("ChinaMobile_Value"),
        CHINAUNICOM_VALUE("ChinaUnicom_Value"),
        CHINATELECOM_VALUE("ChinaTelecom_Value");

        private String value;

        private ISPEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ISPEnum fromValue(String input) {
            for (ISPEnum b : ISPEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ISPEnum> {
            public void write(JsonWriter jsonWriter, ISPEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ISPEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ISPEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AssociatedInstanceTypeEnum {
        NAT("Nat"),
        ECSINSTANCE("EcsInstance"),
        NETWORKINTERFACE("NetworkInterface"),
        CLBINSTANCE("ClbInstance"),
        ALBINSTANCE("AlbInstance");

        private String value;

        private AssociatedInstanceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AssociatedInstanceTypeEnum fromValue(String input) {
            for (AssociatedInstanceTypeEnum b : AssociatedInstanceTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AssociatedInstanceTypeEnum> {
            public void write(JsonWriter jsonWriter, AssociatedInstanceTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public AssociatedInstanceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AssociatedInstanceTypeEnum.fromValue(value);
            }
        }
    }
}

