/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.vpc.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.volcengine.vpc.model.PrefixListEntryForCreatePrefixListInput;
import com.volcengine.vpc.model.TagForCreatePrefixListInput;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class CreatePrefixListRequest {
    @SerializedName(value="ClientToken")
    private String clientToken = null;
    @SerializedName(value="Description")
    private String description = null;
    @SerializedName(value="DryRun")
    private Boolean dryRun = null;
    @SerializedName(value="IpVersion")
    private IpVersionEnum ipVersion = null;
    @SerializedName(value="MaxEntries")
    private Integer maxEntries = null;
    @SerializedName(value="PrefixListEntries")
    private List<PrefixListEntryForCreatePrefixListInput> prefixListEntries = null;
    @SerializedName(value="PrefixListName")
    private String prefixListName = null;
    @SerializedName(value="Tags")
    private List<TagForCreatePrefixListInput> tags = null;

    public CreatePrefixListRequest clientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    @Schema(description="")
    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public CreatePrefixListRequest description(String description) {
        this.description = description;
        return this;
    }

    @Size(min=1, max=255)
    @Schema(description="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreatePrefixListRequest dryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @Schema(description="")
    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public CreatePrefixListRequest ipVersion(IpVersionEnum ipVersion) {
        this.ipVersion = ipVersion;
        return this;
    }

    @Schema(description="")
    public IpVersionEnum getIpVersion() {
        return this.ipVersion;
    }

    public void setIpVersion(IpVersionEnum ipVersion) {
        this.ipVersion = ipVersion;
    }

    public CreatePrefixListRequest maxEntries(Integer maxEntries) {
        this.maxEntries = maxEntries;
        return this;
    }

    @NotNull
    @Schema(required=true, description="")
    public Integer getMaxEntries() {
        return this.maxEntries;
    }

    public void setMaxEntries(Integer maxEntries) {
        this.maxEntries = maxEntries;
    }

    public CreatePrefixListRequest prefixListEntries(List<PrefixListEntryForCreatePrefixListInput> prefixListEntries) {
        this.prefixListEntries = prefixListEntries;
        return this;
    }

    public CreatePrefixListRequest addPrefixListEntriesItem(PrefixListEntryForCreatePrefixListInput prefixListEntriesItem) {
        if (this.prefixListEntries == null) {
            this.prefixListEntries = new ArrayList<PrefixListEntryForCreatePrefixListInput>();
        }
        this.prefixListEntries.add(prefixListEntriesItem);
        return this;
    }

    @Valid
    @Schema(description="")
    public List<PrefixListEntryForCreatePrefixListInput> getPrefixListEntries() {
        return this.prefixListEntries;
    }

    public void setPrefixListEntries(List<PrefixListEntryForCreatePrefixListInput> prefixListEntries) {
        this.prefixListEntries = prefixListEntries;
    }

    public CreatePrefixListRequest prefixListName(String prefixListName) {
        this.prefixListName = prefixListName;
        return this;
    }

    @Size(min=1, max=128)
    @Schema(description="")
    public String getPrefixListName() {
        return this.prefixListName;
    }

    public void setPrefixListName(String prefixListName) {
        this.prefixListName = prefixListName;
    }

    public CreatePrefixListRequest tags(List<TagForCreatePrefixListInput> tags) {
        this.tags = tags;
        return this;
    }

    public CreatePrefixListRequest addTagsItem(TagForCreatePrefixListInput tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagForCreatePrefixListInput>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Valid
    @Schema(description="")
    public List<TagForCreatePrefixListInput> getTags() {
        return this.tags;
    }

    public void setTags(List<TagForCreatePrefixListInput> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePrefixListRequest createPrefixListRequest = (CreatePrefixListRequest)o;
        return Objects.equals(this.clientToken, createPrefixListRequest.clientToken) && Objects.equals(this.description, createPrefixListRequest.description) && Objects.equals(this.dryRun, createPrefixListRequest.dryRun) && Objects.equals((Object)this.ipVersion, (Object)createPrefixListRequest.ipVersion) && Objects.equals(this.maxEntries, createPrefixListRequest.maxEntries) && Objects.equals(this.prefixListEntries, createPrefixListRequest.prefixListEntries) && Objects.equals(this.prefixListName, createPrefixListRequest.prefixListName) && Objects.equals(this.tags, createPrefixListRequest.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientToken, this.description, this.dryRun, this.ipVersion, this.maxEntries, this.prefixListEntries, this.prefixListName, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePrefixListRequest {\n");
        sb.append("    clientToken: ").append(this.toIndentedString(this.clientToken)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    ipVersion: ").append(this.toIndentedString((Object)this.ipVersion)).append("\n");
        sb.append("    maxEntries: ").append(this.toIndentedString(this.maxEntries)).append("\n");
        sb.append("    prefixListEntries: ").append(this.toIndentedString(this.prefixListEntries)).append("\n");
        sb.append("    prefixListName: ").append(this.toIndentedString(this.prefixListName)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum IpVersionEnum {
        IPV4("IPv4"),
        IPV6("IPv6");

        private String value;

        private IpVersionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static IpVersionEnum fromValue(String input) {
            for (IpVersionEnum b : IpVersionEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<IpVersionEnum> {
            public void write(JsonWriter jsonWriter, IpVersionEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public IpVersionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return IpVersionEnum.fromValue(value);
            }
        }
    }
}

