/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.vpc.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.volcengine.vpc.model.TagFilterForDescribeBandwidthPackagesInput;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class DescribeBandwidthPackagesRequest {
    @SerializedName(value="BandwidthPackageIds")
    private List<String> bandwidthPackageIds = null;
    @SerializedName(value="BandwidthPackageName")
    private String bandwidthPackageName = null;
    @SerializedName(value="ISP")
    private ISPEnum ISP = null;
    @SerializedName(value="MaxResults")
    private Integer maxResults = null;
    @SerializedName(value="NextToken")
    private String nextToken = null;
    @SerializedName(value="PageNumber")
    private Integer pageNumber = null;
    @SerializedName(value="PageSize")
    private Integer pageSize = null;
    @SerializedName(value="ProjectName")
    private String projectName = null;
    @SerializedName(value="Protocol")
    private ProtocolEnum protocol = null;
    @SerializedName(value="SecurityProtectionEnabled")
    private Boolean securityProtectionEnabled = null;
    @SerializedName(value="TagFilters")
    private List<TagFilterForDescribeBandwidthPackagesInput> tagFilters = null;

    public DescribeBandwidthPackagesRequest bandwidthPackageIds(List<String> bandwidthPackageIds) {
        this.bandwidthPackageIds = bandwidthPackageIds;
        return this;
    }

    public DescribeBandwidthPackagesRequest addBandwidthPackageIdsItem(String bandwidthPackageIdsItem) {
        if (this.bandwidthPackageIds == null) {
            this.bandwidthPackageIds = new ArrayList<String>();
        }
        this.bandwidthPackageIds.add(bandwidthPackageIdsItem);
        return this;
    }

    @Schema(description="")
    public List<String> getBandwidthPackageIds() {
        return this.bandwidthPackageIds;
    }

    public void setBandwidthPackageIds(List<String> bandwidthPackageIds) {
        this.bandwidthPackageIds = bandwidthPackageIds;
    }

    public DescribeBandwidthPackagesRequest bandwidthPackageName(String bandwidthPackageName) {
        this.bandwidthPackageName = bandwidthPackageName;
        return this;
    }

    @Schema(description="")
    public String getBandwidthPackageName() {
        return this.bandwidthPackageName;
    }

    public void setBandwidthPackageName(String bandwidthPackageName) {
        this.bandwidthPackageName = bandwidthPackageName;
    }

    public DescribeBandwidthPackagesRequest ISP(ISPEnum ISP) {
        this.ISP = ISP;
        return this;
    }

    @Schema(description="")
    public ISPEnum getISP() {
        return this.ISP;
    }

    public void setISP(ISPEnum ISP) {
        this.ISP = ISP;
    }

    public DescribeBandwidthPackagesRequest maxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Min(value=1L)
    @Max(value=100L)
    @Schema(description="")
    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public DescribeBandwidthPackagesRequest nextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    @Schema(description="")
    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeBandwidthPackagesRequest pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Schema(description="")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public DescribeBandwidthPackagesRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Max(value=100L)
    @Schema(description="")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public DescribeBandwidthPackagesRequest projectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    @Schema(description="")
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public DescribeBandwidthPackagesRequest protocol(ProtocolEnum protocol) {
        this.protocol = protocol;
        return this;
    }

    @Schema(description="")
    public ProtocolEnum getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
    }

    public DescribeBandwidthPackagesRequest securityProtectionEnabled(Boolean securityProtectionEnabled) {
        this.securityProtectionEnabled = securityProtectionEnabled;
        return this;
    }

    @Schema(description="")
    public Boolean isSecurityProtectionEnabled() {
        return this.securityProtectionEnabled;
    }

    public void setSecurityProtectionEnabled(Boolean securityProtectionEnabled) {
        this.securityProtectionEnabled = securityProtectionEnabled;
    }

    public DescribeBandwidthPackagesRequest tagFilters(List<TagFilterForDescribeBandwidthPackagesInput> tagFilters) {
        this.tagFilters = tagFilters;
        return this;
    }

    public DescribeBandwidthPackagesRequest addTagFiltersItem(TagFilterForDescribeBandwidthPackagesInput tagFiltersItem) {
        if (this.tagFilters == null) {
            this.tagFilters = new ArrayList<TagFilterForDescribeBandwidthPackagesInput>();
        }
        this.tagFilters.add(tagFiltersItem);
        return this;
    }

    @Valid
    @Schema(description="")
    public List<TagFilterForDescribeBandwidthPackagesInput> getTagFilters() {
        return this.tagFilters;
    }

    public void setTagFilters(List<TagFilterForDescribeBandwidthPackagesInput> tagFilters) {
        this.tagFilters = tagFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescribeBandwidthPackagesRequest describeBandwidthPackagesRequest = (DescribeBandwidthPackagesRequest)o;
        return Objects.equals(this.bandwidthPackageIds, describeBandwidthPackagesRequest.bandwidthPackageIds) && Objects.equals(this.bandwidthPackageName, describeBandwidthPackagesRequest.bandwidthPackageName) && Objects.equals((Object)this.ISP, (Object)describeBandwidthPackagesRequest.ISP) && Objects.equals(this.maxResults, describeBandwidthPackagesRequest.maxResults) && Objects.equals(this.nextToken, describeBandwidthPackagesRequest.nextToken) && Objects.equals(this.pageNumber, describeBandwidthPackagesRequest.pageNumber) && Objects.equals(this.pageSize, describeBandwidthPackagesRequest.pageSize) && Objects.equals(this.projectName, describeBandwidthPackagesRequest.projectName) && Objects.equals((Object)this.protocol, (Object)describeBandwidthPackagesRequest.protocol) && Objects.equals(this.securityProtectionEnabled, describeBandwidthPackagesRequest.securityProtectionEnabled) && Objects.equals(this.tagFilters, describeBandwidthPackagesRequest.tagFilters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bandwidthPackageIds, this.bandwidthPackageName, this.ISP, this.maxResults, this.nextToken, this.pageNumber, this.pageSize, this.projectName, this.protocol, this.securityProtectionEnabled, this.tagFilters});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DescribeBandwidthPackagesRequest {\n");
        sb.append("    bandwidthPackageIds: ").append(this.toIndentedString(this.bandwidthPackageIds)).append("\n");
        sb.append("    bandwidthPackageName: ").append(this.toIndentedString(this.bandwidthPackageName)).append("\n");
        sb.append("    ISP: ").append(this.toIndentedString((Object)this.ISP)).append("\n");
        sb.append("    maxResults: ").append(this.toIndentedString(this.maxResults)).append("\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    projectName: ").append(this.toIndentedString(this.projectName)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString((Object)this.protocol)).append("\n");
        sb.append("    securityProtectionEnabled: ").append(this.toIndentedString(this.securityProtectionEnabled)).append("\n");
        sb.append("    tagFilters: ").append(this.toIndentedString(this.tagFilters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ProtocolEnum {
        IPV4("IPv4"),
        DUAL_STACK("Dual-stack"),
        IPV6("IPv6");

        private String value;

        private ProtocolEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ProtocolEnum fromValue(String input) {
            for (ProtocolEnum b : ProtocolEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ProtocolEnum> {
            public void write(JsonWriter jsonWriter, ProtocolEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ProtocolEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ProtocolEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ISPEnum {
        BGP("BGP"),
        SINGLELINE_BGP("SingleLine_BGP"),
        STATIC_BGP("Static_BGP"),
        FUSION_BGP("Fusion_BGP"),
        CHINAMOBILE("ChinaMobile"),
        CHINAUNICOM("ChinaUnicom"),
        CHINATELECOM("ChinaTelecom"),
        CHINAMOBILE_VALUE("ChinaMobile_Value"),
        CHINAUNICOM_VALUE("ChinaUnicom_Value"),
        CHINATELECOM_VALUE("ChinaTelecom_Value");

        private String value;

        private ISPEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ISPEnum fromValue(String input) {
            for (ISPEnum b : ISPEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ISPEnum> {
            public void write(JsonWriter jsonWriter, ISPEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ISPEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ISPEnum.fromValue(value);
            }
        }
    }
}

