/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.auth.AbstractAuthMethod;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class TokenAuthMethod
extends AbstractAuthMethod {
    private final int SORT_KEY = 30;
    private String apiKey;
    private String apiSecret;

    public TokenAuthMethod(String apiKey, String apiSecret) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
    }

    @Override
    public RequestBuilder apply(RequestBuilder request) {
        return request.addParameter("api_key", this.apiKey).addParameter("api_secret", this.apiSecret);
    }

    @Override
    public RequestBuilder applyAsBasicAuth(RequestBuilder request) {
        String headerValue = Base64.encodeBase64String((byte[])(this.apiKey + ":" + this.apiSecret).getBytes());
        BasicHeader authHeader = new BasicHeader("Authorization", "Basic " + headerValue);
        return request.addHeader((Header)authHeader);
    }

    @Override
    public RequestBuilder applyAsJsonProperties(RequestBuilder request) {
        HttpEntity entity = request.getEntity();
        try {
            ObjectNode json = (ObjectNode)new ObjectMapper().readTree(EntityUtils.toString((HttpEntity)entity));
            json.put("api_key", this.apiKey);
            json.put("api_secret", this.apiSecret);
            return request.setEntity((HttpEntity)new StringEntity(json.toString(), ContentType.APPLICATION_JSON));
        }
        catch (IOException e) {
            throw new VonageUnexpectedException("Failed to attach api key and secret to json.", e);
        }
    }

    @Override
    public int getSortKey() {
        return 30;
    }
}

